/******************************************************************************* 
 * Copyright (c) 2014 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/ 
package org.jboss.tools.common.text;

import org.eclipse.ui.texteditor.ITextEditor;

/**
 * Object to be included into TextProposal and used by
 * AutoContentAssistantProposal.apply()
 * to invoke its apply() instead of super.apply().
 * 
 * @author Viacheslav Kabanovich
 *
 */
public interface IExecutableTextProposal {

	/**
	 * Method is called by AutoContentAssistantProposal.apply()
	 * to invoke its apply() instead of super.apply().
	 * Implementation performs changes in text editor.
	 * Text between startOffset and endOffset is replaced
	 * with the text generated by proposal.
	 * 
	 * @param textEditor
	 * @param startOffset
	 * @param endOffset
	 */
	public void apply(ITextEditor textEditor, int startOffset, int endOffset);
}
