/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import tern.TernException;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.server.ITernServer;
import tern.server.ITernServerRequestProcessor;
import tern.server.protocol.ITernResultsAsyncCollector;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernResultsProcessorsFactory;

public class IDETernServerAsyncReqProcessor
extends Job
implements ITernServerRequestProcessor {
    private static final long TIMEOUT = 750L;
    private ITernResultsAsyncCollector collector;
    private TernDoc doc;
    private final ITernServer server;
    private boolean timedOut;

    public IDETernServerAsyncReqProcessor(ITernServer server) {
        super("Asynchronous server request job");
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processRequest(TernDoc doc, ITernResultsCollector c) throws TernException {
        if (!(c instanceof ITernResultsAsyncCollector)) {
            try {
                TernResultsProcessorsFactory.makeRequestAndProcess((TernDoc)doc, (ITernServer)this.server, (ITernResultsCollector)c);
                return;
            }
            catch (TernException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new TernException(t);
            }
        }
        collector = (ITernResultsAsyncCollector)c;
        start = System.currentTimeMillis();
        while (this.collector != null && System.currentTimeMillis() - start < 375L) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException v0) {
                break;
            }
        }
        var6_7 = this;
        synchronized (var6_7) {
            if (this.collector != null) {
                collector.timeout(ITernResultsAsyncCollector.TimeoutReason.PREV_OPERATION_NOT_FINISHED);
                return;
            }
            this.collector = collector;
            this.doc = doc;
            this.setName(this.collector.getRequestDisplayName());
            this.timedOut = false;
            this.schedule();
            // MONITOREXIT @DISABLED, blocks:[2, 5] lbl29 : MonitorExitStatement: MONITOREXIT : var6_7
            if (true) ** GOTO lbl38
        }
        do {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException v2) {
                break;
            }
lbl38:
            // 2 sources

        } while (this.collector == collector && System.currentTimeMillis() - start < 750L);
        var6_7 = this;
        synchronized (var6_7) {
            if (this.collector == collector) {
                collector.timeout(ITernResultsAsyncCollector.TimeoutReason.TIMED_OUT);
                this.timedOut = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("", -1);
            TernResultsProcessorsFactory.makeRequestAndProcess((TernDoc)this.doc, (ITernServer)this.server, (ITernResultsCollector)this.collector);
        }
        catch (Throwable e) {
            TernCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "tern.eclipse.ide.core", e.getMessage(), e));
        }
        IDETernServerAsyncReqProcessor iDETernServerAsyncReqProcessor = this;
        synchronized (iDETernServerAsyncReqProcessor) {
            if (!this.timedOut) {
                this.collector.done();
            }
            this.collector = null;
        }
        return Status.OK_STATUS;
    }
}

