/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import com.eclipsesource.json.JsonValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import tern.ITernProject;
import tern.TernException;
import tern.resources.ITernFileUploader;
import tern.server.IResponseHandler;
import tern.server.ITernServer;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernFile;

public class IDETernFileUploader
extends Job
implements ITernFileUploader {
    private static final int MAX_FILES = 30;
    private LinkedHashMap<String, TernFile> files = new LinkedHashMap();
    private ITernProject project;
    private boolean serverToBeDisposed;

    public IDETernFileUploader(ITernProject project) {
        super("Synchronizing script resources with Tern server...");
        this.project = project;
    }

    public void join(long timeout) {
        while (timeout > 0L && this.getState() != 0) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            timeout -= 25L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(String fileName) {
        LinkedHashMap<String, TernFile> linkedHashMap = this.files;
        synchronized (linkedHashMap) {
            return this.files.remove(fileName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(TernDoc doc) {
        if (doc.hasFiles()) {
            LinkedHashMap<String, TernFile> linkedHashMap = this.files;
            synchronized (linkedHashMap) {
                for (JsonValue val : doc.getFiles().values()) {
                    if (!(val instanceof TernFile)) continue;
                    TernFile file = (TernFile)val;
                    this.files.remove(file.getName());
                    this.files.put(file.getName(), file);
                }
                this.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverToBeDisposed() {
        this.cancel();
        this.serverToBeDisposed = true;
        try {
            LinkedHashMap<String, TernFile> linkedHashMap = this.files;
            synchronized (linkedHashMap) {
                this.files.clear();
            }
            this.join(2000L);
            if (this.getState() != 0) {
                this.project.handleException((Throwable)new Exception("Upload job could not be finished in 2sec. Continuing..."));
            }
        }
        finally {
            this.serverToBeDisposed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor mon) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        ITernServer server = this.project.getTernServer();
        do {
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            int i = 0;
            final TernDoc doc = new TernDoc();
            LinkedHashMap<String, TernFile> linkedHashMap = this.files;
            synchronized (linkedHashMap) {
                monitor.setWorkRemaining(this.files.size() + 1);
                Iterator<Map.Entry<String, TernFile>> it = this.files.entrySet().iterator();
                while (i < 30 && it.hasNext()) {
                    Map.Entry<String, TernFile> entry = it.next();
                    it.remove();
                    doc.addFile(entry.getValue());
                    ++i;
                }
            }
            if (!doc.hasFiles()) break;
            if (server == null) continue;
            try {
                server.request(doc, new IResponseHandler(){

                    public void onSuccess(Object data, String dataAsJsonString) {
                    }

                    public void onError(String error, Throwable t) {
                        IDETernFileUploader.this.project.handleException((Throwable)new TernException(error, t));
                        IDETernFileUploader.this.project.getFileSynchronizer().uploadFailed(doc);
                        throw new UploadFailed();
                    }

                    public boolean isDataAsJsonString() {
                        return false;
                    }
                });
                monitor.worked(i);
                continue;
            }
            catch (UploadFailed uploadFailed) {
                linkedHashMap = this.files;
                synchronized (linkedHashMap) {
                    TernDoc doc2 = new TernDoc();
                    for (TernFile tf : this.files.values()) {
                        doc2.addFile(tf);
                    }
                    this.files.clear();
                    this.project.getFileSynchronizer().uploadFailed(doc2);
                    this.cancel();
                }
            }
            return Status.CANCEL_STATUS;
        } while (!this.serverToBeDisposed);
        return Status.OK_STATUS;
    }

    private static final class UploadFailed
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private UploadFailed() {
        }
    }
}

