/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tern.ITernFile;
import tern.ITernFileSynchronizer;
import tern.ITernProject;
import tern.ITernResourcesManagerDelegate;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.resources.IDETernFile;
import tern.eclipse.ide.internal.core.resources.IDETernFileSynchronizer;
import tern.eclipse.ide.internal.core.resources.IDETernProject;
import tern.resources.FilesystemTernFile;
import tern.utils.ExtensionUtils;

public class IDEResourcesManager
implements ITernResourcesManagerDelegate {
    private static IDEResourcesManager instance = new IDEResourcesManager();

    private IDEResourcesManager() {
    }

    public static IDEResourcesManager getInstance() {
        return instance;
    }

    public ITernProject getTernProject(Object obj, boolean force) throws IOException {
        if (obj instanceof IProject) {
            IProject project;
            block8: {
                project = (IProject)obj;
                if (IDETernProject.hasTernNature(project) || force) break block8;
                return null;
            }
            try {
                IDETernProject ternProject;
                if (force && (ternProject = IDETernProject.getTernProject(project)) != null) {
                    ternProject.dispose();
                }
                if ((ternProject = IDETernProject.getTernProject(project)) == null) {
                    ternProject = new IDETernProject(project);
                    try {
                        ternProject.load();
                    }
                    catch (IOException e) {
                        Trace.trace((byte)3, "Error while loading tern project", e);
                        throw e;
                    }
                }
                return ternProject;
            }
            catch (CoreException ex) {
                Trace.trace((byte)3, "Error creating " + project.getName() + ": " + ex.getMessage(), ex);
            }
        }
        return null;
    }

    public ITernFile getTernFile(ITernProject project, String name) {
        File file;
        if (name.startsWith("external://")) {
            file = new File(name.substring("external://".length() + 1));
        } else if (name.startsWith("project://")) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(name.substring("project://".length() + 1)));
        } else {
            IProject ip = (IProject)project.getAdapter(IProject.class);
            file = ip.getFile(name);
        }
        return this.getTernFile(file);
    }

    public ITernFile getTernFile(Object fileObject) {
        if (fileObject instanceof File) {
            File file = (File)fileObject;
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
            if (files.length == 0) {
                return new FilesystemTernFile(file);
            }
            fileObject = files[0];
        }
        if (fileObject instanceof IFile) {
            return new IDETernFile((IFile)fileObject);
        }
        return null;
    }

    public ITernFileSynchronizer createTernFileSynchronizer(ITernProject project) {
        return new IDETernFileSynchronizer(project);
    }

    protected String getExtension(Object fileObject) {
        if (fileObject instanceof IFile) {
            return ((IFile)fileObject).getFileExtension();
        }
        if (fileObject instanceof ITernFile) {
            return ((ITernFile)fileObject).getFileExtension();
        }
        if (fileObject instanceof File) {
            return ExtensionUtils.getFileExtension((String)((File)fileObject).getName());
        }
        if (fileObject instanceof String) {
            return ExtensionUtils.getFileExtension((String)((String)fileObject));
        }
        return null;
    }

    public boolean isHTMLFile(Object fileObject) {
        String ext = this.getExtension(fileObject);
        return ext != null && ExtensionUtils.HTML_EXTENSIONS.contains(ext.toLowerCase());
    }

    public boolean isJSFile(Object fileObject) {
        String ext = this.getExtension(fileObject);
        return ext != null && "js".equals(ext.toLowerCase());
    }
}

