/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tern.ITernProject;
import tern.TernException;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.IWorkingCopy;
import tern.eclipse.ide.core.IWorkingCopyListener;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.core.WorkingCopyModuleList;
import tern.metadata.TernModuleMetadata;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.utils.TernModuleHelper;

public class WorkingCopy
implements IWorkingCopy {
    private final IIDETernProject project;
    private final List<IWorkingCopyListener> listeners;
    private final List<Object> callers;
    private List<ITernModule> checkedModules;
    private List<ITernModule> workingCopyModules;

    public WorkingCopy(IIDETernProject project) {
        this.project = project;
        this.callers = new ArrayList<Object>();
        this.listeners = new ArrayList<IWorkingCopyListener>();
    }

    @Override
    public void initialize() throws TernException {
        this.clear();
        List<ITernModule> allModules = this.project.getAllModules();
        this.workingCopyModules = TernModuleHelper.groupByType(allModules);
        WorkingCopyModuleList checkedModules = new WorkingCopyModuleList(this, TernCorePlugin.getTernRepositoryManager().getCheckedModules(this.project, this.workingCopyModules));
        this.setCheckedModules(checkedModules);
    }

    public List<ITernModule> getCheckedModules() {
        return this.checkedModules;
    }

    private void setCheckedModules(List<ITernModule> checkedModules) {
        this.checkedModules = checkedModules;
    }

    @Override
    public void call(Object caller) {
        if (!this.callers.contains(caller)) {
            this.callers.add(caller);
        }
    }

    @Override
    public boolean isDirty() {
        return this.callers.size() == 0;
    }

    @Override
    public void commit(Object caller) throws IOException {
        this.removeCaller(caller);
        if (this.isDirty()) {
            try {
                ITernRepository repository = this.project.getRepository();
                this.project.clearPlugins();
                this.project.clearLibs();
                Collection requiredDependencies = null;
                ITernModule dependencyModule = null;
                ArrayList<ITernModule> sortedModules = new ArrayList<ITernModule>();
                for (ITernModule module : this.getCheckedModules()) {
                    TernModuleMetadata metadata = module.getMetadata();
                    if (metadata != null) {
                        requiredDependencies = metadata.getRequiredDependencies(module.getVersion());
                        for (String dependency : requiredDependencies) {
                            dependencyModule = repository.getModule(dependency);
                            if (dependencyModule == null || sortedModules.contains(dependencyModule)) continue;
                            sortedModules.add(dependencyModule);
                        }
                    }
                    if (module == null || sortedModules.contains(module)) continue;
                    sortedModules.add(module);
                }
                TernModuleHelper.sort(sortedModules);
                for (ITernModule m : sortedModules) {
                    TernModuleHelper.update((ITernModule)m, (ITernProject)this.project);
                }
                this.project.save();
            }
            finally {
                this.clear();
            }
        }
    }

    @Override
    public void clear() {
        this.callers.clear();
        this.listeners.clear();
        if (this.checkedModules != null) {
            this.checkedModules.clear();
        }
    }

    private void removeCaller(Object caller) {
        this.callers.remove(caller);
    }

    @Override
    public boolean hasCheckedTernModule(String moduleName) {
        for (ITernModule checkedModule : this.checkedModules) {
            if (!moduleName.equals(checkedModule.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITernModule getTernModule(String moduleName) throws TernException {
        for (ITernModule module : this.workingCopyModules) {
            if (!moduleName.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkingCopyListener(IWorkingCopyListener listener) {
        IWorkingCopyListener iWorkingCopyListener = listener;
        synchronized (iWorkingCopyListener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkingCopyListener(IWorkingCopyListener listener) {
        IWorkingCopyListener iWorkingCopyListener = listener;
        synchronized (iWorkingCopyListener) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSelectionModules(ITernModule module, boolean selected) {
        List<IWorkingCopyListener> list = this.listeners;
        synchronized (list) {
            for (IWorkingCopyListener listener : this.listeners) {
                listener.moduleSelectionChanged(module, selected);
            }
        }
    }

    @Override
    public List<ITernModule> getAllModules() {
        return this.workingCopyModules;
    }

    @Override
    public IIDETernProject getProject() {
        return this.project;
    }
}

