/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import tern.TernException;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernRepositoryManager;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.preferences.TernCorePreferencesSupport;
import tern.eclipse.ide.internal.core.resources.IDETernProject;
import tern.repository.ITernRepository;
import tern.repository.TernRepository;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.utils.StringUtils;
import tern.utils.TernModuleHelper;

public class TernRepositoryManager
implements ITernRepositoryManager {
    private static final TernRepositoryManager INSTANCE = new TernRepositoryManager();
    private static TernRepository DEFAULT_REPOSITORY;
    private final Map<String, ITernRepository> repositories = new HashMap<String, ITernRepository>();

    public static TernRepositoryManager getManager() {
        return INSTANCE;
    }

    @Override
    public Collection<ITernRepository> getRepositories() {
        this.loadRepositoriesIfNeeded();
        return this.repositories.values();
    }

    private void loadRepositoriesIfNeeded() {
        if (this.repositories.size() == 0) {
            this.loadRepositories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRepositories() {
        Map<String, ITernRepository> map = this.repositories;
        synchronized (map) {
            this.repositories.clear();
            this.loadDefaultRepositories();
            this.loadCustomRepositories();
        }
    }

    private void loadDefaultRepositories() {
        this.addRepository(this.getDefaultRepository(), this.repositories);
    }

    private void loadCustomRepositories() {
        String values = new InstanceScope().getNode(TernCorePlugin.getDefault().getBundle().getSymbolicName()).get("repositories", null);
        if (!StringUtils.isEmpty((String)values)) {
            String[] s = values.split(";");
            String name = null;
            File ternFile = null;
            int i = 0;
            while (i < s.length / 2) {
                name = s[i];
                ternFile = new File(s[i + 1]);
                this.addRepository(new TernRepository(name, ternFile), this.repositories);
                ++i;
            }
        }
    }

    private TernRepository getDefaultRepository() {
        if (DEFAULT_REPOSITORY != null) {
            return DEFAULT_REPOSITORY;
        }
        try {
            DEFAULT_REPOSITORY = this.createDefaultRepository();
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Cannot load the default tern repository.", e);
        }
        return DEFAULT_REPOSITORY;
    }

    private synchronized TernRepository createDefaultRepository() throws TernException, IOException {
        if (DEFAULT_REPOSITORY != null) {
            return DEFAULT_REPOSITORY;
        }
        return new TernRepository("default", TernCorePlugin.getTernBaseDir(), true);
    }

    private void addRepository(TernRepository repository, Map<String, ITernRepository> repositories) {
        if (repository != null) {
            repositories.put(repository.getName(), (ITernRepository)repository);
        }
    }

    @Override
    public ITernRepository getRepository(String name) {
        this.loadRepositoriesIfNeeded();
        return this.repositories.get(name);
    }

    private ITernRepository getRepository(IIDETernProject ternProject) {
        return this.getRepository(ternProject != null ? ternProject.getProject() : null);
    }

    @Override
    public ITernRepository getRepository(IProject project) {
        ITernRepository repository;
        this.loadRepositoriesIfNeeded();
        String name = TernCorePreferencesSupport.getInstance().getUsedTernRepositoryName(project);
        if (!StringUtils.isEmpty((String)name) && (repository = this.getRepository(name)) != null) {
            return repository;
        }
        return this.getDefaultRepository();
    }

    @Override
    public void setRepositories(Collection<ITernRepository> repositories) {
        StringBuilder value = new StringBuilder();
        for (ITernRepository repository : repositories) {
            if (repository.isDefault()) continue;
            if (value.length() > 0) {
                value.append(";");
            }
            value.append(repository.getName());
            value.append(";");
            value.append(repository.getTernBaseDirAsString());
        }
        new InstanceScope().getNode(TernCorePlugin.getDefault().getBundle().getSymbolicName()).put("repositories", value.toString());
        this.loadRepositories();
    }

    @Override
    public List<ITernModule> getCheckedModules(IIDETernProject ternProject, List<ITernModule> allModules) {
        ArrayList<ITernModule> checkedModules = new ArrayList<ITernModule>();
        JsonValue options = null;
        JsonObject plugins = ternProject.getPlugins();
        for (String name : plugins.names()) {
            options = plugins.get(name);
            ITernModule plugin = this.findTernModule(name.toString(), ternProject);
            this.updateCheckedModule(plugin, options, allModules, checkedModules);
        }
        JsonArray defs = ternProject.getLibs();
        for (JsonValue name : defs) {
            ITernModule def = this.findTernModule(name.asString(), ternProject);
            this.updateCheckedModule(def, null, allModules, checkedModules);
        }
        return checkedModules;
    }

    @Override
    public List<ITernModule> getCheckedModules(String[] moduleNames, List<ITernModule> allModules, List<ITernModule> groupedModules) {
        ArrayList<ITernModule> checkedModules = new ArrayList<ITernModule>();
        String[] stringArray = moduleNames;
        int n = moduleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ITernModule module = this.findTernModule(name, allModules);
            this.updateCheckedModule(module, null, groupedModules, checkedModules);
            ++n2;
        }
        return checkedModules;
    }

    private void updateCheckedModule(ITernModule module, JsonValue options, List<ITernModule> allModules, List<ITernModule> checkedModules) {
        if (module != null) {
            if (!TernModuleHelper.isConfigurableModule((ITernModule)module)) {
                this.addModule(module, checkedModules);
            } else {
                try {
                    this.addModule((ITernModule)TernModuleHelper.findConfigurable((ITernModule)module, (JsonValue)options, allModules), checkedModules);
                }
                catch (TernException e) {
                    Trace.trace((byte)3, "Error while finding configurable module.", e);
                }
            }
        }
    }

    private void addModule(ITernModule module, List<ITernModule> checkedModules) {
        if (!checkedModules.contains(module)) {
            checkedModules.add(module);
        }
    }

    @Override
    public ITernModule findTernModule(String name, IIDETernProject ternProject) {
        ITernRepository repository = this.getRepository(ternProject);
        ITernModule m = repository.getModule(name);
        if (m != null) {
            return m;
        }
        if (ternProject != null) {
            List<ITernModule> projectModules = ternProject.getProjectModules();
            return this.findTernModule(name, projectModules);
        }
        return null;
    }

    private ITernModule findTernModule(String name, List<ITernModule> projectModules) {
        if (projectModules != null) {
            for (ITernModule module : projectModules) {
                if (!module.getName().equals(name)) continue;
                return module;
            }
        }
        return null;
    }

    @Override
    public ITernModule[] getTernModules(String moduleNames, IDETernProject ternProject) {
        ITernModule module = null;
        ArrayList<ITernModule> modules = new ArrayList<ITernModule>();
        String[] names = moduleNames.split(",");
        int i = 0;
        while (i < names.length) {
            module = this.findTernModule(names[i], ternProject);
            if (module != null) {
                this.addModule(module, modules);
            }
            ++i;
        }
        return modules.toArray(ITernPlugin.EMPTY_MODULE);
    }
}

