/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.eclipse.ide.core.ITernProjectLifecycleListener;
import tern.eclipse.ide.core.ITernProjectLifecycleListenerProvider;
import tern.eclipse.ide.core.ITernProjectLifecycleManager;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.resources.IDETernProject;

public class TernProjectLifecycleManager
implements ITernProjectLifecycleManager,
IRegistryChangeListener {
    private static final String EXTENSION_TERN_PROJECT_LIFECYCLE_LISTENERS = "ternProjectLifecycleListeners";
    private static final TernProjectLifecycleManager INSTANCE = new TernProjectLifecycleManager();
    private List<ITernProjectLifecycleListener> listeners = null;
    private boolean registryListenerIntialized = false;

    public static TernProjectLifecycleManager getManager() {
        return INSTANCE;
    }

    private synchronized void loadListeners() {
        if (this.listeners != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternProjectLifecycleListeners extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_PROJECT_LIFECYCLE_LISTENERS);
        ArrayList<ITernProjectLifecycleListener> list = new ArrayList<ITernProjectLifecycleListener>(cf.length);
        this.addListeners(cf, list);
        this.addRegistryListenerIfNeeded();
        this.listeners = list;
        Trace.trace((byte)7, "-<- Done loading .ternProjectLifecycleListeners extension point -<-");
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_PROJECT_LIFECYCLE_LISTENERS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleDelta(delta);
                ++n2;
            }
        }
    }

    protected void handleDelta(IExtensionDelta delta) {
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        if (delta.getKind() == 1) {
            ArrayList<ITernProjectLifecycleListener> list = new ArrayList<ITernProjectLifecycleListener>();
            this.addListeners(cf, list);
            this.listeners = list;
        }
    }

    private void addListeners(IConfigurationElement[] cf, List<ITernProjectLifecycleListener> list) {
        ITernProjectLifecycleListener listener = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                listener = ((ITernProjectLifecycleListenerProvider)ce.createExecutableExtension("class")).getListener();
                list.add(listener);
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error while adding tern project lifecycle listeners", e);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTernProjectLifeCycleListener(ITernProjectLifecycleListener listener) {
        this.loadListeners();
        ITernProjectLifecycleListener iTernProjectLifecycleListener = listener;
        synchronized (iTernProjectLifecycleListener) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTernProjectLifeCycleListener(ITernProjectLifecycleListener listener) {
        this.loadListeners();
        List<ITernProjectLifecycleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTernProjectLifeCycleListenerChanged(IDETernProject project, ITernProjectLifecycleListener.LifecycleEventType state) {
        this.loadListeners();
        List<ITernProjectLifecycleListener> list = this.listeners;
        synchronized (list) {
            for (ITernProjectLifecycleListener listener : this.listeners) {
                listener.handleEvent(project, state);
            }
        }
    }
}

