/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.ITernFile;
import tern.TernResourcesManager;
import tern.eclipse.ide.core.ITernFileConfiguration;
import tern.eclipse.ide.internal.core.Trace;
import tern.server.protocol.html.IScriptTagRegionProvider;
import tern.server.protocol.html.ScriptTagRegion;

public class TernFileConfigurationManager
implements IRegistryChangeListener,
IScriptTagRegionProvider {
    private static final String EXTENSION_TERN_FILE_CONFIGURATIONS = "ternFileConfigurations";
    private static final TernFileConfigurationManager INSTANCE = new TernFileConfigurationManager();
    private List<ITernFileConfiguration> ternFileConfigurations;
    private boolean registryListenerIntialized = false;

    public static TernFileConfigurationManager getManager() {
        return INSTANCE;
    }

    private TernFileConfigurationManager() {
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_FILE_CONFIGURATIONS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernServerConfigurationDelta(delta);
                ++n2;
            }
        }
    }

    public ITernFileConfiguration[] getTernFileConfigurations() {
        if (this.ternFileConfigurations == null) {
            this.loadTernServerConfigurations();
        }
        ITernFileConfiguration[] st = new ITernFileConfiguration[this.ternFileConfigurations.size()];
        this.ternFileConfigurations.toArray(st);
        return st;
    }

    private synchronized void loadTernServerConfigurations() {
        if (this.ternFileConfigurations != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternFileConfigurations extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_FILE_CONFIGURATIONS);
        ArrayList<ITernFileConfiguration> list = new ArrayList<ITernFileConfiguration>(cf.length);
        this.addTernServerConfigurations(cf, list);
        this.addRegistryListenerIfNeeded();
        this.ternFileConfigurations = list;
        Trace.trace((byte)7, "-<- Done loading .ternFileConfigurations extension point -<-");
    }

    private synchronized void addTernServerConfigurations(IConfigurationElement[] cf, List<ITernFileConfiguration> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add((ITernFileConfiguration)ce.createExecutableExtension("class"));
                Trace.trace((byte)7, "  Loaded console connectors: " + ce.getAttribute("class"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load console connectors: " + ce.getAttribute("class"), t);
            }
            ++n2;
        }
    }

    protected void handleTernServerConfigurationDelta(IExtensionDelta delta) {
        if (this.ternFileConfigurations == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<ITernFileConfiguration> list = new ArrayList<ITernFileConfiguration>(this.ternFileConfigurations);
        if (delta.getKind() == 1) {
            this.addTernServerConfigurations(cf, list);
        }
        this.ternFileConfigurations = list;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        if (this.ternFileConfigurations == null) {
            return;
        }
        this.ternFileConfigurations.clear();
        this.ternFileConfigurations = null;
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public ScriptTagRegion[] getScriptTags(ITernFile file) {
        ITernFileConfiguration[] configurations;
        if (!TernResourcesManager.isHTMLFile((Object)file)) {
            return null;
        }
        ScriptTagRegion[] tags = null;
        ITernFileConfiguration[] iTernFileConfigurationArray = configurations = this.getTernFileConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ITernFileConfiguration configuration = iTernFileConfigurationArray[n2];
            tags = configuration.getScriptTags(file);
            if (tags != null) {
                return tags;
            }
            ++n2;
        }
        return ScriptTagRegion.DEFAULT_SCRIPT_TAGS;
    }
}

