/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.eclipse.ide.core.ITernConsoleConnector;
import tern.eclipse.ide.internal.core.Trace;
import tern.server.ITernServer;

public class TernConsoleConnectorManager
implements IRegistryChangeListener {
    private static final String EXTENSION_TERN_CONSOLE_CONNECTORS = "ternConsoleConnectors";
    private static final TernConsoleConnectorManager INSTANCE = new TernConsoleConnectorManager();
    private List<ITernConsoleConnector> ternConsoleConnectors;
    private boolean registryListenerIntialized = false;

    public static TernConsoleConnectorManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_CONSOLE_CONNECTORS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernServerConfigurationDelta(delta);
                ++n2;
            }
        }
    }

    public ITernConsoleConnector[] getTernServerConfigurations() {
        if (this.ternConsoleConnectors == null) {
            this.loadTernServerConfigurations();
        }
        ITernConsoleConnector[] st = new ITernConsoleConnector[this.ternConsoleConnectors.size()];
        this.ternConsoleConnectors.toArray(st);
        return st;
    }

    private synchronized void loadTernServerConfigurations() {
        if (this.ternConsoleConnectors != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternConsoleConnectors extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_CONSOLE_CONNECTORS);
        ArrayList<ITernConsoleConnector> list = new ArrayList<ITernConsoleConnector>(cf.length);
        this.addTernServerConfigurations(cf, list);
        this.addRegistryListenerIfNeeded();
        this.ternConsoleConnectors = list;
        Trace.trace((byte)7, "-<- Done loading .ternConsoleConnectors extension point -<-");
    }

    private synchronized void addTernServerConfigurations(IConfigurationElement[] cf, List<ITernConsoleConnector> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add((ITernConsoleConnector)ce.createExecutableExtension("class"));
                Trace.trace((byte)7, "  Loaded console connectors: " + ce.getAttribute("class"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load console connectors: " + ce.getAttribute("class"), t);
            }
            ++n2;
        }
    }

    protected void handleTernServerConfigurationDelta(IExtensionDelta delta) {
        if (this.ternConsoleConnectors == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<ITernConsoleConnector> list = new ArrayList<ITernConsoleConnector>(this.ternConsoleConnectors);
        if (delta.getKind() == 1) {
            this.addTernServerConfigurations(cf, list);
        }
        this.ternConsoleConnectors = list;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        if (this.ternConsoleConnectors == null) {
            return;
        }
        this.ternConsoleConnectors.clear();
        this.ternConsoleConnectors = null;
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public ITernConsoleConnector getConnector(ITernServer server) {
        ITernConsoleConnector[] connectors;
        ITernConsoleConnector[] iTernConsoleConnectorArray = connectors = this.getTernServerConfigurations();
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            ITernConsoleConnector connector = iTernConsoleConnectorArray[n2];
            if (connector.isAdaptFor(server)) {
                return connector;
            }
            ++n2;
        }
        return null;
    }
}

