/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import tern.ITernResourcesManagerDelegate;
import tern.TernResourcesManager;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernProjectLifecycleListener;
import tern.eclipse.ide.core.ITernRepositoryManager;
import tern.eclipse.ide.core.ITernServerTypeManager;
import tern.eclipse.ide.internal.core.TernFileConfigurationManager;
import tern.eclipse.ide.internal.core.TernNatureAdaptersManager;
import tern.eclipse.ide.internal.core.TernProjectLifecycleManager;
import tern.eclipse.ide.internal.core.TernRepositoryManager;
import tern.eclipse.ide.internal.core.TernServerTypeManager;
import tern.eclipse.ide.internal.core.resources.IDEResourcesManager;
import tern.eclipse.ide.internal.core.resources.IDETernProject;
import tern.eclipse.ide.internal.core.resources.IDETernProjectSynchronizer;
import tern.internal.resources.InternalTernResourcesManager;
import tern.metadata.TernModuleMetadataManager;
import tern.server.nodejs.process.NodejsProcessManager;
import tern.server.protocol.html.IScriptTagRegionProvider;

public class TernCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "tern.eclipse.ide.core";
    private static TernCorePlugin plugin;

    public TernCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IDETernProjectSynchronizer.getInstance().initialize();
        TernModuleMetadataManager.getInstance().init(TernCorePlugin.getTernCoreBaseDir());
        TernFileConfigurationManager.getManager().initialize();
        InternalTernResourcesManager resMan = InternalTernResourcesManager.getInstance();
        resMan.setScriptTagRegionProvider((IScriptTagRegionProvider)TernFileConfigurationManager.getManager());
        resMan.setTernResourcesManagerDelegate((ITernResourcesManagerDelegate)IDEResourcesManager.getInstance());
    }

    public static File getTernCoreBaseDir() throws IOException {
        return FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"ternjs"));
    }

    public static File getTernBaseDir() throws IOException {
        return new File(FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"ternjs")), "node_modules/tern");
    }

    public void stop(BundleContext context) throws Exception {
        NodejsProcessManager.getInstance().dispose();
        TernServerTypeManager.getManager().destroy();
        TernNatureAdaptersManager.getManager().destroy();
        TernFileConfigurationManager.getManager().destroy();
        IDETernProjectSynchronizer.getInstance().dispose();
        plugin = null;
        super.stop(context);
    }

    public static boolean hasTernNature(IProject project) {
        return IDETernProject.hasTernNature(project);
    }

    public static IIDETernProject getTernProject(IProject project, boolean force) throws CoreException {
        try {
            return (IIDETernProject)TernResourcesManager.getTernProject((Object)project, (boolean)force);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "The project " + project.getName() + " cannot be converted as tern project.", (Throwable)e));
        }
    }

    public static IIDETernProject getTernProject(IProject project) throws CoreException {
        IIDETernProject result = (IIDETernProject)TernResourcesManager.getTernProject((Object)project);
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "The project " + project.getName() + " is not a tern project."));
        }
        return result;
    }

    public static TernCorePlugin getDefault() {
        return plugin;
    }

    public static ITernServerTypeManager getTernServerTypeManager() {
        return TernServerTypeManager.getManager();
    }

    public static void addTernProjectLifeCycleListener(ITernProjectLifecycleListener listener) {
        TernProjectLifecycleManager.getManager().addTernProjectLifeCycleListener(listener);
    }

    public static void removeTernProjectLifeCycleListener(ITernProjectLifecycleListener listener) {
        TernProjectLifecycleManager.getManager().removeTernProjectLifeCycleListener(listener);
    }

    public static ITernRepositoryManager getTernRepositoryManager() {
        return TernRepositoryManager.getManager();
    }
}

