/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;

public class NewHibernateMappingFilePage
extends WizardPage {
    private final Point IMAGE_SIZE = new Point(16, 16);
    private TableViewer viewer;
    private boolean hideFilename;
    private final ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
    private final Image hibMapping = HibernateConsolePlugin.getImageDescriptor((String)"icons/images/hibernate_mapping.gif").createImage();

    protected NewHibernateMappingFilePage(boolean hideFilename) {
        super("");
        this.hideFilename = hideFilename;
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.pack(false);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        FillLayout layout = new FillLayout();
        container.setLayout((Layout)layout);
        Table table = new Table(container, 68356);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.pack(false);
        this.createTableColumns(table);
        this.viewer = this.createTableViewer(table);
        this.viewer.setInput(null);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
    }

    public void setInput(Map<IJavaProject, Collection<EntityInfo>> project_infos) {
        this.viewer.setInput(project_infos);
        if (project_infos.size() == 1) {
            this.viewer.getTable().getColumn(3).setWidth(0);
        } else {
            this.viewer.getTable().getColumn(3).setWidth(120);
            this.viewer.getTable().getColumn(3).pack();
        }
        this.viewer.getTable().getColumn(1).pack();
        if (!this.hideFilename) {
            this.viewer.getTable().getColumn(2).pack();
        }
    }

    private void createTableColumns(Table table) {
        int coulmnIndex = 0;
        TableColumn column = new TableColumn(table, 0x1000000, coulmnIndex++);
        column.setText("!");
        column.setWidth(0);
        column.setResizable(false);
        column = new TableColumn(table, 16384, coulmnIndex++);
        column.setText(JdtUiMessages.NewHibernateMappingFilePage_class_name_column);
        column.setImage(this.registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, this.IMAGE_SIZE)));
        column.setWidth(200);
        if (!this.hideFilename) {
            column = new TableColumn(table, 16384, coulmnIndex++);
            column.setText(JdtUiMessages.NewHibernateMappingFilePage_file_name_column);
            column.setWidth(150);
            column.setImage(this.hibMapping);
        }
        column = new TableColumn(table, 16384, coulmnIndex++);
        column.setText(JdtUiMessages.NewHibernateMappingFilePage_project_name_column);
        column.setImage(this.registry.get((ImageDescriptor)new JavaElementImageDescriptor(JavaPlugin.getDefault().getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"), 0, this.IMAGE_SIZE)));
        column.setWidth(120);
    }

    private TableViewer createTableViewer(Table table) {
        TableViewer result = new TableViewer(table);
        result.setUseHashlookup(true);
        result.setColumnProperties(new String[]{Columns.CREATE.toString(), Columns.CLASS.toString(), Columns.FILE.toString(), Columns.PROJECT.toString()});
        CellEditor[] editors = new CellEditor[result.getColumnProperties().length];
        int coulmnIndex = 0;
        editors[coulmnIndex++] = new CheckboxCellEditor((Composite)result.getTable());
        editors[coulmnIndex++] = new TextCellEditor((Composite)result.getTable());
        editors[coulmnIndex++] = new TextCellEditor((Composite)result.getTable());
        if (!this.hideFilename) {
            editors[coulmnIndex++] = new TextCellEditor((Composite)result.getTable());
        }
        result.setCellEditors(editors);
        result.setCellModifier((ICellModifier)new TableCellModifier(result));
        result.setLabelProvider((IBaseLabelProvider)new TableLableProvider(result));
        result.setContentProvider((IContentProvider)new TableContentProvider());
        return result;
    }

    public void dispose() {
        this.hibMapping.dispose();
        super.dispose();
    }

    private static enum Columns {
        PROJECT,
        CLASS,
        FILE,
        CREATE;

    }

    private class TableCellModifier
    implements ICellModifier {
        private final TableViewer tv;

        public TableCellModifier(TableViewer tv) {
            this.tv = tv;
        }

        public boolean canModify(Object element, String property) {
            return false;
        }

        public Object getValue(Object element, String property) {
            if (Columns.CLASS.toString().equals(property)) {
                return ((TableLine)element).className;
            }
            if (Columns.PROJECT.toString().equals(property)) {
                return ((TableLine)element).project.getName();
            }
            if (Columns.FILE.toString().equals(property)) {
                return ((TableLine)element).fileName;
            }
            if (Columns.CREATE.toString().equals(property)) {
                return ((TableLine)element).isCreate;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableLine tl = (TableLine)((TableItem)element).getData();
            if (Columns.FILE.toString().equals(property)) {
                tl.fileName = (String)value;
            } else if (Columns.CREATE.toString().equals(property)) {
                tl.isCreate = (Boolean)value;
            }
            this.tv.update(new Object[]{tl}, new String[]{property});
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                ArrayList<TableLine> result = new ArrayList<TableLine>();
                Map configs = (Map)inputElement;
                for (Map.Entry entry : configs.entrySet()) {
                    for (EntityInfo ei : (Collection)entry.getValue()) {
                        result.add(new TableLine(((IJavaProject)entry.getKey()).getProject(), ei.getName()));
                    }
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final TableViewer tv;

        public TableLableProvider(TableViewer tv) {
            this.tv = tv;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String property = (String)this.tv.getColumnProperties()[columnIndex];
            TableLine tl = (TableLine)element;
            if (Columns.CLASS.toString().equals(property)) {
                return tl.className;
            }
            if (Columns.PROJECT.toString().equals(property)) {
                return tl.project.getName();
            }
            if (Columns.FILE.toString().equals(property)) {
                return tl.fileName;
            }
            return "";
        }
    }

    private class TableLine {
        public String className;
        public String fileName;
        public IProject project;
        public Boolean isCreate = true;

        public TableLine(IProject iProject, String className) {
            this(iProject, className, String.valueOf(className) + ".hbm.xml", true);
        }

        public TableLine(IProject iProject, String className, String fileName, boolean isCreate) {
            this.className = className;
            this.fileName = fileName;
            this.isCreate = isCreate;
            this.project = iProject;
        }

        public String toString() {
            return "TableLine [className=" + this.className + ", projectName=" + this.project.getName() + "]";
        }
    }
}

