/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.browsersim.browser.IBrowser;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.browsersim.ui.BrowserSimLogger;
import org.jboss.tools.browsersim.ui.MessageBoxWithLinks;
import org.jboss.tools.browsersim.ui.MessageBoxWithLinksForDebugger;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.model.Device;
import org.jboss.tools.browsersim.ui.model.SkinMap;
import org.jboss.tools.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.browsersim.ui.util.BrowserSimImageList;
import org.jboss.tools.browsersim.ui.util.LinuxUtil;

public class BrowserSimUtil {
    private static final String java7u51 = "1.7.0_51";
    private static final String java8 = "1.8.0";
    private static final String[] BROWSERSIM_ICONS = new String[]{"icons/browsersim_16px.png", "icons/browsersim_32px.png", "icons/browsersim_64px.png", "icons/browsersim_128px.png", "icons/browsersim_256px.png"};
    private static final String SWT_GTK3 = "SWT_GTK3";
    private static final String DISABLED = "0";

    private static void fixShellLocation(Shell shell) {
        int topOverlap;
        int leftOverlap;
        int rightOverlap;
        Rectangle allClientArea = shell.getMonitor().getClientArea();
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        int bottomOverlap = shellLocation.y + shellSize.y - (allClientArea.y + allClientArea.height);
        if (bottomOverlap > 0) {
            shellLocation.y = shellLocation.y > bottomOverlap ? (shellLocation.y -= bottomOverlap) : allClientArea.y;
        }
        if ((rightOverlap = shellLocation.x + shellSize.x - (allClientArea.x + allClientArea.width)) > 0) {
            shellLocation.x = shellLocation.x > rightOverlap ? (shellLocation.x -= rightOverlap) : allClientArea.x;
        }
        if ((leftOverlap = shellLocation.x - allClientArea.x) < 0) {
            shellLocation.x = shellLocation.x < leftOverlap ? (shellLocation.x -= leftOverlap) : allClientArea.x;
        }
        if ((topOverlap = shellLocation.y - allClientArea.y) < 0) {
            shellLocation.y = shellLocation.y < topOverlap ? (shellLocation.y -= topOverlap) : allClientArea.y;
        }
        shell.setLocation(shellLocation);
    }

    public static Rectangle getMonitorClientArea(Shell shell) {
        Rectangle clientArea = shell.getMonitor().getClientArea();
        Rectangle bounds = shell.getMonitor().getBounds();
        Monitor[] monitorArray = Display.getDefault().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            if (monitor.getBounds().intersects(shell.getBounds())) {
                bounds = monitor.getBounds();
            }
            ++n2;
        }
        clientArea.width = Math.min(clientArea.width, bounds.width);
        clientArea.height = Math.min(clientArea.height, bounds.height);
        return clientArea;
    }

    public static Point getSizeInDesktopPixels(Device device) {
        double pixelRatio = device.getPixelRatio();
        if (device.getPixelRatio() == 0.0) {
            pixelRatio = 1.0;
            RuntimeException e = new RuntimeException(Messages.BrowserSim_ZERO_PIXEL_RATIO);
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        int width = (int)Math.round((double)device.getWidth() / pixelRatio);
        int height = (int)Math.round((double)device.getHeight() / pixelRatio);
        return new Point(width, height);
    }

    public static Class<? extends BrowserSimSkin> getSkinClass(Device device, boolean useSkins) {
        return SkinMap.getInstance().getSkinClass(useSkins ? device.getSkinId() : null);
    }

    public static void showAboutDialog(Shell shell, String message, Image icon) {
        new MessageBoxWithLinks(shell, message, icon, Messages.BrowserSim_ABOUT_HEADER).open();
    }

    public static void showDevToolsDialog(Shell shell, String message, String url, Image icon) {
        new MessageBoxWithLinksForDebugger(shell, message, url, icon, Messages.BrowserSim_DEV_TOOLS_HEADER).open();
    }

    public static void addDisposeListener(Widget widget, final Resource disposable) {
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                disposable.dispose();
            }
        });
    }

    public static Shell getParentShell(BrowserSimSkin skin) {
        return "macosx".equals(PlatformUtil.getOs()) ? null : skin.getShell().getParent().getShell();
    }

    public static void setShellLocation(Shell shell, Point shellSize, Point location) {
        if (location != null && shellSize != null) {
            Rectangle browserSimArea = new Rectangle(location.x, location.y, shellSize.x, shellSize.y);
            if (shell.getDisplay().getClientArea().intersects(browserSimArea)) {
                shell.setLocation(location);
            }
            BrowserSimUtil.fixShellLocation(shell);
        }
    }

    public static void setCustomScrollbarStylesForWindows(IBrowser browser) {
        if ("win32".equals(PlatformUtil.getOs()) && !(browser instanceof JavaFXBrowser)) {
            browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    IBrowser browser = (IBrowser)event.widget;
                    if (browser != null) {
                        browser.execute("if (window._browserSim_customScrollBarStylesSetter === undefined) {window._browserSim_customScrollBarStylesSetter = function () {document.removeEventListener('DOMSubtreeModified', window._browserSim_customScrollBarStylesSetter, false);var head = document.head;var style = document.createElement('style');style.type = 'text/css';style.id='browserSimStyles';head.appendChild(style);style.innerText='::-webkit-scrollbar {width: 5px;height: 5px;}::-webkit-scrollbar-thumb {background: rgba(0,0,0,0.4); }::-webkit-scrollbar-corner, ::-webkit-scrollbar-thumb:window-inactive {background: rgba(0,0,0,0.0);};';};document.addEventListener('DOMSubtreeModified', window._browserSim_customScrollBarStylesSetter, false);}");
                    }
                }
            });
        }
    }

    public static void loadWebkitLibraries() {
        Shell tempShell = new Shell();
        String javaVersion = System.getProperty("java.version");
        if (java7u51.compareTo(javaVersion) > 0) {
            Browser tempSWTBrowser = new Browser((Composite)tempShell, 65536);
            new JavaFXBrowser((Composite)tempShell);
            tempSWTBrowser.dispose();
        } else {
            new JavaFXBrowser((Composite)tempShell);
            Browser tempSWTBrowser = new Browser((Composite)tempShell, 65536);
            tempSWTBrowser.dispose();
        }
    }

    public static boolean isRunningAgainstGTK2() {
        Map<String, String> env = System.getenv();
        String gtk3 = env.get(SWT_GTK3);
        return gtk3 != null && gtk3.equals(DISABLED);
    }

    private static Image[] initImages(Shell shell) {
        BrowserSimImageList imageList = new BrowserSimImageList((Widget)shell);
        Image[] icons = new Image[BROWSERSIM_ICONS.length];
        int i = 0;
        while (i < BROWSERSIM_ICONS.length) {
            icons[i] = imageList.getImage(BROWSERSIM_ICONS[i]);
            ++i;
        }
        return icons;
    }

    public static void setShellAttributes(Shell shell) {
        Image[] icons = BrowserSimUtil.initImages(shell);
        shell.setImages(icons);
        shell.setText(Messages.BrowserSim_BROWSER_SIM);
    }

    public static boolean isWebkitAvailable() {
        String os = PlatformUtil.getOs();
        if ("win32".equals(os)) {
            return BrowserSimUtil.isWindowsSwtWebkitInstalled();
        }
        if ("macosx".equals(os)) {
            return true;
        }
        if ("linux".equals(os)) {
            return BrowserSimUtil.isLinuxWebkitInstalled();
        }
        return false;
    }

    private static boolean isWindowsSwtWebkitInstalled() {
        String javaVersion = System.getProperty("java.version");
        if (java7u51.compareTo(javaVersion) <= 0 && java8.compareTo(javaVersion) > 0) {
            new JavaFXBrowser((Composite)new Shell());
        }
        if ("x86_64".equals(PlatformUtil.getArch())) {
            return false;
        }
        try {
            Method method = Class.forName("org.eclipse.swt.browser.WebKit").getDeclaredMethod("readInstallDir", String.class);
            method.setAccessible(true);
            String AASDirectory = (String)method.invoke(null, "SOFTWARE\\Apple Computer, Inc.\\Safari");
            if (AASDirectory != null && new File(AASDirectory = String.valueOf(AASDirectory) + "\\Apple Application Support").exists()) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isLinuxWebkitInstalled() {
        try {
            int micro;
            int minor;
            int major;
            boolean WEBKIT2;
            Library.loadLibrary((String)"swt-webkit");
            String webkit2 = System.getenv("SWT_WEBKIT2");
            boolean bl = WEBKIT2 = webkit2 != null && webkit2.equals("1") && BrowserSimUtil.isGTK3();
            if (WEBKIT2) {
                major = LinuxUtil.webkit_get_major_version();
                minor = LinuxUtil.webkit_get_minor_version();
                micro = LinuxUtil.webkit_get_micro_version();
            } else {
                major = LinuxUtil.webkit_major_version();
                minor = LinuxUtil.webkit_minor_version();
                micro = LinuxUtil.webkit_micro_version();
            }
            int[] nArray = new int[3];
            nArray[0] = 1;
            nArray[1] = 2;
            int[] MIN_VERSION = nArray;
            return major > MIN_VERSION[0] || major == MIN_VERSION[0] && minor > MIN_VERSION[1] || major == MIN_VERSION[0] && minor == MIN_VERSION[1] && micro >= MIN_VERSION[2];
        }
        catch (Throwable e) {
            BrowserSimLogger.logError(e.getMessage(), e);
            return false;
        }
    }

    public static boolean isGTK3() {
        if ("linux".equals(PlatformUtil.getOs())) {
            try {
                int GTK_VERSION = LinuxUtil.VERSION(LinuxUtil.gtk_major_version(), LinuxUtil.gtk_minor_version(), LinuxUtil.gtk_micro_version());
                return GTK_VERSION >= LinuxUtil.VERSION(3, 0, 0);
            }
            catch (Exception e) {
                BrowserSimLogger.logError(e.getMessage(), e);
                return false;
            }
        }
        return false;
    }
}

