/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.skin;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.browsersim.ui.skin.WidgetDescriptor;
import org.jboss.tools.browsersim.ui.util.BrowserSimImageList;

public class ImageDescriptor
extends WidgetDescriptor {
    protected String imageName;

    public ImageDescriptor(String imageName, int horizontalSpan, int verticalSpan, int stretching) {
        super(horizontalSpan, verticalSpan, stretching);
        this.imageName = imageName;
    }

    public ImageDescriptor(String imageName, int horizontalSpan, int verticalSpan) {
        this(imageName, horizontalSpan, verticalSpan, 0);
    }

    public ImageDescriptor(String imageName) {
        this(imageName, 1, 1);
    }

    public Composite createWidget(Composite parent, BrowserSimImageList imageList) {
        Composite composite = new Composite(parent, 0);
        boolean fillHorizontal = (this.getStretching() & 0x100) != 0;
        boolean fillVertical = (this.getStretching() & 0x200) != 0;
        GridData gridData = new GridData(fillHorizontal ? 4 : 0x1000000, fillVertical ? 4 : 0x1000000, fillHorizontal, fillVertical, this.getHorizontalSpan(), this.getVerticalSpan());
        String imageName = this.getImageName();
        if (imageName != null) {
            Image image = imageList.getImage(imageName);
            composite.setBackgroundImage(image);
            Rectangle bounds = image.getBounds();
            gridData.widthHint = fillHorizontal ? -1 : bounds.width;
            gridData.heightHint = fillVertical ? -1 : bounds.height;
        } else {
            composite.setBackground(parent.getDisplay().getSystemColor(1));
        }
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public String getImageName() {
        return this.imageName;
    }
}

