/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.skin;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

abstract class ControlImageDecorator<T extends Control> {
    protected T control;
    private Point verticalOrientationLocation;
    private Point horizontalOrientationLocation;
    private Image verticalOrientationEnabledImage;
    private Image verticalOrientationSelectedImage;
    private Image horizontalOrientationEnabledImage;
    private Image horizontalOrientationSelectedImage;
    private boolean vertical = true;
    private MouseTrackListener mouseTrackListener;

    public ControlImageDecorator(T control) {
        this.control = control;
    }

    public void setLocations(Point verticalOrientationLocation, Point horizontalOrientationLocation) {
        this.verticalOrientationLocation = verticalOrientationLocation;
        this.horizontalOrientationLocation = horizontalOrientationLocation;
    }

    public void setImages(Image verticalOrientationEnabledImage, Image verticalOrientationSelectedImage, Image horizontalOrientationEnabledImage, Image horizontalOrientationSelectedImage) {
        this.verticalOrientationEnabledImage = verticalOrientationEnabledImage;
        this.verticalOrientationSelectedImage = verticalOrientationSelectedImage;
        this.horizontalOrientationEnabledImage = horizontalOrientationEnabledImage;
        this.horizontalOrientationSelectedImage = horizontalOrientationSelectedImage;
        if (this.mouseTrackListener != null) {
            this.control.removeMouseTrackListener(this.mouseTrackListener);
            this.mouseTrackListener = null;
        }
        if (verticalOrientationEnabledImage != verticalOrientationSelectedImage || horizontalOrientationEnabledImage != horizontalOrientationSelectedImage) {
            this.control.addMouseTrackListener(this.getMouseTrackListener());
        }
    }

    public void setImages(Image enabledImage, Image selectedImage) {
        this.setImages(enabledImage, selectedImage, enabledImage, selectedImage);
    }

    public void setImages(Image image) {
        this.setImages(image, image);
    }

    private MouseTrackListener getMouseTrackListener() {
        if (this.mouseTrackListener == null) {
            this.mouseTrackListener = new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    ControlImageDecorator.this.setSelected(false);
                }

                public void mouseEnter(MouseEvent e) {
                    ControlImageDecorator.this.setSelected(true);
                }
            };
        }
        return this.mouseTrackListener;
    }

    private void setSelected(boolean selected) {
        if (selected) {
            if (this.vertical) {
                this.setImageCommon(this.verticalOrientationSelectedImage);
            } else {
                this.setImageCommon(this.horizontalOrientationSelectedImage);
            }
        } else if (this.vertical) {
            this.setImageCommon(this.verticalOrientationEnabledImage);
        } else {
            this.setImageCommon(this.horizontalOrientationEnabledImage);
        }
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        if (vertical) {
            this.control.setLocation(this.verticalOrientationLocation);
            this.setImageCommon(this.verticalOrientationEnabledImage);
        } else {
            this.control.setLocation(this.horizontalOrientationLocation);
            this.setImageCommon(this.horizontalOrientationEnabledImage);
        }
        this.setSelected(false);
    }

    public void setVisible(boolean enabled) {
        this.control.setVisible(enabled);
    }

    public boolean isVisible() {
        return this.control.isVisible();
    }

    private void setImageCommon(Image image) {
        Rectangle imageBounds = image.getBounds();
        this.control.setSize(imageBounds.width, imageBounds.height);
        this.setImage(image);
    }

    protected abstract void setImage(Image var1);
}

