/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.menu;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.ui.BrowserSim;
import org.jboss.tools.browsersim.ui.CocoaUIEnhancer;
import org.jboss.tools.browsersim.ui.ControlHandler;
import org.jboss.tools.browsersim.ui.ManageDevicesDialog;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.PreferencesWrapper;
import org.jboss.tools.browsersim.ui.menu.FileMenuCreator;
import org.jboss.tools.browsersim.ui.menu.ToolsMenuCreator;
import org.jboss.tools.browsersim.ui.model.Device;
import org.jboss.tools.browsersim.ui.model.preferences.CommonPreferences;
import org.jboss.tools.browsersim.ui.model.preferences.SpecificPreferences;
import org.jboss.tools.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.browsersim.ui.util.BrowserSimImageList;
import org.jboss.tools.browsersim.ui.util.BrowserSimUtil;
import org.jboss.tools.browsersim.ui.util.ManifestUtil;

public class BrowserSimMenuCreator {
    private static final String ABOUT_ICON = "icons/browsersim_32px.png";
    private BrowserSimSkin skin;
    private static CommonPreferences commonPreferences;
    private SpecificPreferences specificPreferences;
    private ControlHandler controlHandler;
    private String homeUrl;

    public BrowserSimMenuCreator(BrowserSimSkin skin, CommonPreferences cp, SpecificPreferences sp, ControlHandler controlHandler, String homeUrl) {
        this.skin = skin;
        commonPreferences = cp;
        this.specificPreferences = sp;
        this.controlHandler = controlHandler;
        this.homeUrl = homeUrl;
    }

    public void addMenuBar() {
        CocoaUIEnhancer cocoaUIEnhancer;
        Menu appMenuBar = this.skin.getMenuBar();
        if (appMenuBar != null) {
            MenuItem[] menuItemArray = appMenuBar.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
            this.createMenusForMenuBar(appMenuBar);
        }
        if ((cocoaUIEnhancer = CocoaUIEnhancer.getInstance()) != null) {
            this.addMacOsMenuApplicationHandler(cocoaUIEnhancer);
        }
    }

    public void createMenuItemsForContextMenu(Menu contextMenu) {
        contextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu contextMenu = (Menu)e.widget;
                MenuItem[] menuItemArray = contextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                BrowserSimMenuCreator.this.addUseSkinsItem(contextMenu);
                BrowserSimMenuCreator.this.addDevicesListForMenu(contextMenu);
                new MenuItem(contextMenu, 2);
                BrowserSimMenuCreator.this.addTurnMenuItems(contextMenu, BrowserSimMenuCreator.this.controlHandler);
                new MenuItem(contextMenu, 2);
                BrowserSimMenuCreator.this.addToolsItems(contextMenu, BrowserSimMenuCreator.this.skin, commonPreferences, BrowserSimMenuCreator.this.specificPreferences, BrowserSimMenuCreator.this.homeUrl);
                new MenuItem(contextMenu, 2);
                BrowserSimMenuCreator.this.addFileItemsToContextMenu(contextMenu, BrowserSimMenuCreator.this.skin, commonPreferences, BrowserSimMenuCreator.this.specificPreferences);
                if (!"macosx".equals(PlatformUtil.getOs())) {
                    new MenuItem(contextMenu, 2);
                    BrowserSimMenuCreator.this.addAboutItem(contextMenu);
                }
                new MenuItem(contextMenu, 2);
                BrowserSimMenuCreator.this.addExitItem(contextMenu, BrowserSimMenuCreator.this.skin.getShell());
            }
        });
    }

    private void createMenusForMenuBar(Menu appMenuBar) {
        Menu file = this.createDropDownMenu(appMenuBar, Messages.BrowserSim_FILE);
        this.addFileItemsToMenuBar(file, this.skin, commonPreferences, this.specificPreferences);
        if (!"macosx".equals(PlatformUtil.getOs())) {
            this.addExitItem(file, this.skin.getShell());
        }
        Menu devicesMenu = this.createDropDownMenu(appMenuBar, Messages.BrowserSim_DEVICE);
        devicesMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu devicesMenu = (Menu)e.widget;
                MenuItem[] menuItemArray = devicesMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                BrowserSimMenuCreator.this.addTurnMenuItems(devicesMenu, BrowserSimMenuCreator.this.controlHandler);
                new MenuItem(devicesMenu, 2);
                BrowserSimMenuCreator.this.addUseSkinsItem(devicesMenu);
                BrowserSimMenuCreator.this.addDevicesListForMenu(devicesMenu);
            }
        });
        Menu toolsMenu = this.createDropDownMenu(appMenuBar, Messages.BrowserSim_TOOLS);
        toolsMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu toolsMenu = (Menu)e.widget;
                MenuItem[] menuItemArray = toolsMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                BrowserSimMenuCreator.this.addToolsItems(toolsMenu, BrowserSimMenuCreator.this.skin, commonPreferences, BrowserSimMenuCreator.this.specificPreferences, BrowserSimMenuCreator.this.homeUrl);
            }
        });
        if (!"macosx".equals(PlatformUtil.getOs())) {
            Menu help = this.createDropDownMenu(appMenuBar, Messages.BrowserSim_HELP);
            this.addAboutItem(help);
        }
    }

    protected void addToolsItems(Menu contextMenu, BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences, String homeUrl) {
        ToolsMenuCreator.addDebugItem(contextMenu, skin, commonPreferences.getWeinreScriptUrl(), commonPreferences.getWeinreClientUrl(), specificPreferences.isJavaFx());
        ToolsMenuCreator.addScreenshotMenuItem(contextMenu, skin, commonPreferences);
        ToolsMenuCreator.addSyncronizedWindowItem(contextMenu, skin, commonPreferences.getDevices(), specificPreferences.getUseSkins(), specificPreferences.isEnableLiveReload(), specificPreferences.getLiveReloadPort(), specificPreferences.isEnableTouchEvents(), specificPreferences.getOrientationAngle(), homeUrl, specificPreferences.isJavaFx());
        ToolsMenuCreator.addLiveReloadItem(contextMenu, specificPreferences);
        ToolsMenuCreator.addTouchEventsItem(contextMenu, specificPreferences);
    }

    protected void addFileItemsToContextMenu(Menu menu, BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences) {
        new FileMenuCreator().addItemsToContextMenu(menu, skin, commonPreferences, specificPreferences);
    }

    protected void addFileItemsToMenuBar(Menu menu, BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences) {
        new FileMenuCreator().addItemsToMenuBar(menu, skin, commonPreferences, specificPreferences);
    }

    private Menu createDropDownMenu(Menu menuBar, String name) {
        MenuItem menuItem = new MenuItem(menuBar, 64);
        menuItem.setText(name);
        Menu dropdown = new Menu(menuBar);
        menuItem.setMenu(dropdown);
        return dropdown;
    }

    private void addDevicesListForMenu(Menu devicesMenu) {
        MenuItem skins = new MenuItem(devicesMenu, 64);
        skins.setText(Messages.BrowserSim_SKIN);
        Menu subMenu = new Menu(skins);
        for (Device device : commonPreferences.getDevices().values()) {
            MenuItem deviceMenuItem = new MenuItem(subMenu, 16);
            deviceMenuItem.setText(device.getName());
            deviceMenuItem.setData((Object)device.getId());
            if (device.getId().equals(this.specificPreferences.getSelectedDeviceId())) {
                deviceMenuItem.setSelection(true);
            }
            deviceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.widget;
                    if (menuItem.getSelection()) {
                        Device selected = commonPreferences.getDevices().get(menuItem.getData());
                        BrowserSimMenuCreator.this.specificPreferences.setSelectedDeviceId(selected.getId());
                        BrowserSimMenuCreator.this.specificPreferences.notifyObservers();
                    }
                }
            });
        }
        skins.setMenu(subMenu);
    }

    private void addUseSkinsItem(Menu menu) {
        MenuItem useSkinsMenuItem = new MenuItem(menu, 32);
        useSkinsMenuItem.setText(Messages.BrowserSim_USE_SKINS);
        useSkinsMenuItem.setSelection(this.specificPreferences.getUseSkins());
        useSkinsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.widget;
                BrowserSimMenuCreator.this.specificPreferences.setUseSkins(menuItem.getSelection());
                BrowserSimMenuCreator.this.specificPreferences.notifyObservers();
            }
        });
    }

    private void addTurnMenuItems(Menu menu, final ControlHandler controlHandler) {
        MenuItem turnLeft = new MenuItem(menu, 8);
        turnLeft.setText(Messages.BrowserSim_ROTATE_LEFT);
        turnLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                controlHandler.rotate(true);
            }
        });
        MenuItem turnRight = new MenuItem(menu, 8);
        turnRight.setText(Messages.BrowserSim_ROTATE_RIGHT);
        turnRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                controlHandler.rotate(false);
            }
        });
    }

    private void addAboutItem(Menu menu) {
        MenuItem about = new MenuItem(menu, 8);
        about.setText(Messages.BrowserSim_ABOUT);
        about.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell parentShell = e.display.getActiveShell();
                if (parentShell == null) {
                    parentShell = e.display.getShells()[0];
                }
                BrowserSimMenuCreator.this.showAboutDialog(parentShell);
            }
        });
    }

    private void addExitItem(Menu menu, final Shell shell) {
        MenuItem close = new MenuItem(menu, 8);
        close.setText(Messages.BrowserSim_CLOSE);
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        final ArrayList<BrowserSim> instances = new ArrayList<BrowserSim>(BrowserSim.getInstances());
        if (instances.size() > 1) {
            MenuItem closeOther = new MenuItem(menu, 8);
            closeOther.setText(Messages.BrowserSim_CLOSE_OTHER);
            closeOther.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (BrowserSim browserSim : instances) {
                        Shell source = ((MenuItem)e.widget).getParent().getShell();
                        if (source.equals(browserSim.getBrowser().getShell())) continue;
                        browserSim.getBrowser().getShell().close();
                    }
                }
            });
            MenuItem closeAll = new MenuItem(menu, 8);
            closeAll.setText(Messages.BrowserSim_CLOSE_ALL);
            closeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (BrowserSim browserSim : instances) {
                        browserSim.getBrowser().getShell().close();
                    }
                }
            });
        }
    }

    private void addMacOsMenuApplicationHandler(CocoaUIEnhancer cocoaUIEnhancer) {
        if (cocoaUIEnhancer != null) {
            cocoaUIEnhancer.setQuitAction(new Runnable(){

                @Override
                public void run() {
                    BrowserSimMenuCreator.this.skin.getShell().close();
                }
            });
            cocoaUIEnhancer.setAboutAction(new Runnable(){

                @Override
                public void run() {
                    BrowserSimMenuCreator.this.showAboutDialog(BrowserSimMenuCreator.this.getParentShell());
                }
            });
            cocoaUIEnhancer.setPreferencesAction(new Runnable(){

                @Override
                public void run() {
                    Shell shell = BrowserSimMenuCreator.this.getParentShell();
                    PreferencesWrapper pw = BrowserSimMenuCreator.this.openDialog(shell, commonPreferences, BrowserSimMenuCreator.this.specificPreferences, BrowserSimMenuCreator.this.skin.getBrowser().getUrl());
                    if (pw != null) {
                        commonPreferences.copyProperties(pw.getCommonPreferences());
                        BrowserSimMenuCreator.this.specificPreferences.copyProperties(pw.getSpecificPreferences());
                        commonPreferences.notifyObservers();
                        BrowserSimMenuCreator.this.specificPreferences.notifyObservers();
                    }
                }
            });
        }
    }

    private Shell getParentShell() {
        Display display = this.skin.getShell().getDisplay();
        if (display != null && display.getActiveShell() != null) {
            return display.getActiveShell();
        }
        if (this.skin != null && this.skin.getShell() != null) {
            return this.skin.getShell();
        }
        return new Shell();
    }

    private void showAboutDialog(Shell shell) {
        String message = "";
        String version = ManifestUtil.getManifestVersion(BrowserSim.class);
        message = version != null ? MessageFormat.format(Messages.BrowserSim_ABOUT_BROWSERSIM_MESSAGE, ManifestUtil.getManifestVersion(BrowserSim.class)) : MessageFormat.format(Messages.BrowserSim_ABOUT_BROWSERSIM_MESSAGE, "");
        BrowserSimImageList imageList = new BrowserSimImageList((Widget)shell);
        BrowserSimUtil.showAboutDialog(shell, message, imageList.getImage(ABOUT_ICON));
    }

    protected PreferencesWrapper openDialog(Shell parentShell, CommonPreferences commonPreferences, SpecificPreferences specificPreferences, String currentUrl) {
        return new ManageDevicesDialog(parentShell, 66800, commonPreferences, specificPreferences, currentUrl).open();
    }
}

