/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.ui.MessageBoxWithLinks;
import org.jboss.tools.browsersim.ui.Messages;

public class MessageBoxWithLinksForDebugger
extends MessageBoxWithLinks {
    private String url;

    public MessageBoxWithLinksForDebugger(Shell parent, String message, String url, Image icon, String header) {
        super(parent, message, icon, header);
        this.url = url;
    }

    @Override
    protected void addButtons() {
        Composite buttonsComposite = this.getButtonsComposite();
        Button copyLink = new Button(buttonsComposite, 8);
        Button ok = new Button(buttonsComposite, 8);
        copyLink.setText(Messages.ExceptionNotifier_COPY_LINK);
        copyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display display = Display.getDefault();
                Clipboard clipboard = new Clipboard(display);
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{MessageBoxWithLinksForDebugger.this.url}, new Transfer[]{textTransfer});
                clipboard.dispose();
            }
        });
        ok.setText(Messages.ExceptionNotifier_OK);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBoxWithLinksForDebugger.this.getShell().close();
            }
        });
        GridData copyLinkLayoutData = new GridData(0x1000008, 0x1000000, true, true);
        copyLinkLayoutData.widthHint = 100;
        copyLink.setLayoutData((Object)copyLinkLayoutData);
        GridData okLayoutData = new GridData(0x1000008, 0x1000000, true, true);
        okLayoutData.widthHint = 100;
        ok.setLayoutData((Object)okLayoutData);
        this.getShell().setDefaultButton(ok);
    }

    @Override
    protected Composite getButtonsComposite() {
        Composite buttonsComposite = new Composite(super.getButtonsComposite(), 0);
        GridData gridData = new GridData(0x1000008, 4, true, true);
        buttonsComposite.setLayoutData((Object)gridData);
        GridLayout buttonsCompositeLayout = new GridLayout(2, false);
        buttonsCompositeLayout.marginHeight = 10;
        buttonsCompositeLayout.marginWidth = 10;
        buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
        return buttonsComposite;
    }

    public String getUrl() {
        return this.url;
    }
}

