/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.jdt.launch;

import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.AbstractClassifierClasspathProvider;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbClientClassifierClasspathProvider
extends AbstractClassifierClasspathProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EjbClientClassifierClasspathProvider.class);

    public boolean applies(IMavenProjectFacade mavenProjectFacade, String classifier) {
        return this.getClassifier().equals(classifier) && JEEPackaging.EJB.getName().equals(mavenProjectFacade.getPackaging()) && this.generatesClient(mavenProjectFacade);
    }

    private boolean generatesClient(IMavenProjectFacade mavenProjectFacade) {
        Xpp3Dom generateClient;
        Xpp3Dom config;
        MavenProject mavenProject;
        try {
            mavenProject = mavenProjectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            LOG.error(Messages.ClassifierClasspathProvider_Error_Loading_Maven_Instance, (Throwable)ex);
            return false;
        }
        Plugin ejbPlugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-ejb-plugin");
        return ejbPlugin != null && (config = (Xpp3Dom)ejbPlugin.getConfiguration()) != null && (generateClient = config.getChild("generateClient")) != null && Boolean.parseBoolean(generateClient.getValue());
    }

    public String getClassifier() {
        return "client";
    }

    public void setRuntimeClasspath(Set<IRuntimeClasspathEntry> runtimeClasspath, IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor) throws CoreException {
        this.addMainFolder(runtimeClasspath, mavenProjectFacade, monitor);
    }

    public void setTestClasspath(Set<IRuntimeClasspathEntry> runtimeClasspath, IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor) throws CoreException {
        this.setRuntimeClasspath(runtimeClasspath, mavenProjectFacade, monitor);
    }

    public String getName() {
        return Messages.EjbClientClassifierClasspathProvider_EJB_Client_Classpath_Provider;
    }
}

