/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files.scp;

import com.jcraft.jsch.Session;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.rse.internal.services.ssh.Activator;
import org.eclipse.rse.internal.services.ssh.files.SshFileUtils;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissions;

public class ScpFileAttr {
    private String lsString;
    private String attrString = null;
    private int linkNo = 0;
    private long mTime = 0L;
    private String user = null;
    private String group = null;
    private long size = -1L;
    private String name = null;
    private String linkName = null;
    private boolean initialized = false;
    static final DateFormat lessThanSixMonthOldFormat = new SimpleDateFormat("MMM dd HH:mm");
    static final DateFormat moreThanSixMonthOldFormat = new SimpleDateFormat("MMM dd yyyy");
    static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static Pattern lsPattern = Pattern.compile("\\s+");

    public IHostFilePermissions getFilePermissions() {
        return new HostFilePermissions(this.getAttrs(), this.getUser(), this.getGroup());
    }

    public long getMTime() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.mTime;
    }

    public long getSize() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.size;
    }

    public String getUser() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.user;
    }

    public String getGroup() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.group;
    }

    public int getLinkNo() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.linkNo;
    }

    public String getName() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.name;
    }

    public String getLinkName() {
        if (!this.initialized) {
            this.doSplit();
        }
        return this.linkName;
    }

    public String getAttrs() {
        if (!this.initialized) {
            this.doSplit();
        }
        if (this.attrString == null || this.attrString.length() < 9) {
            return "---------";
        }
        return this.attrString;
    }

    private char getFileType() {
        String attrs = this.getAttrs();
        if (attrs == null || attrs.length() == 0) {
            return '\u0000';
        }
        return attrs.charAt(0);
    }

    public boolean isBlockDevice() {
        return this.getFileType() == 'b';
    }

    public boolean isCharDevice() {
        return this.getFileType() == 'c';
    }

    public boolean isLink() {
        return this.getFileType() == 'l';
    }

    public boolean isDirectory() {
        return this.getFileType() == 'd';
    }

    ScpFileAttr(String str) {
        this.lsString = str;
        if (this.lsString.endsWith("\n")) {
            this.lsString = this.lsString.substring(0, this.lsString.length() - 1);
        }
    }

    private void doSplit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            this.SplitAux();
        }
        catch (Exception e) {
            Activator.warn("ScpFileAttr:Exception occured while splitting  string " + this.lsString, e);
        }
    }

    static long parseDateTime(String date) {
        try {
            Date d = lessThanSixMonthOldFormat.parse(date);
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            c.set(1, Calendar.getInstance().get(1));
            return c.getTimeInMillis() / 1000L;
        }
        catch (Exception exception) {
            try {
                Date d = moreThanSixMonthOldFormat.parse(date);
                return d.getTime() / 1000L;
            }
            catch (Exception exception2) {
                try {
                    Date d = isoDateFormat.parse(date);
                    return d.getTime() / 1000L;
                }
                catch (Exception exception3) {
                    return 0L;
                }
            }
        }
    }

    public void SplitAux() throws Exception {
        Stack<String> fields = new Stack<String>();
        String[] lsPatterns = lsPattern.split(this.lsString);
        int i = 0;
        while (i < lsPatterns.length) {
            fields.insertElementAt(lsPatterns[i], 0);
            ++i;
        }
        if (fields.empty()) {
            return;
        }
        this.attrString = (String)fields.pop();
        if (fields.empty()) {
            return;
        }
        this.linkNo = Integer.parseInt((String)fields.pop());
        if (fields.empty()) {
            return;
        }
        this.user = (String)fields.pop();
        if (fields.empty()) {
            return;
        }
        this.group = (String)fields.pop();
        if (fields.empty()) {
            return;
        }
        if (!this.isCharDevice() && !this.isBlockDevice()) {
            this.size = Long.parseLong((String)fields.pop());
        } else {
            this.size = 0L;
            fields.pop();
            if (fields.empty()) {
                return;
            }
            fields.pop();
        }
        if (fields.empty()) {
            return;
        }
        String dateField = (String)fields.pop();
        if (fields.empty()) {
            return;
        }
        if ((dateField = String.valueOf(dateField) + " " + fields.pop()).lastIndexOf(45) == dateField.indexOf(45) || dateField.indexOf(58) == -1) {
            if (fields.empty()) {
                return;
            }
            dateField = String.valueOf(dateField) + " " + fields.pop();
        }
        this.mTime = ScpFileAttr.parseDateTime(dateField);
        String[] namesplit = Pattern.compile(String.valueOf(dateField.replaceAll(" ", "\\\\s+")) + "\\s").split(this.lsString);
        if (namesplit.length != 2) {
            return;
        }
        this.name = namesplit[1];
        if (this.isLink()) {
            namesplit = this.name.split(" -> ");
            if (namesplit.length != 2) {
                return;
            }
            this.name = namesplit[0];
            this.linkName = namesplit[1];
        }
    }

    public static ScpFileAttr getAttr(Session sess, String path) throws SystemMessageException {
        String attr = SshFileUtils.execCommandSafe(sess, "ls -land " + SshFileUtils.escapePath(path));
        if (attr == null || attr.length() < 9) {
            return null;
        }
        return new ScpFileAttr(attr);
    }
}

