/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui.ejb3;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.ejb3.EJB30SupportVerifier;
import org.jboss.ide.eclipse.as.classpath.ui.Messages;
import org.jboss.ide.eclipse.as.classpath.ui.ejb3.JBossSelectionPage;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;

public class JBossEJB3LibrariesPage
extends JBossSelectionPage
implements IClasspathContainerPage {
    private IClasspathEntry classpathEntry;

    public JBossEJB3LibrariesPage() {
        this.setTitle(Messages.ejb3ClasspathPageTitle);
        this.setDescription(Messages.ejb3ClasspathPageDescription);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.servers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JBossEJB3LibrariesPage.this.validateSelection();
            }
        });
    }

    protected void validateSelection() {
        if (!this.jbossServerHasEJB3(this.jbossServer)) {
            String error = MessageFormat.format(Messages.JBossEJB3LibrariesPage_ConfigurationDoesNotContainEJB3Libraries, this.jbossServer.getServer().getName());
            this.setErrorMessage(error);
            this.getContainer().updateButtons();
        } else {
            this.setErrorMessage(null);
        }
    }

    private boolean jbossServerHasEJB3(JBossServer jbossServer) {
        return EJB30SupportVerifier.verify((IRuntime)jbossServer.getServer().getRuntime());
    }

    public boolean finish() {
        if (this.jbossServer != null && this.jbossServerHasEJB3(this.jbossServer)) {
            this.classpathEntry = JavaCore.newContainerEntry((IPath)new Path("org.jboss.ide.eclipse.as.classpath.core.ejb3.classpathContainer").append(this.jbossServer.getServer().getName()), (boolean)true);
            return true;
        }
        return false;
    }

    public boolean isPageComplete() {
        return this.jbossServer != null && this.isCurrentPage() && this.jbossServerHasEJB3(this.jbossServer);
    }

    public IClasspathEntry getSelection() {
        return this.classpathEntry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.classpathEntry = containerEntry;
    }
}

