/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui.containers.custom;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.LayeredProductPathProvider;
import org.jboss.ide.eclipse.as.core.server.jbossmodules.LayeredModulePathFactory;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;

public class LayeredPathProviderFragment
extends WizardFragment {
    private static String KEY_PRESS = "Ctrl+Space";
    private IWizardHandle handle;
    private Text moduleText;
    private Text slotText;
    private String moduleId;
    private String slot;
    private AvailableModuleSlotsModel model;

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.setComplete(false);
        this.handle = handle;
        handle.setTitle("Create a JBoss modules classpath entry.");
        handle.setDescription("This classpath entry will search all available modules folders for the chosen module.This ensures patches are picked up properly. Example: module name = javax.faces.api,  slot=1.2");
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        Label moduleLabel = new Label(c, 0);
        moduleLabel.setText("Module ID: ");
        this.moduleText = new Text(c, 2052);
        Label slotLabel = new Label(c, 0);
        slotLabel.setText("Slot: ");
        this.slotText = new Text(c, 2052);
        this.slotText.setText("main");
        GridData gd = new GridData(1, 0x1000000, true, false);
        gd.widthHint = 200;
        this.moduleText.setLayoutData((Object)gd);
        this.slotText.setLayoutData((Object)gd);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LayeredPathProviderFragment.this.moduleId = LayeredPathProviderFragment.this.moduleText == null ? null : LayeredPathProviderFragment.this.moduleText.getText();
                LayeredPathProviderFragment.this.setComplete(LayeredPathProviderFragment.this.moduleId != null && LayeredPathProviderFragment.this.moduleId.length() > 0);
                LayeredPathProviderFragment.this.handle.update();
            }
        };
        this.moduleText.addModifyListener(ml);
        ModifyListener slotml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LayeredPathProviderFragment.this.slot = LayeredPathProviderFragment.this.slotText == null ? null : LayeredPathProviderFragment.this.slotText.getText();
                LayeredPathProviderFragment.this.handle.update();
            }
        };
        this.slotText.addModifyListener(slotml);
        this.setAutoCompletionSlot(this.slotText, null);
        this.setAutoCompletionModule(this.moduleText, null);
        this.slotText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                LayeredPathProviderFragment.this.setAutoCompletionSlot(LayeredPathProviderFragment.this.slotText, LayeredPathProviderFragment.this.slotText.getText());
            }
        });
        this.moduleText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                LayeredPathProviderFragment.this.setAutoCompletionModule(LayeredPathProviderFragment.this.moduleText, LayeredPathProviderFragment.this.moduleText.getText());
            }
        });
        this.handle.update();
        return c;
    }

    private String[] getModuleProposals(String text) {
        IRuntimeType rtt;
        if (this.model == null) {
            this.model = new AvailableModuleSlotsModel();
        }
        String rtType = (rtt = (IRuntimeType)this.getTaskModel().getObject("rtType")) == null ? null : rtt.getId();
        ModuleSlot[] all = this.model.getModuleSlots(rtType, true);
        HashSet<String> filtered = new HashSet<String>();
        int i = 0;
        while (i < all.length) {
            if (all[i].getModule().startsWith(text)) {
                filtered.add(all[i].getModule());
            }
            ++i;
        }
        ArrayList list = new ArrayList(filtered);
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    private String[] getSlotProposals(String text) {
        IRuntimeType rtt;
        if (this.model == null) {
            this.model = new AvailableModuleSlotsModel();
        }
        String rtType = (rtt = (IRuntimeType)this.getTaskModel().getObject("rtType")) == null ? null : rtt.getId();
        ModuleSlot[] all = this.model.getModuleSlots(rtType, true);
        HashSet<String> slots = new HashSet<String>();
        int i = 0;
        while (i < all.length) {
            if (all[i].getModule().equals(this.moduleText.getText())) {
                slots.add(all[i].getSlot());
            }
            ++i;
        }
        return slots.toArray(new String[slots.size()]);
    }

    private void setAutoCompletionSlot(Text text, String value) {
        this.setAutoCompletion(text, value, this.getSlotProposals(value));
    }

    private void setAutoCompletionModule(Text text, String value) {
        this.setAutoCompletion(text, value, this.getModuleProposals(value));
    }

    private void setAutoCompletion(Text text, String value, String[] possible) {
        try {
            ContentProposalAdapter adapter = null;
            SimpleContentProposalProvider scp = new SimpleContentProposalProvider(possible);
            scp.setProposals(possible);
            KeyStroke ks = KeyStroke.getInstance((String)KEY_PRESS);
            adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scp, ks, null);
            adapter.setProposalAcceptanceStyle(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        LayeredProductPathProvider prov = new LayeredProductPathProvider(this.moduleId, this.slot);
        this.getTaskModel().putObject("createdProvider", (Object)prov);
    }

    private class AvailableModuleSlotsModel {
        private HashMap<String, Job> loading = new HashMap();
        private HashMap<String, Set<ModuleSlot>> slots = new HashMap();

        boolean isLoaded(String runtimeType) {
            return this.slots.get(runtimeType) != null;
        }

        boolean isLoading(String runtimeType) {
            return this.loading.get(runtimeType) != null;
        }

        ModuleSlot[] getModuleSlots(String rtType, boolean load) {
            if (this.isLoaded(rtType)) {
                Set<ModuleSlot> ret = this.slots.get(rtType);
                return ret.toArray(new ModuleSlot[ret.size()]);
            }
            if (!this.isLoading(rtType) && load) {
                this.fireLoad(rtType);
            }
            return new ModuleSlot[0];
        }

        private void fireLoad(final String rtType) {
            Job j = new Job("Loading Modules"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IRuntime[] rt = ServerCore.getRuntimes();
                        HashSet<ModuleSlot> ms = new HashSet<ModuleSlot>();
                        int i = 0;
                        while (i < rt.length) {
                            if (rt[i].getRuntimeType().getId().equals(rtType)) {
                                IPath modulesFolder = rt[i].getLocation().append("modules");
                                File[] layeredPaths = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modulesFolder.toFile()});
                                int j = 0;
                                while (j < layeredPaths.length) {
                                    ArrayList<File> ignored = new ArrayList<File>(Arrays.asList(layeredPaths));
                                    ignored.remove(layeredPaths[j]);
                                    ModuleSlot[] slots = this.findSlots(layeredPaths[j], ignored);
                                    ms.addAll(Arrays.asList(slots));
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        AvailableModuleSlotsModel.this.slots.put(rtType, ms);
                    }
                    finally {
                        AvailableModuleSlotsModel.this.loading.remove(rtType);
                    }
                    return Status.OK_STATUS;
                }

                private ModuleSlot[] findSlots(File root, List<File> ignored) {
                    HashSet<ModuleSlot> collector = new HashSet<ModuleSlot>();
                    this.findSlots(collector, root, root, ignored);
                    return collector.toArray(new ModuleSlot[collector.size()]);
                }

                private void findSlots(Set<ModuleSlot> collector, File working, File root, List<File> ignored) {
                    if (ignored.contains(working)) {
                        return;
                    }
                    if (working.isFile()) {
                        if (working.getName().equals("module.xml")) {
                            int rootSegCount = new Path(root.getAbsolutePath()).segmentCount();
                            IPath relative = new Path(working.getAbsolutePath()).removeFirstSegments(rootSegCount);
                            relative = relative.removeLastSegments(1);
                            String slot = relative.lastSegment();
                            IPath module = relative.removeLastSegments(1);
                            StringBuffer modBuffer = new StringBuffer();
                            int i = 0;
                            while (i < module.segmentCount()) {
                                modBuffer.append(module.segment(i));
                                if (i < module.segmentCount() - 1) {
                                    modBuffer.append(".");
                                }
                                ++i;
                            }
                            ModuleSlot ms = new ModuleSlot(modBuffer.toString(), slot);
                            collector.add(ms);
                        }
                    } else {
                        File[] kids = working.listFiles();
                        int i = 0;
                        while (i < kids.length) {
                            this.findSlots(collector, kids[i], root, ignored);
                            ++i;
                        }
                    }
                }
            };
            this.loading.put(rtType, j);
            j.schedule();
        }
    }
}

