/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.ws.creation.core.commands.MergeWebXMLCommand;
import org.jboss.tools.ws.creation.core.commands.ServiceCreationCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.JBossWSAnnotatedClassWizardPage;

public class JBossWSAnnotatedClassWizard
extends Wizard
implements INewWizard {
    private static final String JDT_EDITOR = "org.eclipse.jdt.ui.CompilationUnitEditor";
    public static String WSNAMEDEFAULT = "HelloWorld";
    public static String PACKAGEDEFAULT = "org.jboss.samples.webservices";
    public static String WSCLASSDEFAULT = "HelloWorld";
    private String serviceName = WSNAMEDEFAULT;
    private String packageName = PACKAGEDEFAULT;
    private String className = WSCLASSDEFAULT;
    private String appClassName = "";
    private boolean useDefaultServiceName = true;
    private boolean useDefaultClassName = true;
    private boolean updateWebXML = true;
    private IStructuredSelection selection;
    private IProject project;
    private static String WEB = "web.xml";
    private static String WEBINF = "WEB-INF";
    private IFile webFile;

    public JBossWSAnnotatedClassWizard() {
        super.setWindowTitle(JBossWSUIMessages.JBossWSAnnotatedClassWizard_Annotated_Class_WS_Wizard_Title);
        super.setHelpAvailable(false);
        this.setDefaultPageImageDescriptor(CommonUIImages.getInstance().getOrCreateImageDescriptor("wizard/WebServiceWizBan.png"));
    }

    public void addPages() {
        super.addPages();
        JBossWSAnnotatedClassWizardPage onePage = new JBossWSAnnotatedClassWizardPage("onePage");
        this.addPage((IWizardPage)onePage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ServiceModel model = new ServiceModel();
            model.setWebProjectName(this.project.getName());
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            model.setJavaProject(javaProject);
            model.addServiceClasses(new StringBuffer().append(this.getPackageName()).append(".").append(this.getClassName()).toString());
            model.setServiceName(this.getServiceName());
            model.setUpdateWebxml(this.getUpdateWebXML());
            model.setCustomPackage(this.getPackageName());
            model.setApplicationClassName(this.getAppClassName());
            MergeWebXMLCommand mergeCommand = new MergeWebXMLCommand(model);
            IStatus status = null;
            if (this.getUpdateWebXML()) {
                try {
                    status = mergeCommand.execute(null, null);
                }
                catch (ExecutionException e) {
                    JBossWSUIPlugin.log(e);
                }
                if (status != null && status.getSeverity() == 4) {
                    MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)status.getMessage());
                    return false;
                }
            }
            ServiceCreationCommand addClassesCommand = null;
            addClassesCommand = new ServiceCreationCommand(model);
            try {
                if (addClassesCommand != null) {
                    addClassesCommand.execute(null, null);
                }
                this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                IFile openFile1 = null;
                ServiceCreationCommand cmd = addClassesCommand;
                if (cmd.getResource() != null && cmd.getResource() instanceof IFile) {
                    openFile1 = (IFile)cmd.getResource();
                }
                if (openFile1 != null) {
                    this.openResource(openFile1);
                }
            }
            catch (ExecutionException e) {
                JBossWSUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)e.getMessage());
            }
            catch (CoreException e) {
                JBossWSUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)e.getMessage());
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (this.selection.getFirstElement() instanceof IProject) {
            this.project = (IProject)this.selection.getFirstElement();
        }
        if (this.project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
            this.webFile = this.project.getParent().getFolder(JBossWSCreationUtils.getWebContentRootPath((IProject)this.project).append(WEBINF)).getFile(WEB);
        }
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getAppClassName() {
        return this.appClassName;
    }

    public void setAppClassName(String className) {
        this.appClassName = className;
    }

    public boolean isUseDefaultServiceName() {
        return this.useDefaultServiceName;
    }

    public void setUseDefaultServiceName(boolean useDefaultServiceName) {
        this.useDefaultServiceName = useDefaultServiceName;
    }

    public boolean isUseDefaultClassName() {
        return this.useDefaultClassName;
    }

    public void setUseDefaultClassName(boolean useDefaultClassName) {
        this.useDefaultClassName = useDefaultClassName;
    }

    public void setUpdateWebXML(boolean updateWebXML) {
        this.updateWebXML = updateWebXML;
    }

    public boolean getUpdateWebXML() {
        return this.updateWebXML;
    }

    public IProject getProject() {
        return this.project;
    }

    public ServiceModel getServiceModel() {
        ServiceModel model = new ServiceModel();
        if (this.project != null) {
            model.setWebProjectName(this.project.getName());
        }
        if (this.getPackageName() != null) {
            model.addServiceClasses(new StringBuffer().append(this.getPackageName()).append(".").append(this.getClassName()).toString());
        }
        model.setServiceName(this.getServiceName());
        model.setUpdateWebxml(true);
        model.setCustomPackage(this.getPackageName());
        model.setCustomClassName(this.getClassName());
        return model;
    }

    public void setProject(String projectName) {
        IProject test;
        if (projectName != null && projectName.trim().length() > 0 && (test = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
            this.project = test;
            if (this.project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
                this.webFile = this.project.getParent().getFolder(JBossWSCreationUtils.getWebContentRootPath((IProject)this.project).append(WEBINF)).getFile(WEB);
            }
        }
    }

    public IFile getWebFile() {
        return this.webFile;
    }

    protected void openResource(final IFile resource) {
        if (resource.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = JBossWSUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (String)JBossWSAnnotatedClassWizard.JDT_EDITOR, (boolean)true);
                    }
                    catch (PartInitException e) {
                        JBossWSUIPlugin.log(e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)activePage.getWorkbenchWindow());
        }
    }
}

