/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.TesterWSDLUtils;

public class WSDLBrowseDialog
extends TitleAreaDialog {
    private Label locationLabel = null;
    private Combo locationCombo = null;
    private Button workspaceBrowseButton = null;
    private Button fsBrowseButton = null;
    private Button urlBrowseButton = null;
    private static String wsdlTextValue = null;
    private static String[] oldValues = null;
    private String serviceTextValue = null;
    private String portTextValue = null;
    private String operationTextValue = null;
    private String initialOperationTextValue = null;
    private String bindingValue = null;
    private Definition wsdlDefinition = null;
    private Label serviceLabel;
    private Combo serviceCombo;
    private Combo portCombo;
    private Label operationLabel;
    private org.eclipse.swt.widgets.List opList;
    private Group group;
    private Label portLabel;
    private boolean showServicePortOperaton = true;
    private Timer timer;

    public WSDLBrowseDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
    }

    public void setShowServicePortOperation(boolean flag) {
        this.showServicePortOperaton = flag;
    }

    public boolean getShowServicePortOperation() {
        return this.showServicePortOperaton;
    }

    public String getWSDLText() {
        return wsdlTextValue;
    }

    public String getBindingValue() {
        return this.bindingValue;
    }

    public String getServiceTextValue() {
        return this.serviceTextValue;
    }

    public String getPortTextValue() {
        return this.portTextValue;
    }

    public String getOperationTextValue() {
        return this.operationTextValue;
    }

    public void setInitialOperationTextValue(String value) {
        this.initialOperationTextValue = value;
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void setURLText(String urlText) {
        wsdlTextValue = urlText;
    }

    protected void okPressed() {
        wsdlTextValue = this.locationCombo.getText();
        ArrayList<String> uriList = new ArrayList<String>();
        if (oldValues != null) {
            List<String> tempList = Arrays.asList(oldValues);
            uriList.addAll(tempList);
        }
        if (!uriList.contains(this.locationCombo.getText())) {
            uriList.add(this.locationCombo.getText());
        }
        oldValues = uriList.toArray(new String[uriList.size()]);
        super.okPressed();
    }

    private void validateLocation(ModifyEvent arg0) {
        if (this.getContents() != null && this.getContents().getDisplay() != null) {
            this.getContents().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WSDLBrowseDialog.this.setMessage(JBossWSUIMessages.WSDLBrowseDialog_Message);
                    IStatus status = WSDLBrowseDialog.this.validate(false);
                    if (status != Status.OK_STATUS) {
                        WSDLBrowseDialog.this.setMessage(status.getMessage(), 2);
                        if (WSDLBrowseDialog.this.showServicePortOperaton) {
                            WSDLBrowseDialog.this.setGroupEnabled(false);
                        }
                    } else {
                        WSDLBrowseDialog.this.setMessage(JBossWSUIMessages.WSDLBrowseDialog_Message);
                        if (WSDLBrowseDialog.this.showServicePortOperaton) {
                            WSDLBrowseDialog.this.setGroupEnabled(true);
                        }
                    }
                }
            });
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(JBossWSUIMessages.WSDLBrowseDialog_Title);
        this.setMessage(JBossWSUIMessages.WSDLBrowseDialog_Message);
        Composite mainComposite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        mainComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)gridLayout);
        this.locationLabel = new Label(mainComposite, 0);
        this.locationLabel.setText(JBossWSUIMessages.WSDLBrowseDialog_WSDL_URI_Field);
        gridData = new GridData(4, 4, true, false);
        this.locationCombo = new Combo(mainComposite, 2052);
        this.locationCombo.setLayoutData((Object)gridData);
        this.locationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(final ModifyEvent arg0) {
                if (WSDLBrowseDialog.this.timer != null) {
                    WSDLBrowseDialog.this.timer.cancel();
                }
                WSDLBrowseDialog.this.timer = new Timer();
                WSDLBrowseDialog.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        WSDLBrowseDialog.this.validateLocation(arg0);
                        WSDLBrowseDialog.this.timer.cancel();
                    }
                }, 750L);
            }
        });
        if (oldValues != null && oldValues.length > 0) {
            int i = 0;
            while (i < oldValues.length) {
                this.locationCombo.add(oldValues[i]);
                ++i;
            }
        }
        Composite buttonBar = new Composite(mainComposite, 0);
        GridData buttonBarGD = new GridData(0x1000008, 0, true, false);
        buttonBarGD.horizontalSpan = 2;
        buttonBar.setLayoutData((Object)buttonBarGD);
        buttonBar.setLayout((Layout)new RowLayout());
        this.workspaceBrowseButton = new Button(buttonBar, 0);
        this.workspaceBrowseButton.setText(JBossWSUIMessages.WSDLBrowseDialog_WS_Browse);
        this.workspaceBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                Object[] objects;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(WSDLBrowseDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(JBossWSUIMessages.WSDLBrowseDialog_WS_Browse_Select_WSDL_Title);
                dialog.setMessage(JBossWSUIMessages.WSDLBrowseDialog_WS_Browse_Msg);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setAllowMultiple(false);
                dialog.setEmptyListMessage(JBossWSUIMessages.WSDLBrowseDialog_WS_Browse_Select_WSDL_Msg);
                dialog.setStatusLineAboveButtons(true);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] arg0) {
                        IFile resource;
                        if (arg0.length > 0 && arg0[0] instanceof IFile && (resource = (IFile)arg0[0]).getFileExtension().equals("wsdl")) {
                            return Status.OK_STATUS;
                        }
                        return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_WS_Browse_Select_WSDL_Msg);
                    }
                });
                int rtnCode = dialog.open();
                if (rtnCode == 0 && (objects = dialog.getResult()) != null && objects.length > 0 && objects[0] instanceof IFile) {
                    IFile resource = (IFile)objects[0];
                    File tempFile = new File(resource.getRawLocationURI());
                    try {
                        URL testURL = tempFile.toURI().toURL();
                        WSDLBrowseDialog.this.locationCombo.setText(testURL.toExternalForm());
                        WSDLBrowseDialog.this.wsdlDefinition = TesterWSDLUtils.readWSDLURL(testURL);
                        if (WSDLBrowseDialog.this.showServicePortOperaton) {
                            WSDLBrowseDialog.this.updateServiceCombo();
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (WSDLException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        this.fsBrowseButton = new Button(buttonBar, 0);
        this.fsBrowseButton.setText(JBossWSUIMessages.WSDLBrowseDialog_FS_Browse);
        this.fsBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                String fileText;
                FileDialog fileDialog = new FileDialog(WSDLBrowseDialog.this.getShell());
                String[] filterExt = new String[]{"*.wsdl", "*.xml", "*.*"};
                fileDialog.setFilterExtensions(filterExt);
                if (WSDLBrowseDialog.this.locationCombo.getText().trim().length() > 0) {
                    try {
                        URI uri = new URI(WSDLBrowseDialog.this.locationCombo.getText());
                        File temp = new File(uri);
                        String parentPath = temp.getParent();
                        fileDialog.setFilterPath(parentPath);
                        fileDialog.setFileName(temp.getName());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if ((fileText = fileDialog.open()) != null) {
                    File tempFile = new File(fileText);
                    try {
                        URL testURL = tempFile.toURI().toURL();
                        WSDLBrowseDialog.this.locationCombo.setText(testURL.toExternalForm());
                        WSDLBrowseDialog.this.wsdlDefinition = TesterWSDLUtils.readWSDLURL(testURL);
                        if (WSDLBrowseDialog.this.showServicePortOperaton) {
                            WSDLBrowseDialog.this.updateServiceCombo();
                        }
                    }
                    catch (MalformedURLException e) {
                        JBossWSUIPlugin.log(e);
                    }
                    catch (WSDLException e) {
                        JBossWSUIPlugin.log(e);
                    }
                }
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        this.urlBrowseButton = new Button(buttonBar, 0);
        this.urlBrowseButton.setText(JBossWSUIMessages.WSDLBrowseDialog_URL_Browse);
        this.urlBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                InputDialog inDialog = null;
                inDialog = WSDLBrowseDialog.this.locationCombo.getText().trim().length() > 0 ? new InputDialog(WSDLBrowseDialog.this.getShell(), JBossWSUIMessages.WSDLBrowseDialog_WSDL_URL_Dialog_Title, JBossWSUIMessages.WSDLBrowseDialog_WSDL_URL_Prompt, WSDLBrowseDialog.this.locationCombo.getText(), null) : new InputDialog(WSDLBrowseDialog.this.getShell(), JBossWSUIMessages.WSDLBrowseDialog_WSDL_URL_Dialog_Title, JBossWSUIMessages.WSDLBrowseDialog_WSDL_URL_Prompt, "", null);
                int rtnCode = inDialog.open();
                if (rtnCode == 0) {
                    WSDLBrowseDialog.this.locationCombo.setText(inDialog.getValue());
                    try {
                        URL testURL = new URL(inDialog.getValue());
                        WSDLBrowseDialog.this.locationCombo.setText(testURL.toExternalForm());
                        IStatus status = WSDLBrowseDialog.this.validate(false);
                        if (status != null && !status.isOK()) {
                            WSDLBrowseDialog.this.setMessage(status.getMessage(), 2);
                        } else {
                            status = WSDLBrowseDialog.this.parseWSDLFromURL(testURL, true);
                            if (status != null && !status.isOK()) {
                                WSDLBrowseDialog.this.setMessage(status.getMessage(), 2);
                            } else {
                                WSDLBrowseDialog.this.setMessage(JBossWSUIMessages.WSDLBrowseDialog_Message);
                                if (WSDLBrowseDialog.this.showServicePortOperaton) {
                                    WSDLBrowseDialog.this.updateServiceCombo();
                                }
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        JBossWSUIPlugin.log(e);
                        ErrorDialog.openError((Shell)WSDLBrowseDialog.this.getShell(), (String)JBossWSUIMessages.WSDLBrowseDialog_Error_Retrieving_WSDL, (String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Invalid_URL, (IStatus)StatusUtils.errorStatus((Throwable)e));
                    }
                }
            }
        });
        if (this.showServicePortOperaton) {
            this.group = new Group(mainComposite, 0);
            this.group.setText(JBossWSUIMessages.WSDLBrowseDialog_Group_Title);
            gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 2;
            this.group.setLayoutData((Object)gridData);
            this.group.setLayout((Layout)new GridLayout(2, false));
            this.serviceLabel = new Label((Composite)this.group, 0);
            this.serviceLabel.setText(JBossWSUIMessages.WSDLBrowseDialog_Service_Field);
            gridData = new GridData(4, 4, true, false);
            this.serviceCombo = new Combo((Composite)this.group, 2060);
            this.serviceCombo.setLayoutData((Object)gridData);
            this.serviceCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    WSDLBrowseDialog.this.updatePortCombo();
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.widgetDefaultSelected(arg0);
                }
            });
            this.portLabel = new Label((Composite)this.group, 0);
            this.portLabel.setText(JBossWSUIMessages.WSDLBrowseDialog_Port_Field);
            gridData = new GridData(4, 4, true, false);
            this.portCombo = new Combo((Composite)this.group, 2060);
            this.portCombo.setLayoutData((Object)gridData);
            this.portCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    WSDLBrowseDialog.this.updateOperationList();
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.widgetDefaultSelected(arg0);
                }
            });
            this.operationLabel = new Label((Composite)this.group, 0);
            this.operationLabel.setText(JBossWSUIMessages.WSDLBrowseDialog_Operation_Field);
            gridData = new GridData(4, 4, true, true);
            gridData.verticalSpan = 3;
            gridData.heightHint = 50;
            this.opList = new org.eclipse.swt.widgets.List((Composite)this.group, 2560);
            this.opList.setLayoutData((Object)gridData);
            this.opList.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    WSDLBrowseDialog.this.operationTextValue = WSDLBrowseDialog.this.opList.getSelection()[0];
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.widgetDefaultSelected(arg0);
                }
            });
        }
        mainComposite.pack();
        return mainComposite;
    }

    private IStatus parseWSDLFromURL(URL testURL, boolean showProgress) {
        if (showProgress) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                ReadWSDLProgress readWSDLProgress = new ReadWSDLProgress();
                readWSDLProgress.setTestURL(testURL);
                dialog.run(true, true, (IRunnableWithProgress)readWSDLProgress);
                return readWSDLProgress.getResult();
            }
            catch (InvocationTargetException e) {
                return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Parse_Error, (Throwable)e);
            }
            catch (InterruptedException e) {
                return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Parse_Error, (Throwable)e);
            }
            catch (NullPointerException e) {
                return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Parse_Error, (Throwable)e);
            }
        }
        try {
            IStatus testStatus = TesterWSDLUtils.isWSDLAccessible(testURL);
            if (testStatus.getSeverity() != 0) {
                return StatusUtils.errorStatus((String)testStatus.getMessage(), (Throwable)testStatus.getException());
            }
            this.wsdlDefinition = TesterWSDLUtils.readWSDLURL(testURL);
        }
        catch (WSDLException e) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Parse_Error, (Throwable)e);
        }
        catch (NullPointerException e) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Parse_Error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void updateOperationList() {
        if (this.portCombo.getSelectionIndex() > -1) {
            String text;
            this.portTextValue = text = this.portCombo.getItem(this.portCombo.getSelectionIndex());
            Port port = (Port)this.portCombo.getData(text);
            this.opList.removeAll();
            Binding wsdlBinding = port.getBinding();
            this.bindingValue = wsdlBinding.getQName().getLocalPart();
            PortType portType = wsdlBinding.getPortType();
            List operations = portType.getOperations();
            Operation[] operationsArray = operations.toArray(new Operation[operations.size()]);
            Arrays.sort(operationsArray, new WSDLOperationComparator());
            int i = 0;
            while (i < operationsArray.length) {
                Operation operation = operationsArray[i];
                this.opList.add(operation.getName());
                this.opList.setData(operation.getName(), (Object)operation);
                ++i;
            }
            if (this.opList.getItemCount() > 0) {
                boolean foundIt = false;
                if (this.initialOperationTextValue != null) {
                    String[] thelist = this.opList.getItems();
                    int i2 = 0;
                    while (i2 < thelist.length) {
                        if (thelist[i2].contentEquals(this.initialOperationTextValue)) {
                            this.opList.select(i2);
                            foundIt = true;
                            break;
                        }
                        ++i2;
                    }
                }
                if (!foundIt) {
                    this.opList.select(0);
                }
                this.operationTextValue = this.opList.getSelection()[0];
            }
        }
    }

    private void updatePortCombo() {
        if (this.serviceCombo.getSelectionIndex() > -1) {
            String text;
            this.serviceTextValue = text = this.serviceCombo.getItem(this.serviceCombo.getSelectionIndex());
            Service service = (Service)this.serviceCombo.getData(text);
            this.portCombo.removeAll();
            this.opList.removeAll();
            for (Port port : service.getPorts().values()) {
                if (port.getBinding() == null || port.getBinding().getExtensibilityElements() == null) continue;
                List elements = port.getBinding().getExtensibilityElements();
                int i = 0;
                while (i < elements.size()) {
                    if (elements.get(i) instanceof SOAPBinding || elements.get(i) instanceof SOAP12Binding) {
                        this.portCombo.add(port.getName());
                        this.portCombo.setData(port.getName(), (Object)port);
                    }
                    ++i;
                }
            }
            if (this.portCombo.getItemCount() > 0) {
                this.portCombo.select(0);
                this.portTextValue = this.portCombo.getText();
            }
            this.updateOperationList();
        }
    }

    private void updateServiceCombo() {
        this.serviceCombo.setEnabled(true);
        this.portCombo.setEnabled(true);
        this.opList.setEnabled(true);
        this.serviceCombo.removeAll();
        this.portCombo.removeAll();
        this.opList.removeAll();
        this.getButton(0).setEnabled(true);
        if (this.wsdlDefinition != null && this.wsdlDefinition.getServices() != null && !this.wsdlDefinition.getServices().isEmpty()) {
            for (Service service : this.wsdlDefinition.getServices().values()) {
                this.serviceCombo.add(service.getQName().getLocalPart());
                this.serviceCombo.setData(service.getQName().getLocalPart(), (Object)service);
            }
            if (this.serviceCombo.getItemCount() > 0) {
                this.serviceCombo.select(0);
                this.serviceTextValue = this.serviceCombo.getText();
            }
            this.updatePortCombo();
        } else {
            this.serviceCombo.add(JBossWSUIMessages.WSDLBrowseDialog_No_Services_Available);
            this.serviceCombo.select(0);
            this.setMessage(JBossWSUIMessages.WSDLBrowseDialog_No_Services_Available_Warning, 2);
            this.serviceCombo.setEnabled(false);
            this.portCombo.setEnabled(false);
            this.opList.setEnabled(false);
            this.getButton(0).setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JBossWSUIMessages.WSDLBrowseDialog_Dialog_Title);
    }

    private void setGroupEnabled(boolean flag) {
        this.group.setEnabled(flag);
        this.operationLabel.setEnabled(flag);
        this.opList.setEnabled(flag);
        this.portCombo.setEnabled(flag);
        this.portLabel.setEnabled(flag);
        this.serviceCombo.setEnabled(flag);
        this.serviceLabel.setEnabled(flag);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(flag);
        }
        if (!flag) {
            this.opList.removeAll();
            this.portCombo.removeAll();
            this.portCombo.setText("");
            this.serviceCombo.removeAll();
            this.serviceCombo.setText("");
        }
    }

    private IStatus validate(boolean showProgress) {
        String urlText = this.locationCombo.getText();
        try {
            URL testURL = new URL(urlText);
            IStatus status = this.parseWSDLFromURL(testURL, false);
            if (status != null && !status.isOK()) {
                return status;
            }
            if (this.showServicePortOperaton) {
                this.updateServiceCombo();
            }
        }
        catch (MalformedURLException e) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Status_Invalid_URL, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.showServicePortOperaton) {
            this.setGroupEnabled(false);
        }
        if (wsdlTextValue != null) {
            this.locationCombo.setText(wsdlTextValue);
            IStatus status = this.validate(false);
            if (status != Status.OK_STATUS) {
                if (this.showServicePortOperaton) {
                    this.setGroupEnabled(false);
                }
            } else if (this.showServicePortOperaton) {
                this.setGroupEnabled(true);
            }
        }
        control.pack(true);
        return control;
    }

    class ReadWSDLProgress
    implements IRunnableWithProgress {
        private URL testURL = null;
        private IStatus result = null;

        ReadWSDLProgress() {
        }

        public void setTestURL(URL url) {
            this.testURL = url;
        }

        public IStatus getResult() {
            return this.result;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(JBossWSUIMessages.WSDLBrowseDialog_Status_ParsingWSDLFromURL, 100);
            try {
                IStatus testStatus = TesterWSDLUtils.isWSDLAccessible(this.testURL);
                if (testStatus.getSeverity() != 0) {
                    this.result = testStatus;
                }
                WSDLBrowseDialog.this.wsdlDefinition = TesterWSDLUtils.readWSDLURL(this.testURL);
            }
            catch (WSDLException e) {
                this.result = StatusUtils.errorStatus((String)JBossWSUIMessages.WSDLBrowseDialog_Error_Msg_Parse_Error, (Throwable)e);
            }
            monitor.done();
        }
    }

    class WSDLOperationComparator
    implements Comparator<Operation> {
        WSDLOperationComparator() {
        }

        @Override
        public int compare(Operation o1, Operation o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

