/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import com.ibm.icu.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;

public class DelimitedStringList
extends Composite {
    private static final String DELIMITER = ",";
    private Button mAddButton;
    private Button mClearAllButton;
    private Button mRemoveButton;
    private Button mDownButton;
    private Button mUpButton;
    private Button mEditButton;
    private List mPropsList;
    private Text mAddText;
    private boolean isReadOnly = false;
    private Label mWarningLabel;
    private boolean showUpDown = true;
    private String mDelimiter = ",";
    private String mWarning = null;
    private ListenerList changeListeners;

    public DelimitedStringList(Composite parent, int style) {
        this(parent, style, false, true);
    }

    public DelimitedStringList(Composite parent, int style, boolean isReadOnly, boolean showUpDown) {
        super(parent, style);
        this.isReadOnly = isReadOnly;
        this.showUpDown = showUpDown;
        this.changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.mWarningLabel = new Label((Composite)this, 0);
        GridData wlGridData = new GridData(768);
        wlGridData.horizontalSpan = 2;
        this.mWarningLabel.setLayoutData((Object)wlGridData);
        this.mWarningLabel.setForeground(this.mWarningLabel.getDisplay().getSystemColor(3));
        this.mWarningLabel.setBackground(parent.getBackground());
        this.mAddText = new Text((Composite)this, 0x800 | additionalStyles);
        this.mAddText.setLayoutData((Object)new GridData(768));
        this.mAddText.addModifyListener((ModifyListener)new AddTextModifyListener(this));
        this.mAddButton = new Button((Composite)this, 0);
        this.mAddButton.setLayoutData((Object)new GridData(256));
        this.mAddButton.setText("Add");
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.addStringToList();
                DelimitedStringList.this.fireChangedEvent(e.getSource());
            }
        });
        this.mAddButton.setEnabled(false);
        Composite mSpacerComposite = new Composite((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 10;
        gridData.horizontalSpan = 2;
        mSpacerComposite.setLayoutData((Object)gridData);
        mSpacerComposite.setLayout((Layout)new GridLayout());
        mSpacerComposite.setBackground(parent.getBackground());
        this.mPropsList = new List((Composite)this, 2560);
        GridData gridData2 = new GridData(272);
        gridData2.verticalSpan = this.getShowUpDown() ? 5 : 3;
        this.mPropsList.setLayoutData((Object)gridData2);
        this.mPropsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.updatePropertyButtons();
            }
        });
        if (this.getShowUpDown()) {
            this.mUpButton = new Button((Composite)this, 0);
            this.mUpButton.setLayoutData((Object)new GridData(256));
            this.mUpButton.setText("Up");
            this.mUpButton.setEnabled(false);
            this.mUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DelimitedStringList.this.moveUpInList();
                    DelimitedStringList.this.fireChangedEvent(e.getSource());
                }
            });
            this.mDownButton = new Button((Composite)this, 0);
            this.mDownButton.setLayoutData((Object)new GridData(256));
            this.mDownButton.setText("Down");
            this.mDownButton.setEnabled(false);
            this.mDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DelimitedStringList.this.moveDownInList();
                    DelimitedStringList.this.fireChangedEvent(e.getSource());
                }
            });
        }
        this.mEditButton = new Button((Composite)this, 0);
        this.mEditButton.setLayoutData((Object)new GridData(256));
        this.mEditButton.setText("Edit");
        this.mEditButton.setEnabled(false);
        this.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.editInList();
                DelimitedStringList.this.fireChangedEvent(e.getSource());
            }
        });
        this.mRemoveButton = new Button((Composite)this, 0);
        this.mRemoveButton.setLayoutData((Object)new GridData(256));
        this.mRemoveButton.setText("Remove");
        this.mRemoveButton.setEnabled(false);
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.removeFromList();
                DelimitedStringList.this.fireChangedEvent(e.getSource());
            }
        });
        this.mClearAllButton = new Button((Composite)this, 0);
        this.mClearAllButton.setEnabled(false);
        this.mClearAllButton.setLayoutData((Object)new GridData(256));
        this.mClearAllButton.setText("Clear All");
        this.mClearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.mPropsList.removeAll();
                DelimitedStringList.this.updatePropertyButtons();
                DelimitedStringList.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void removeAll() {
        this.mPropsList.removeAll();
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void addStringToList() {
        if (this.mAddText.getText().length() > 0) {
            String text = this.mAddText.getText().trim();
            if (text.indexOf(38) > -1) {
                MessageDialog dialog = new MessageDialog(null, JBossWSUIMessages.DelimitedStringList_Msg_Title_ParseByAmpersand, null, JBossWSUIMessages.DelimitedStringList_Msg_Text_ParseByAmpersand, 3, new String[]{JBossWSUIMessages.DelimitedStringList_Msg_Yes_Btn, JBossWSUIMessages.DelimitedStringList_Msg_No_Btn}, 0);
                int result = dialog.open();
                if (result == 0) {
                    String[] parsed = DelimitedStringList.parseString(text, "&");
                    int i = 0;
                    while (i < parsed.length) {
                        this.mPropsList.add(parsed[i]);
                        ++i;
                    }
                }
            } else if (text.indexOf(44) > -1) {
                MessageDialog dialog = new MessageDialog(null, JBossWSUIMessages.DelimitedStringList_Msg_Title_ParseByComma, null, JBossWSUIMessages.DelimitedStringList_Msg_Text_ParseByComma, 3, new String[]{JBossWSUIMessages.DelimitedStringList_Msg_Yes_Btn, JBossWSUIMessages.DelimitedStringList_Msg_No_Btn}, 0);
                int result = dialog.open();
                if (result == 0) {
                    String[] parsed = DelimitedStringList.parseString(text, DELIMITER);
                    int i = 0;
                    while (i < parsed.length) {
                        this.mPropsList.add(parsed[i]);
                        ++i;
                    }
                }
            } else {
                this.mPropsList.add(text);
            }
            if (!this.isReadOnly) {
                this.mClearAllButton.setEnabled(true);
            }
            this.mAddText.setSelection(0, text.length());
            this.mAddText.setFocus();
        }
    }

    private void editInList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int index = this.mPropsList.getSelectionIndex();
            String toEdit = this.mPropsList.getItem(index);
            InputDialog editDialog = new InputDialog(this.getShell(), JBossWSUIMessages.JBossWS_DelimitedStringList_EditValue_Dialog_Title, JBossWSUIMessages.JBossWS_DelimitedStringList_EditValue_Dialog_Message, toEdit, null);
            int rtn_code = editDialog.open();
            if (rtn_code == 0) {
                this.mPropsList.remove(index);
                this.mPropsList.add(editDialog.getValue(), index);
            }
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void removeFromList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int index = this.mPropsList.getSelectionIndex();
            this.mPropsList.remove(index);
            try {
                if (this.mPropsList.getItem(index) != null) {
                    this.mPropsList.select(index);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void moveUpInList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int selection = this.mPropsList.getSelectionIndex();
            int destination = -1;
            if (selection > 0) {
                destination = selection - 1;
                String value_a = this.mPropsList.getItem(destination);
                String value_b = this.mPropsList.getItem(selection);
                String[] items = this.mPropsList.getItems();
                this.mPropsList.removeAll();
                int counter = 0;
                while (counter < items.length) {
                    if (counter == destination) {
                        this.mPropsList.add(value_b);
                        this.mPropsList.add(value_a);
                        counter += 2;
                        continue;
                    }
                    this.mPropsList.add(items[counter]);
                    ++counter;
                }
                this.mPropsList.setSelection(destination);
            }
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void moveDownInList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int selection = this.mPropsList.getSelectionIndex();
            int destination = -1;
            if (selection < this.mPropsList.getItemCount() - 1) {
                destination = selection + 1;
                String value_a = this.mPropsList.getItem(destination);
                String value_b = this.mPropsList.getItem(selection);
                String[] items = this.mPropsList.getItems();
                this.mPropsList.removeAll();
                int counter = 0;
                while (counter < items.length) {
                    if (counter == selection) {
                        this.mPropsList.add(value_a);
                        this.mPropsList.add(value_b);
                    } else if (counter != destination) {
                        this.mPropsList.add(items[counter]);
                    }
                    ++counter;
                }
                this.mPropsList.setSelection(destination);
            }
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    public String getSelection() {
        String selectString = "";
        int i = 0;
        while (i < this.mPropsList.getItems().length) {
            String testitem = this.mPropsList.getItem(i).trim();
            selectString = String.valueOf(selectString) + testitem;
            if (i < this.mPropsList.getItems().length - 1) {
                selectString = String.valueOf(selectString) + this.mDelimiter;
            }
            ++i;
        }
        return selectString;
    }

    public void updatePropertyButtons() {
        if (!this.isReadOnly) {
            if (this.mUpButton != null) {
                this.mUpButton.setEnabled(false);
                this.mDownButton.setEnabled(false);
            }
            this.mRemoveButton.setEnabled(false);
            this.mEditButton.setEnabled(false);
            this.mClearAllButton.setEnabled(false);
            if (this.mPropsList.getItemCount() > 0) {
                this.mClearAllButton.setEnabled(true);
                if (this.mPropsList.getSelectionCount() == 1) {
                    int selection = this.mPropsList.getSelectionIndex();
                    this.mRemoveButton.setEnabled(true);
                    this.mEditButton.setEnabled(true);
                    if (this.mUpButton != null) {
                        if (selection - 1 >= 0) {
                            this.mUpButton.setEnabled(true);
                        }
                        if (selection + 1 < this.mPropsList.getItemCount()) {
                            this.mDownButton.setEnabled(true);
                        }
                    }
                }
            }
            String value = "";
            value = this.mAddText.getText();
            boolean flag = value != null && value.trim().length() > 0;
            boolean valid = this.validateText(value);
            if (!valid) {
                this.mWarningLabel.setText(this.mWarning);
            } else {
                this.mWarningLabel.setText("");
            }
            this.mAddButton.setEnabled(flag && valid);
        }
    }

    private boolean validateText(String text) {
        if (text != null && text.trim().length() > 0 && text.indexOf("=") == -1) {
            this.mWarning = JBossWSUIMessages.DelimitedStringList_NO_EQUALS_DELIMITER_WARNING;
            return false;
        }
        this.mWarning = null;
        return true;
    }

    public boolean setFocus() {
        if (this.mAddText != null) {
            return this.mAddText.setFocus();
        }
        return false;
    }

    public void setSelection(String str_list) {
        String[] str_array = this.parseString(str_list);
        this.mPropsList.setItems(str_array);
        this.updatePropertyButtons();
    }

    private String[] parseString(String str_list) {
        if (str_list != null) {
            StringTokenizer tk = new StringTokenizer(str_list, this.mDelimiter);
            String[] pieces = new String[tk.countTokens()];
            int index = 0;
            while (tk.hasMoreTokens()) {
                pieces[index++] = tk.nextToken();
            }
            return pieces;
        }
        return new String[0];
    }

    public static String[] parseString(String str_list, String delimiter) {
        if (str_list != null) {
            StringTokenizer tk = new StringTokenizer(str_list, delimiter);
            String[] pieces = new String[tk.countTokens()];
            int index = 0;
            while (tk.hasMoreTokens()) {
                pieces[index++] = tk.nextToken();
            }
            return pieces;
        }
        return new String[0];
    }

    public void setDelimiter(String delimiter) {
        this.mDelimiter = delimiter;
    }

    public String getDelimiter() {
        return this.mDelimiter;
    }

    public String getWarning() {
        return this.mWarning;
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mAddButton.setEnabled(enabled);
        this.mAddText.setEnabled(enabled);
        this.mClearAllButton.setEnabled(enabled);
        if (this.mUpButton != null) {
            this.mUpButton.setEnabled(enabled);
            this.mDownButton.setEnabled(enabled);
        }
        this.mEditButton.setEnabled(enabled);
        this.mPropsList.setEnabled(enabled);
        this.mRemoveButton.setEnabled(enabled);
        if (enabled) {
            this.updatePropertyButtons();
        }
    }

    public void setShowUpDown(boolean flag) {
        this.showUpDown = flag;
    }

    public boolean getShowUpDown() {
        return this.showUpDown;
    }

    private class AddTextModifyListener
    implements ModifyListener {
        private DelimitedStringList parent;

        public AddTextModifyListener(DelimitedStringList parent) {
            this.parent = parent;
        }

        public void modifyText(ModifyEvent e) {
            DelimitedStringList.this.updatePropertyButtons();
            DelimitedStringList.this.fireChangedEvent((Object)this.parent);
        }
    }
}

