/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.xml.sax.SAXException;

public class WSTestUtils {
    public static String addNLsToXML(String incoming) {
        String outgoing = null;
        if (incoming != null) {
            outgoing = incoming.replaceAll("><", ">\n<");
        }
        return outgoing;
    }

    public static String stripNLsFromXML(String incoming) {
        String outgoing = null;
        if (incoming != null) {
            String find = "(>)\n\\s*+(<)";
            outgoing = incoming.replaceAll(find, "><");
            if (outgoing.contains("\n")) {
                outgoing = outgoing.replaceAll("\n", " ");
            }
            if (outgoing.contains("\r")) {
                outgoing = outgoing.replaceAll("\r", " ");
            }
        }
        return outgoing;
    }

    public static IStatus saveTextToFile(String text) {
        FileDialog fd = new FileDialog(new Shell(Display.getCurrent()), 8192);
        fd.setText(JBossWSUIMessages.WSTestUtils_SaveResponseText_Title);
        String[] filterExt = new String[]{"*.txt", "*.xml"};
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        if (selected != null) {
            try {
                FileOutputStream out = new FileOutputStream(selected);
                PrintStream p = new PrintStream(out);
                p.println(text);
                p.close();
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                Status rtnStatus = new Status(4, "org.jboss.tools.ws.ui", JBossWSUIMessages.WSTestUtils_SaveResponseText_Error_Msg, (Throwable)e);
                return rtnStatus;
            }
        }
        return Status.CANCEL_STATUS;
    }

    public static boolean isTextXML(String text) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes());
            db.parse(bais);
            return true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return false;
    }
}

