/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.WSTestUtils;

public class JAXRSTester {
    private String resultBody;
    private Map<?, ?> requestHeaders = null;
    private Map<?, ?> resultHeaders = null;
    private String EMPTY_STRING = "";

    public String getResultBody() {
        return this.resultBody;
    }

    public Map<?, ?> getResultHeaders() {
        return this.resultHeaders;
    }

    public Map<?, ?> getRequestHeaders() {
        return this.requestHeaders;
    }

    private String buildWebQuery(Map<String, String> parameters) throws Exception {
        if (!parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = URLEncoder.encode(entry.getKey(), "UTF-8");
                String value = URLEncoder.encode(entry.getValue(), "UTF-8");
                sb.append(key).append("=").append(value).append("&");
            }
            return sb.toString().substring(0, sb.length() - 1);
        }
        return this.EMPTY_STRING;
    }

    public void doTest(String address, Map<String, String> parameters, Map<String, String> headers) throws Exception {
        this.doTest(address, parameters, headers, "GET", null, null, 0, null, null);
    }

    public void doTest(String address, Map<String, String> parameters, Map<String, String> headers, String methodType, String requestBody) throws Exception {
        this.doTest(address, parameters, headers, methodType, requestBody, null, 0, null, null);
    }

    public void doTest(String address, Map<String, String> parameters, Map<String, String> headers, String methodType, String requestBody, String proxy, String port) throws Exception {
        this.doTest(address, parameters, headers, methodType, requestBody, proxy, Integer.parseInt(port), null, null);
    }

    public void doTest(String address, Map<String, String> parameters, Map<String, String> headers, String methodType, String requestBody, String proxy, int port, String uid, String pwd) throws Exception {
        StringBuilder sb;
        BufferedReader br;
        Proxy proxyObject = null;
        if (proxy != null && proxy.length() > 0 && port > 0) {
            InetSocketAddress proxyAddress = new InetSocketAddress(proxy, port);
            proxyObject = new Proxy(Proxy.Type.HTTP, proxyAddress);
        }
        this.resultBody = this.EMPTY_STRING;
        String query = this.buildWebQuery(parameters);
        address = address.trim();
        URL url = null;
        if (query != null && query.trim().length() > 0) {
            if (!address.endsWith("?") && !address.contains("?")) {
                if (methodType.equalsIgnoreCase("GET")) {
                    address = String.valueOf(address) + "?";
                } else if ((methodType.equalsIgnoreCase("POST") || methodType.equalsIgnoreCase("PUT") || methodType.equalsIgnoreCase("DELETE")) && query.trim().length() > 0) {
                    address = String.valueOf(address) + "?";
                }
            } else if (address.contains("?")) {
                address = String.valueOf(address) + "&";
            }
            url = new URL(String.valueOf(address) + query);
        } else {
            url = new URL(address);
        }
        HttpURLConnection httpurlc = null;
        httpurlc = proxyObject == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxyObject);
        httpurlc.setDoOutput(true);
        httpurlc.setAllowUserInteraction(false);
        httpurlc.setRequestMethod(methodType);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getKey() == null || !(entry.getKey() instanceof String)) continue;
                httpurlc.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (uid != null && pwd != null) {
            String authStr = String.valueOf(uid) + ':' + pwd;
            byte[] authEncByte = Base64.encodeBase64((byte[])authStr.getBytes());
            String authStringEnc = new String(authEncByte);
            httpurlc.addRequestProperty("Authorization", "Basic " + authStringEnc);
        }
        this.requestHeaders = httpurlc.getRequestProperties();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        httpurlc.connect();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (requestBody != null && (methodType.equalsIgnoreCase("POST") || methodType.equalsIgnoreCase("PUT"))) {
            requestBody = WSTestUtils.stripNLsFromXML(requestBody);
            OutputStreamWriter out = new OutputStreamWriter(httpurlc.getOutputStream());
            String stripped = JAXRSTester.stripCRLF(requestBody);
            out.write(stripped);
            out.close();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (httpurlc.getHeaderFields() != null) {
            this.resultHeaders = httpurlc.getHeaderFields();
        }
        InputStream is = null;
        try {
            String line;
            is = httpurlc.getInputStream();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            this.resultBody = sb.toString();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        catch (IOException iOException) {
            try {
                is = httpurlc.getErrorStream();
                if (is != null) {
                    String line;
                    br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    br.close();
                    this.resultBody = sb.toString();
                }
            }
            catch (IOException ie2) {
                this.resultBody = ie2.getLocalizedMessage();
            }
        }
        if (this.resultBody == null || this.resultBody.trim().isEmpty()) {
            this.resultBody = JBossWSUIMessages.JAXRSRSTestView_Message_Unsuccessful_Test;
        }
        httpurlc.disconnect();
    }

    public static String stripCRLF(String input) {
        if (input != null) {
            StringBuffer output = new StringBuffer();
            char cr = '\r';
            char lf = '\n';
            int i = 0;
            while (i < input.length()) {
                char ch = input.charAt(i);
                if (ch != cr && ch != lf) {
                    output.append(ch);
                }
                ++i;
            }
            return output.toString();
        }
        return null;
    }
}

