/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.ws.ui.dialogs.EnumParamType;
import org.jboss.tools.ws.ui.dialogs.URLTemplateParameter;

public class JAXRSPathTemplateParser {
    private static final Pattern PATH_PARAM_TEMPLATE_PATTERN = Pattern.compile("\\{(\\w+):([^:]+)\\}");
    private static final Pattern OPTIONAL_PARAM_TEMPLATE_PATTERN = Pattern.compile("(;|\\?|&)(\\w+)=\\{([^:]+)\\}");
    private static final Pattern OPTIONAL_PARAM_WITH_DEFAULT_VALUE_TEMPLATE_PATTERN = Pattern.compile("(;|\\?|&)(\\w+)=\\{([^:]+):\"(.+)\"\\}");

    public static URLTemplateParameter[] parse(String urlTemplate) {
        if (urlTemplate == null || urlTemplate.isEmpty()) {
            return new URLTemplateParameter[0];
        }
        ArrayList<URLTemplateParameter> templateParameters = new ArrayList<URLTemplateParameter>();
        int scanIndex = 0;
        while (scanIndex != -1 || scanIndex >= urlTemplate.length()) {
            URLTemplateParameter templateParameter;
            String expression;
            int nextCharacterIndex;
            int bracketBeginIndex = urlTemplate.indexOf(123, scanIndex);
            int bracketEndIndex = urlTemplate.indexOf(125, bracketBeginIndex);
            int commaBeginIndex = urlTemplate.indexOf(59, scanIndex);
            int questionMarkBeginIndex = urlTemplate.indexOf(63, scanIndex);
            int ampersandMarkBeginIndex = urlTemplate.indexOf(38, scanIndex);
            if (bracketBeginIndex == -1 || bracketEndIndex == -1 || (nextCharacterIndex = JAXRSPathTemplateParser.nextCharacterIndex(bracketBeginIndex, commaBeginIndex, questionMarkBeginIndex, ampersandMarkBeginIndex)) == -1) break;
            char nextCharacter = urlTemplate.charAt(nextCharacterIndex);
            if (nextCharacter == '{') {
                expression = urlTemplate.substring(nextCharacterIndex, bracketEndIndex + 1);
                Matcher pathParamTemplateMatcher = PATH_PARAM_TEMPLATE_PATTERN.matcher(expression);
                if (pathParamTemplateMatcher.matches()) {
                    URLTemplateParameter templateParameter2 = URLTemplateParameter.Builder.from(expression).withName(pathParamTemplateMatcher.group(1), true).withDatatype(pathParamTemplateMatcher.group(2)).withParamType(EnumParamType.PATH_PARAM).build();
                    templateParameters.add(templateParameter2);
                }
                scanIndex = nextCharacterIndex + expression.length();
                continue;
            }
            if (nextCharacter != ';' && nextCharacter != '?' && nextCharacter != '&') continue;
            expression = urlTemplate.substring(nextCharacterIndex, bracketEndIndex + 1);
            Matcher optionalParamTemplateMatcher = OPTIONAL_PARAM_TEMPLATE_PATTERN.matcher(expression);
            Matcher optionalParamWithDefaultStringValueTemplateMatcher = OPTIONAL_PARAM_WITH_DEFAULT_VALUE_TEMPLATE_PATTERN.matcher(expression);
            if (optionalParamTemplateMatcher.matches()) {
                templateParameter = URLTemplateParameter.Builder.from(expression).withName(optionalParamTemplateMatcher.group(2), true).withDatatype(optionalParamTemplateMatcher.group(3)).withParamType(JAXRSPathTemplateParser.getParamType(nextCharacter)).build();
                templateParameters.add(templateParameter);
            } else if (optionalParamWithDefaultStringValueTemplateMatcher.matches()) {
                templateParameter = URLTemplateParameter.Builder.from(expression).withName(optionalParamWithDefaultStringValueTemplateMatcher.group(2), true).withDatatype(optionalParamWithDefaultStringValueTemplateMatcher.group(3)).withDefaultValue(optionalParamWithDefaultStringValueTemplateMatcher.group(4)).withParamType(JAXRSPathTemplateParser.getParamType(nextCharacter)).build();
                templateParameters.add(templateParameter);
            }
            scanIndex = nextCharacterIndex + expression.length();
        }
        return templateParameters.toArray(new URLTemplateParameter[templateParameters.size()]);
    }

    private static EnumParamType getParamType(char nextCharacter) {
        switch (nextCharacter) {
            case '&': 
            case '?': {
                return EnumParamType.QUERY_PARAM;
            }
            case ';': {
                return EnumParamType.MATRIX_PARAM;
            }
        }
        return null;
    }

    private static int nextCharacterIndex(int ... characterIndexes) {
        int minValue = Integer.MAX_VALUE;
        int[] nArray = characterIndexes;
        int n = characterIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int characterIndex = nArray[n2];
            if (characterIndex != -1) {
                minValue = Math.min(minValue, characterIndex);
            }
            ++n2;
        }
        if (minValue == Integer.MAX_VALUE) {
            return -1;
        }
        return minValue;
    }

    static class CharSearcher {
        private final char[] tokens;

        private CharSearcher(char[] tokens) {
            this.tokens = tokens;
        }

        static CharSearcher findLastIndexOf(char ... tokens) {
            return new CharSearcher(tokens);
        }

        public int in(String content) {
            int location = -1;
            char[] cArray = this.tokens;
            int n = this.tokens.length;
            int n2 = 0;
            while (n2 < n) {
                char token = cArray[n2];
                location = Math.max(location, content.lastIndexOf(token));
                ++n2;
            }
            return location;
        }
    }
}

