/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDIConstants;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderCorePlugin;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderPreferences;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericBeanDefinitionContext;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericBeanValidator;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericClassBean;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericConfiguration;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.impl.AnnotationLiteral;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.preferences.SeverityPreferences;

public class CDISeamSolderGenericBeanExtension
implements ICDIExtension,
IBuildParticipantFeature,
IProcessAnnotatedTypeFeature,
IValidatorFeature,
CDIConstants {
    GenericBeanDefinitionContext context = new GenericBeanDefinitionContext(this.getVersion());

    protected Version getVersion() {
        return Version.instance;
    }

    public IDefinitionContextExtension getContext() {
        return this.context;
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
    }

    public void buildBeans(CDIProject target) {
        CDIProject p = target;
        for (GenericConfiguration c : this.context.getGenericConfigurations().values()) {
            AnnotationDefinition genericTypeDef = c.getGenericTypeDefinition();
            if (genericTypeDef != null) {
                TypeDefinition fakeGenericType = new TypeDefinition();
                fakeGenericType.setType(genericTypeDef.getType(), this.context.getRootContext(), 0);
                fakeGenericType.setBeanConstructor(true);
                ClassBean b = new ClassBean();
                b.setDefinition(fakeGenericType);
                b.setParent((ICDIElement)p);
                p.addBean((IBean)b);
            }
            Map<AbstractMemberDefinition, List<IQualifierDeclaration>> ms = c.getGenericConfigurationPoints();
            Set<TypeDefinition> ts = c.getGenericBeans();
            for (AbstractMemberDefinition gp : ms.keySet()) {
                if (gp.getTypeDefinition().isVetoed()) continue;
                List<IQualifierDeclaration> list = ms.get(gp);
                for (TypeDefinition t : ts) {
                    TypeDefinition ti = new TypeDefinition();
                    ti.setType(t.getType(), this.context.getRootContext(), 0);
                    List ps = ti.getMethods();
                    for (MethodDefinition m : ps) {
                        if (!m.isAnnotationPresent("javax.enterprise.inject.Produces") && !m.isAnnotationPresent(this.getVersion().getUnwrapsAnnotationTypeName())) continue;
                        for (IAnnotationDeclaration iAnnotationDeclaration : list) {
                            m.addAnnotation(((AnnotationDeclaration)iAnnotationDeclaration).getDeclaration(), this.context.getRootContext());
                        }
                    }
                    List fs = ti.getFields();
                    for (FieldDefinition f : fs) {
                        if (!f.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
                        for (IAnnotationDeclaration iAnnotationDeclaration : list) {
                            f.addAnnotation(((AnnotationDeclaration)iAnnotationDeclaration).getDeclaration(), this.context.getRootContext());
                        }
                    }
                    this.replaceGenericInjections(ti, list);
                    GenericClassBean cb = new GenericClassBean(this.getVersion());
                    cb.setGenericProducerBeanDefinition(gp);
                    cb.setParent((ICDIElement)p);
                    cb.setDefinition(ti);
                    p.addBean((IBean)cb);
                    for (IProducer iProducer : cb.getProducers()) {
                        p.addBean((IBean)iProducer);
                    }
                }
            }
        }
    }

    private void replaceGenericInjections(TypeDefinition ti, List<IQualifierDeclaration> list) {
        List fs = ti.getFields();
        for (FieldDefinition f : fs) {
            if (!f.isAnnotationPresent("javax.inject.Inject") || !f.isAnnotationPresent(this.getVersion().getGenericQualifierAnnotationTypeName())) continue;
            for (IAnnotationDeclaration iAnnotationDeclaration : list) {
                f.addAnnotation(((AnnotationDeclaration)iAnnotationDeclaration).getDeclaration(), this.context.getRootContext());
            }
            AnnotationDeclaration annotationDeclaration = f.getAnnotation(this.getVersion().getGenericQualifierAnnotationTypeName());
            f.removeAnnotation((IAnnotationDeclaration)annotationDeclaration);
            IJavaAnnotation ja = this.createInjectGenericAnnotation(annotationDeclaration, this.context.getRootContext().getProject());
            if (ja == null) continue;
            f.addAnnotation(ja, this.context.getRootContext());
        }
        List ms = ti.getMethods();
        for (MethodDefinition m : ms) {
            boolean isObserver = m.isObserver();
            if (!m.isAnnotationPresent("javax.inject.Inject") && !isObserver) continue;
            boolean isMethodGeneric = m.isAnnotationPresent(this.getVersion().getGenericQualifierAnnotationTypeName());
            List ps = m.getParameters();
            for (ParameterDefinition p : ps) {
                if (!isMethodGeneric && !p.isAnnotationPresent(this.getVersion().getGenericQualifierAnnotationTypeName()) && (!isObserver || !p.isAnnotationPresent("javax.enterprise.event.Observes"))) continue;
                for (IAnnotationDeclaration iAnnotationDeclaration : list) {
                    p.addAnnotation(((AnnotationDeclaration)iAnnotationDeclaration).getDeclaration(), this.context.getRootContext());
                }
                AnnotationDeclaration annotationDeclaration = p.getAnnotation(this.getVersion().getGenericQualifierAnnotationTypeName());
                if (annotationDeclaration == null) continue;
                p.removeAnnotation((IAnnotationDeclaration)annotationDeclaration);
                IJavaAnnotation ja = this.createInjectGenericAnnotation(annotationDeclaration, this.context.getRootContext().getProject());
                if (ja == null) continue;
                p.addAnnotation(ja, this.context.getRootContext());
            }
        }
    }

    private IJavaAnnotation createInjectGenericAnnotation(AnnotationDeclaration genericAnnotation, CDICoreNature project) {
        IType type = project.getType(this.getVersion().getInjectGenericAnnotationTypeName());
        return type != null ? new AnnotationLiteral(genericAnnotation.getResource(), genericAnnotation.getStartPosition(), genericAnnotation.getLength(), null, 0, type) : null;
    }

    public void processAnnotatedType(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        if (!typeDefinition.isAnnotationPresent(this.getVersion().getVetoAnnotationTypeName())) {
            if (typeDefinition.isAnnotationPresent(this.getVersion().getGenericConfigurationAnnotationTypeName())) {
                String s;
                typeDefinition.veto();
                AnnotationDeclaration d = typeDefinition.getAnnotation(this.getVersion().getGenericConfigurationAnnotationTypeName());
                Object o = d.getMemberValue(null);
                if (o != null && (s = o.toString()).length() > 0) {
                    try {
                        ParametedType p = context.getProject().getTypeFactory().getParametedType((IMember)typeDefinition.getType(), "Q" + s + ";");
                        if (p != null && p.getType() != null) {
                            GenericConfiguration c = ((GenericBeanDefinitionContext)this.context.getWorkingCopy()).getGenericConfiguration(p.getType().getFullyQualifiedName());
                            c.getGenericBeans().add(typeDefinition);
                            this.addToDependencies(c, (AbstractMemberDefinition)typeDefinition, context);
                        }
                    }
                    catch (JavaModelException e) {
                        CDISeamSolderCorePlugin.getDefault().logError(e);
                    }
                }
            } else {
                this.addGenericProducerBean((AbstractMemberDefinition)typeDefinition, context);
                for (MethodDefinition m : typeDefinition.getMethods()) {
                    if (!m.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
                    this.addGenericProducerBean((AbstractMemberDefinition)m, context);
                }
                for (FieldDefinition f : typeDefinition.getFields()) {
                    if (!f.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
                    this.addGenericProducerBean((AbstractMemberDefinition)f, context);
                }
            }
        }
    }

    private void addGenericProducerBean(AbstractMemberDefinition def, IRootDefinitionContext context) {
        IAnnotationDeclaration d = this.findAnnotationAnnotatedWithGenericType(def);
        if (d != null) {
            this.addGenericProducerBean(def, d.getTypeName(), context);
        }
    }

    private void addGenericProducerBean(AbstractMemberDefinition def, String genericType, IRootDefinitionContext context) {
        GenericConfiguration c = ((GenericBeanDefinitionContext)this.context.getWorkingCopy()).getGenericConfiguration(genericType);
        ArrayList<IQualifierDeclaration> list = new ArrayList<IQualifierDeclaration>();
        List ds = def.getAnnotations();
        for (IAnnotationDeclaration d : ds) {
            if (!(d instanceof IQualifierDeclaration)) continue;
            list.add((IQualifierDeclaration)d);
        }
        c.getGenericConfigurationPoints().put(def, list);
        this.addToDependencies(c, def, context);
    }

    private void addToDependencies(GenericConfiguration c, AbstractMemberDefinition def, IRootDefinitionContext context) {
        IResource r = def.getResource();
        if (r != null && r.exists() && !c.getInvolvedTypes().contains(r.getFullPath())) {
            IPath newPath = r.getFullPath();
            Set<IPath> ps = c.getInvolvedTypes();
            for (IPath p : ps) {
                context.addDependency(p, newPath);
                context.addDependency(newPath, p);
            }
            ps.add(newPath);
        }
    }

    private IAnnotationDeclaration findAnnotationAnnotatedWithGenericType(AbstractMemberDefinition m) {
        List ds = m.getAnnotations();
        for (IAnnotationDeclaration d : ds) {
            AnnotationDefinition a;
            if (d.getTypeName() == null || (a = this.context.getRootContext().getAnnotation(d.getTypeName())) == null || !a.isAnnotationPresent(this.getVersion().getGenericTypeAnnotationTypeName())) continue;
            return d;
        }
        return null;
    }

    public void validateResource(IFile file, CDICoreValidator validator) {
        new GenericBeanValidator(this.getVersion()).validateResource(file, validator, this.context.getRootContext().getProject(), this.context);
    }

    public SeverityPreferences getSeverityPreferences() {
        return CDISeamSolderPreferences.getInstance();
    }
}

