/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class InferTypeArgumentsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public InferTypeArgumentsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InferTypeArgumentsAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InferTypeArgumentsAction_label);
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        if (selection.getLength() != 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        IJavaElement[] elements = InferTypeArgumentsAction.getSelectedElements(selection);
        try {
            if (!ActionUtil.areProcessable(this.getShell(), elements)) {
                return;
            }
            if (RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements)) {
                RefactoringExecutionStarter.startInferTypeArgumentsRefactoring(elements, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.InferTypeArgumentsAction_unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        ITypeRoot element = SelectionConverter.getInput(this.fEditor);
        IJavaElement[] array = new IJavaElement[]{element};
        try {
            if (element != null && RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(array)) {
                RefactoringExecutionStarter.startInferTypeArgumentsRefactoring(array, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.InferTypeArgumentsAction_unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IJavaElement[] getSelectedElements(IStructuredSelection selection) {
        List list = selection.toList();
        IJavaElement[] elements = new IJavaElement[list.size()];
        int i = 0;
        while (i < list.size()) {
            Object object = list.get(i);
            if (!(object instanceof IJavaElement)) {
                return new IJavaElement[0];
            }
            elements[i] = (IJavaElement)object;
            ++i;
        }
        return elements;
    }
}

