/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.help.ui.internal.search;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.search.ISearchEngineResult;
import org.jboss.dmr.ModelNode;

public class SearchiskoResultBuilder {
    static int MAX_DESCRIPTION_LENGTH = 180;

    private SearchiskoResultBuilder() {
    }

    public static ISearchEngineResult create(ModelNode hit) {
        Assert.isNotNull((Object)hit);
        if (!hit.isDefined()) {
            return null;
        }
        return new SearchiskoResult(hit);
    }

    private static class SearchiskoResult
    implements ISearchEngineResult {
        private ModelNode hit;
        private ModelNode fields;

        private SearchiskoResult(ModelNode hit) {
            this.hit = hit;
            this.fields = hit.get("fields");
        }

        public String getLabel() {
            return this.getField("sys_title");
        }

        public String getDescription() {
            return this.getField("sys_description", MAX_DESCRIPTION_LENGTH);
        }

        public IHelpResource getCategory() {
            return null;
        }

        public String getHref() {
            return this.getField("sys_url_view");
        }

        public float getScore() {
            return (float)this.hit.get("_score").asDouble();
        }

        public boolean getForceExternalWindow() {
            return true;
        }

        public String toAbsoluteHref(String href, boolean frames) {
            return href;
        }

        private String getField(String name) {
            return this.fields.get(name).asString();
        }

        private String getField(String name, int maxLength) {
            return StringUtils.abbreviate((String)this.fields.get(name).asString(), (int)maxLength);
        }
    }
}

