/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.help.ui.internal.search;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.search.ISearchEngine;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.help.ui.internal.JBossHelpActivator;
import org.jboss.tools.foundation.help.ui.internal.search.SearchiskoEngineScopeFactory;
import org.jboss.tools.foundation.help.ui.internal.search.SearchiskoResultBuilder;

public class SearchiskoEngine
implements ISearchEngine {
    public void run(String query, ISearchScope scope, ISearchEngineResultCollector collector, IProgressMonitor monitor) {
        try {
            String searchQuery = this.getSearchUrl(((SearchiskoEngineScopeFactory.Scope)scope).getURLTemplate(), query);
            Collection<ISearchEngineResult> results = this.performQuery(searchQuery, monitor);
            collector.accept(results.toArray(new ISearchEngineResult[results.size()]));
        }
        catch (Exception e) {
            Status error = new Status(4, "org.jboss.tools.help", e.getLocalizedMessage());
            JBossHelpActivator.getDefault().getLog().log((IStatus)error);
            collector.error((IStatus)error);
        }
    }

    protected Collection<ISearchEngineResult> performQuery(String searchQuery, IProgressMonitor monitor) throws IOException {
        ModelNode hitsNode;
        ModelNode hitsWrapper;
        ArrayList<ISearchEngineResult> results = null;
        ByteArrayOutputStream response = new ByteArrayOutputStream(64);
        new URLTransportUtility().download("Searching for help", searchQuery, (OutputStream)response, monitor);
        ModelNode searchResult = ModelNode.fromJSONStream((InputStream)new ByteArrayInputStream(response.toByteArray()));
        if (searchResult.isDefined() && (hitsWrapper = searchResult.get("hits")).isDefined() && (hitsNode = hitsWrapper.get("hits")).isDefined()) {
            List hits = hitsNode.asList();
            results = new ArrayList<ISearchEngineResult>(hits.size());
            for (ModelNode hit : hits) {
                if (monitor.isCanceled()) {
                    return results;
                }
                ISearchEngineResult result = SearchiskoResultBuilder.create(hit);
                if (result == null) continue;
                results.add(result);
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    protected String getSearchUrl(String urlTemplate, String query) {
        String eQuery;
        try {
            eQuery = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            eQuery = query;
        }
        return urlTemplate.replace("{expression}", eQuery);
    }
}

