/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFaces;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeClassUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesSubTableTemplate
extends VpeAbstractTemplate {
    private static final String DEAFAULT_CELL_CLASS = "dr-subtable-cell";
    private static List<String> rowClasses;
    private static List<String> columnClasses;
    private static final String ST_HEADER_CLASS = "dr-subtable-header rich-subtable-header";
    private static final String ST_HEADER_CONTINUE_CLASS = "dr-subtable-header-continue rich-subtable-header-continue";
    private static final String ST_FOOTER_CLASS = "dr-subtable-footer rich-subtable-footer";
    private static final String ST_FOOTER_CONTINUE_CLASS = "dr-subtable-footer-continue rich-subtable-footer-continue";
    public static final RichFacesSubTableTemplate DEFAULT_INSTANCE;

    static {
        DEFAULT_INSTANCE = new RichFacesSubTableTemplate();
    }

    public VpeCreationData encodeSubTable(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement parentVisualNode) {
        if (creationData != null) {
            this.encodeHeader(pageContext, creationData, sourceElement, visualDocument, parentVisualNode);
        }
        this.initClasses(sourceElement, null);
        nsIDOMElement curTr = visualDocument.createElement("tr");
        if (parentVisualNode == null) {
            parentVisualNode = curTr;
        }
        VisualDomUtil.copyAttributes((Node)sourceElement, (nsIDOMElement)curTr);
        boolean header = false;
        boolean footer = false;
        int curRow = 0;
        if (this.isHeader(sourceElement)) {
            curTr.setAttribute("class", this.getHeaderClass());
            String style = this.getHeaderBackgoundImgStyle();
            if (style != null) {
                curTr.setAttribute("style", style);
            }
            header = true;
        } else if (this.isFooter(sourceElement)) {
            curTr.setAttribute("class", this.getFooterClass());
            footer = true;
        } else {
            curTr.setAttribute("class", this.getRowClass(curRow));
        }
        if (creationData == null) {
            creationData = new VpeCreationData((nsIDOMNode)curTr);
        } else {
            parentVisualNode.appendChild((nsIDOMNode)curTr);
        }
        creationData.addChildrenInfo(new VpeChildrenInfo(null));
        VpeChildrenInfo trChildrenInfo = new VpeChildrenInfo(curTr);
        List<Node> children = ComponentUtil.getChildren(sourceElement);
        for (Node child : children) {
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            if (nodeName.endsWith(":column") || nodeName.endsWith(":columns")) {
                if (RichFacesColumnTemplate.isBreakBefore(child)) {
                    ++curRow;
                    curTr = visualDocument.createElement("tr");
                    VisualDomUtil.copyAttributes((Node)sourceElement, (nsIDOMElement)curTr);
                    if (header) {
                        curTr.setAttribute("class", this.getHeaderContinueClass());
                    } else if (footer) {
                        curTr.setAttribute("class", this.getFooterContinueClass());
                    } else {
                        curTr.setAttribute("class", this.getRowClass(curRow));
                    }
                    parentVisualNode.appendChild((nsIDOMNode)curTr);
                    trChildrenInfo = new VpeChildrenInfo(curTr);
                    creationData.addChildrenInfo(trChildrenInfo);
                }
                VpeChildrenInfo innerTdChildrenInfo = new VpeChildrenInfo(curTr);
                creationData.addChildrenInfo(innerTdChildrenInfo);
                innerTdChildrenInfo.addSourceChild(child);
                continue;
            }
            trChildrenInfo.addSourceChild(child);
        }
        if (parentVisualNode != null) {
            this.encodeFooter(pageContext, creationData, sourceElement, visualDocument, parentVisualNode);
        }
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData creationData) {
        this.initClasses(sourceNode, pageContext);
        nsIDOMNode visualNode = creationData.getNode();
        if (visualNode != null && visualNode.getNodeName().equalsIgnoreCase("tbody")) {
            this.addStylesToCells(visualDocument, visualNode);
        } else {
            RuntimeException e = new RuntimeException("This is probably a bug. The main tag of subTable shuld be 'TBODY'.");
            RichFacesTemplatesActivator.getPluginLog().logError((Throwable)e);
        }
    }

    private void addStylesToCells(nsIDOMDocument visualDocument, nsIDOMNode rowsContainer) {
        nsIDOMNodeList rowsContainerChildren = rowsContainer.getChildNodes();
        int j = 0;
        while ((long)j < rowsContainerChildren.getLength()) {
            nsIDOMNode tBodyChild = rowsContainerChildren.item((long)j);
            if (tBodyChild.getNodeType() == 1 && "tr".equalsIgnoreCase(tBodyChild.getNodeName())) {
                nsIDOMNodeList rowChildren = tBodyChild.getChildNodes();
                int column = 0;
                int i = 0;
                while ((long)i < rowChildren.getLength()) {
                    nsIDOMNode visualChild = rowChildren.item((long)i);
                    if (visualChild.getNodeType() == 1 && "td".equalsIgnoreCase(visualChild.getNodeName())) {
                        nsIDOMNode tableCell = visualChild;
                        nsIDOMNode columnStyle = tableCell.getAttributes().getNamedItem("class");
                        if (columnStyle == null) {
                            columnStyle = visualDocument.createAttribute("class");
                        }
                        columnStyle.setNodeValue(String.valueOf(columnStyle.getNodeValue()) + " " + this.getColumnClass(column));
                        ++column;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)tbody);
        creationData = this.encodeSubTable(pageContext, creationData, sourceElement, visualDocument, tbody);
        return creationData;
    }

    protected void encodeHeader(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement parentVisualNode) {
        this.encodeHeaderOrFooter(pageContext, creationData, sourceElement, visualDocument, parentVisualNode, "header", ST_HEADER_CLASS, "dr-subtable-headercell rich-subtable-headercell");
    }

    protected void encodeFooter(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement parentVisualNode) {
        this.encodeHeaderOrFooter(pageContext, creationData, sourceElement, visualDocument, parentVisualNode, "footer", ST_FOOTER_CLASS, "dr-subtable-footercell rich-subtable-footercell");
    }

    protected void encodeHeaderOrFooter(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement parentVisualNode, String facetName, String trClass, String tdClass) {
        ArrayList<Element> columns = RichFaces.getColumns(sourceElement);
        boolean hasColumnWithFacet = RichFaces.hasColumnWithFacet(columns, facetName);
        if (hasColumnWithFacet) {
            nsIDOMElement tr = visualDocument.createElement("tr");
            parentVisualNode.appendChild((nsIDOMNode)tr);
            String styleClass = trClass;
            if (styleClass != null) {
                tr.setAttribute("class", styleClass);
            }
            RichFacesDataTableTemplate.encodeHeaderOrFooterFacets(pageContext, creationData, tr, visualDocument, columns, tdClass, null, facetName, "td");
        }
    }

    private boolean isHeader(Element sourceElement) {
        return this.icludedInFacet(sourceElement, "header");
    }

    private boolean isFooter(Element sourceElement) {
        return this.icludedInFacet(sourceElement, "footer");
    }

    private boolean icludedInFacet(Element sourceElement, String facetName) {
        Node parent = sourceElement.getParentNode();
        return parent != null && ComponentUtil.isFacet(parent, facetName);
    }

    protected String getHeaderClass() {
        return ST_HEADER_CLASS;
    }

    protected String getHeaderContinueClass() {
        return ST_HEADER_CONTINUE_CLASS;
    }

    protected String getFooterClass() {
        return ST_FOOTER_CLASS;
    }

    protected String getFooterContinueClass() {
        return ST_FOOTER_CONTINUE_CLASS;
    }

    protected String getRowClass(int row) {
        int rowClassesSize;
        String rowClass = DEAFAULT_CELL_CLASS;
        if (rowClasses != null && (rowClassesSize = rowClasses.size()) > 0) {
            rowClass = rowClasses.get(row % rowClassesSize);
        }
        return rowClass;
    }

    private String getColumnClass(int column) {
        int columnClassesSize;
        String columnClass = DEAFAULT_CELL_CLASS;
        if (columnClasses != null && (columnClassesSize = columnClasses.size()) > 0) {
            columnClass = columnClasses.get(column % columnClassesSize);
        }
        return columnClass;
    }

    private void initClasses(Node sourceNode, VpePageContext pageContext) {
        VpeExpression exprRowClasses = RichFaces.getExprRowClasses();
        VpeExpression exprColumnClasses = RichFaces.getExprColumnClasses();
        try {
            rowClasses = VpeClassUtil.getClasses((VpeExpression)exprRowClasses, (Node)sourceNode, (VpePageContext)pageContext);
            columnClasses = VpeClassUtil.getClasses((VpeExpression)exprColumnClasses, (Node)sourceNode, (VpePageContext)pageContext);
        }
        catch (VpeExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getHeaderBackgoundImgStyle() {
        return null;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        Node parent = sourceNode.getParentNode();
        return parent;
    }
}

