/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.HashMap;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesMessageTemplate
extends VpeAbstractTemplate {
    protected static String VALIDATION_MESSAGE = "Validation message";
    protected static String ERROR_MESSAGE = "Error message";
    protected static String FATAL_MESSAGE = "Fatal message";
    protected static String INFO_MESSAGE = "Info message";
    protected static String WARNING_MESSAGE = "Warning message";
    protected static String FACET_TAG_NAME = ":facet";
    protected static String[] markers = new String[]{"passedMarker", "errorMarker", "fatalMarker", "infoMarker", "warnMarker"};
    private static final String MESSAGE_STYLE = "padding-left: 1px;padding-right: 1px;padding-top: 1px;padding-bottom: 1px";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        VpeCreationData creationData;
        Element sourceElement = (Element)sourceNode;
        Attributes attrs = new Attributes(sourceElement);
        HashMap<String, Node> facets = this.getFacelets(sourceElement);
        if (facets.size() != 0) {
            creationData = this.createVisualFacets(visualDocument, sourceElement, facets, attrs);
        } else {
            nsIDOMElement span = visualDocument.createElement("span");
            if (ComponentUtil.isNotBlank(attrs.getStyleValue())) {
                span.setAttribute("style", attrs.getStyleValue());
            }
            if (ComponentUtil.isNotBlank(attrs.getStyleClassValue())) {
                span.setAttribute("class", attrs.getStyleClassValue());
            }
            if (ComponentUtil.isNotBlank(attrs.getLabelClassValue())) {
                span.setAttribute("class", attrs.getLabelClassValue());
            }
            creationData = new VpeCreationData((nsIDOMNode)span);
            nsIDOMText passedText = visualDocument.createTextNode(VALIDATION_MESSAGE);
            span.appendChild((nsIDOMNode)passedText);
        }
        return creationData;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    protected boolean searchInMarker(String markerName) {
        if (markerName == null) {
            return false;
        }
        int i = 0;
        while (i < markers.length) {
            if (markers[i].equalsIgnoreCase(markerName.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private VpeCreationData createVisualFacets(nsIDOMDocument visualDocument, Element sourceElement, HashMap<String, Node> facets, Attributes attrs) {
        nsIDOMElement tableHeader = visualDocument.createElement("table");
        tableHeader.setAttribute("style", MESSAGE_STYLE);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)tableHeader);
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        tbody.setAttribute("valign", "top");
        tableHeader.appendChild((nsIDOMNode)tbody);
        nsIDOMElement tr = visualDocument.createElement("tr");
        tbody.appendChild((nsIDOMNode)tr);
        if (ComponentUtil.isNotBlank(attrs.getStyleValue())) {
            tableHeader.setAttribute("style", attrs.getStyleValue());
        }
        if (ComponentUtil.isNotBlank(attrs.getStyleClassValue())) {
            tableHeader.setAttribute("class", attrs.getStyleClassValue());
        }
        int i = 0;
        while (i < markers.length) {
            if (facets.containsKey(markers[i])) {
                nsIDOMElement td = visualDocument.createElement("td");
                switch (i) {
                    case 0: {
                        if (ComponentUtil.isNotBlank(attrs.getMarkerClassValue())) {
                            td.setAttribute("class", attrs.getMarkerClassValue());
                        }
                        if (!ComponentUtil.isNotBlank(attrs.getMarkerStyleValue())) break;
                        td.setAttribute("style", attrs.getMarkerStyleValue());
                        break;
                    }
                    case 1: {
                        if (ComponentUtil.isNotBlank(attrs.getErrorClassValue())) {
                            td.setAttribute("class", attrs.getErrorClassValue());
                        }
                        if (!ComponentUtil.isNotBlank(attrs.getErrorMarkerClassValue())) break;
                        td.setAttribute("class", attrs.getErrorMarkerClassValue());
                        break;
                    }
                    case 2: {
                        if (ComponentUtil.isNotBlank(attrs.getFatalClassValue())) {
                            td.setAttribute("class", attrs.getFatalClassValue());
                        }
                        if (!ComponentUtil.isNotBlank(attrs.getFatalMarkerClassValue())) break;
                        td.setAttribute("class", attrs.getFatalMarkerClassValue());
                        break;
                    }
                    case 3: {
                        if (ComponentUtil.isNotBlank(attrs.getInfoClassValue())) {
                            td.setAttribute("class", attrs.getInfoClassValue());
                        }
                        if (!ComponentUtil.isNotBlank(attrs.getInfoMarkerClassValue())) break;
                        td.setAttribute("class", attrs.getInfoMarkerClassValue());
                        break;
                    }
                    case 4: {
                        if (ComponentUtil.isNotBlank(attrs.getWarnClassValue())) {
                            td.setAttribute("class", attrs.getWarnClassValue());
                        }
                        if (!ComponentUtil.isNotBlank(attrs.getWarnMarkerClassValue())) break;
                        td.setAttribute("class", attrs.getWarnMarkerClassValue());
                        break;
                    }
                }
                VpeChildrenInfo childrenInfo = new VpeChildrenInfo(td);
                creationData.addChildrenInfo(childrenInfo);
                if (facets.get(markers[i]) instanceof Element) {
                    td.setAttribute("VPE-FACET", markers[i]);
                    childrenInfo.addSourceChild(facets.get(markers[i]));
                    tr.appendChild((nsIDOMNode)td);
                }
            }
            ++i;
        }
        nsIDOMElement td1 = visualDocument.createElement("td");
        if (ComponentUtil.isNotBlank(attrs.getLabelClassValue())) {
            td1.setAttribute("class", attrs.getLabelClassValue());
        }
        nsIDOMText passedText = visualDocument.createTextNode(VALIDATION_MESSAGE);
        tr.appendChild((nsIDOMNode)td1);
        td1.appendChild((nsIDOMNode)passedText);
        return creationData;
    }

    public void setSourceAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Object data) {
        VpeSourceDomBuilder sourceBuilder = pageContext.getSourceBuilder();
        sourceBuilder.setSelection((Node)sourceElement, 0, 0);
    }

    protected HashMap<String, Node> getFacelets(Element sourceElement) {
        NodeList nodeList = sourceElement.getChildNodes();
        HashMap<String, Node> facets = new HashMap<String, Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i) instanceof Element && nodeList.item(i).getNodeName().endsWith(FACET_TAG_NAME) && this.searchInMarker(((Element)nodeList.item(i)).getAttribute("name"))) {
                facets.put(((Element)nodeList.item(i)).getAttribute("name"), nodeList.item(i));
            }
            ++i;
        }
        return facets;
    }

    class Attributes {
        private String PASSED_LABEL_ATTRIBUTE_NAME = "passedLabel";
        private String LABEL_CLASS_ATTRIBUTE_NAME = "labelClass";
        private String MARKER_CLASS_ATTRIBUTE_NAME = "markerClass";
        private String MARKER_STYLE_ATTRIBUTE_NAME = "markerStyle";
        private String ERROR_MARKER_CLASS_ATTRIBUTE_NAME = "errorMarkerClass";
        private String ERROR_LABEL_CLASS_ATTRIBUTE_NAME = "errorLabelClass";
        private String ERROR_CLASS_ATTRIBUTE_NAME = "errorClass";
        private String FATAL_MARKER_CLASS_ATTRIBUTE_NAME = "fatalMarkerClass";
        private String FATAL_LABEL_CLASS_ATTRIBUTE_NAME = "fatalLabelClass";
        private String FATAL_CLASS_ATTRIBUTE_NAME = "fatalClass";
        private String INFO_MARKER_CLASS_ATTRIBUTE_NAME = "infoMarkerClass";
        private String INFO_LABEL_CLASS_ATTRIBUTE_NAME = "infoLabelClass";
        private String INFO_CLASS_ATTRIBUTE_NAME = "infoClass";
        private String WARN_MARKER_CLASS_ATTRIBUTE_NAME = "warnMarkerClass";
        private String WARN_LABEL_CLASS_ATTRIBUTE_NAME = "warnLabelClass";
        private String WARN_CLASS_ATTRIBUTE_NAME = "warnClass";
        private String passedLabelValue;
        private String labelClassValue;
        private String markerClassValue;
        private String markerStyleValue;
        private String errorMarkerClassValue;
        private String errorLabelClassValue;
        private String errorClassValue;
        private String fatalMarkerClassValue;
        private String fatalLabelClassValue;
        private String fatalClassValue;
        private String infoMarkerClassValue;
        private String infoLabelClassValue;
        private String infoClassValue;
        private String warnMarkerClassValue;
        private String warnLabelClassValue;
        private String warnClassValue;
        private String styleValue;
        private String styleClassValue;

        public Attributes(Element sourceElement) {
            this.passedLabelValue = sourceElement.getAttribute(this.PASSED_LABEL_ATTRIBUTE_NAME);
            this.labelClassValue = sourceElement.getAttribute(this.LABEL_CLASS_ATTRIBUTE_NAME);
            this.markerClassValue = sourceElement.getAttribute(this.MARKER_CLASS_ATTRIBUTE_NAME);
            this.markerStyleValue = sourceElement.getAttribute(this.MARKER_STYLE_ATTRIBUTE_NAME);
            this.errorMarkerClassValue = sourceElement.getAttribute(this.ERROR_MARKER_CLASS_ATTRIBUTE_NAME);
            this.errorLabelClassValue = sourceElement.getAttribute(this.ERROR_LABEL_CLASS_ATTRIBUTE_NAME);
            this.errorClassValue = sourceElement.getAttribute(this.ERROR_CLASS_ATTRIBUTE_NAME);
            this.fatalMarkerClassValue = sourceElement.getAttribute(this.FATAL_MARKER_CLASS_ATTRIBUTE_NAME);
            this.fatalLabelClassValue = sourceElement.getAttribute(this.FATAL_LABEL_CLASS_ATTRIBUTE_NAME);
            this.fatalClassValue = sourceElement.getAttribute(this.FATAL_CLASS_ATTRIBUTE_NAME);
            this.infoMarkerClassValue = sourceElement.getAttribute(this.INFO_MARKER_CLASS_ATTRIBUTE_NAME);
            this.infoLabelClassValue = sourceElement.getAttribute(this.INFO_LABEL_CLASS_ATTRIBUTE_NAME);
            this.infoClassValue = sourceElement.getAttribute(this.INFO_CLASS_ATTRIBUTE_NAME);
            this.warnMarkerClassValue = sourceElement.getAttribute(this.WARN_MARKER_CLASS_ATTRIBUTE_NAME);
            this.warnLabelClassValue = sourceElement.getAttribute(this.WARN_LABEL_CLASS_ATTRIBUTE_NAME);
            this.warnClassValue = sourceElement.getAttribute(this.WARN_CLASS_ATTRIBUTE_NAME);
            this.styleValue = sourceElement.getAttribute("style");
            this.styleClassValue = sourceElement.getAttribute("styleClass");
        }

        public String getErrorMarkerClassValue() {
            return this.errorMarkerClassValue;
        }

        public String getErrorLabelClassValue() {
            return this.errorLabelClassValue;
        }

        public String getErrorClassValue() {
            return this.errorClassValue;
        }

        public String getPassedLabelValue() {
            return this.passedLabelValue;
        }

        public String getLabelClassValue() {
            return this.labelClassValue;
        }

        public String getMarkerClassValue() {
            return this.markerClassValue;
        }

        public String getMarkerStyleValue() {
            return this.markerStyleValue;
        }

        public String getFatalMarkerClassValue() {
            return this.fatalMarkerClassValue;
        }

        public String getFatalLabelClassValue() {
            return this.fatalLabelClassValue;
        }

        public String getFatalClassValue() {
            return this.fatalClassValue;
        }

        public String getInfoMarkerClassValue() {
            return this.infoMarkerClassValue;
        }

        public String getInfoLabelClassValue() {
            return this.infoLabelClassValue;
        }

        public String getInfoClassValue() {
            return this.infoClassValue;
        }

        public String getWarnMarkerClassValue() {
            return this.warnMarkerClassValue;
        }

        public String getWarnLabelClassValue() {
            return this.warnLabelClassValue;
        }

        public String getWarnClassValue() {
            return this.warnClassValue;
        }

        public String getStyleValue() {
            return this.styleValue;
        }

        public String getStyleClassValue() {
            return this.styleClassValue;
        }
    }
}

