/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesAbstractInplaceTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesInplaceSelectTemplate
extends RichFacesAbstractInplaceTemplate {
    private static final String SOURCE_LIST_DEFAULT_HEIGHT = "24px";
    private static final String SOURCE_LIST_DEFAULT_WIDTH = "198px";
    private static final String INPLACE_SELECT_CSS = "inplaceSelect/inplaceSelect.css";
    private static final String INPLACE_SELECT_EXT = "inplaceSelect";
    protected String sourceListHeight;
    protected String sourceListWidth;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, this.getCssStyle(), this.getCssExtension());
        Element sourceElement = (Element)sourceNode;
        RichFacesAbstractInplaceTemplate.Attributes attrs = new RichFacesAbstractInplaceTemplate.Attributes(sourceElement);
        this.prepareData(pageContext, sourceElement);
        nsIDOMElement rootSpan = this.createRootSpanTemplateMethod(sourceElement, visualDocument, attrs);
        VpeCreationData creationData = VisualDomUtil.createTemplateWithTextContainer((Element)sourceElement, (nsIDOMElement)rootSpan, (String)"span", (nsIDOMDocument)visualDocument);
        if (this.isToggle) {
            nsIDOMElement innerInput1 = visualDocument.createElement("input");
            nsIDOMElement innerInput2 = visualDocument.createElement("input");
            this.preapareInputBase(innerInput1);
            this.preapareInputBase(innerInput2);
            innerInput1.setAttribute("vpe-user-toggle-id", String.valueOf(0));
            innerInput1.setAttribute("autocomplete", "off");
            innerInput1.setAttribute("class", "rich-inplace-select-field");
            innerInput1.setAttribute("value", attrs.getDefaultLabel() == null ? "" : attrs.getDefaultLabel());
            innerInput1.setAttribute("style", "top: 1px ; width:100px");
            innerInput1.setAttribute("value", this.getValue(attrs));
            innerInput2.setAttribute("class", "rich-inplace-select-arrow");
            innerInput2.setAttribute("style", "top: 2px; left: 89px;");
            rootSpan.appendChild((nsIDOMNode)innerInput1);
            rootSpan.appendChild((nsIDOMNode)innerInput2);
            List<Element> elements = ComponentUtil.getSelectItems(sourceElement.getChildNodes());
            if (elements != null && elements.size() > 0) {
                nsIDOMElement selectList = this.createSelectedList(elements, visualDocument);
                rootSpan.appendChild((nsIDOMNode)selectList);
            }
            if (attrs.isShowControls()) {
                rootSpan.appendChild((nsIDOMNode)this.createControlsDiv(pageContext, sourceNode, visualDocument, creationData, attrs));
            }
        } else {
            rootSpan.appendChild((nsIDOMNode)visualDocument.createTextNode(this.getValue(attrs)));
        }
        return creationData;
    }

    private nsIDOMElement createSelectedList(List<Element> elements, nsIDOMDocument visualDocument) {
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("class", "rich-inplace-select-width-list");
        div.setAttribute("vpe-user-toggle-id", String.valueOf(0));
        div.setAttribute("style", "position: absolute; height: 100px; left: 0px; top: 22px; visibility: visible;");
        nsIDOMElement shadowDiv = visualDocument.createElement("div");
        shadowDiv.setAttribute("class", "rich-inplace-select-list-shadow");
        shadowDiv.setAttribute("style", "");
        nsIDOMElement table = visualDocument.createElement("table");
        nsIDOMElement tr1 = visualDocument.createElement("tr");
        nsIDOMElement tr2 = visualDocument.createElement("tr");
        nsIDOMElement td1 = visualDocument.createElement("td");
        nsIDOMElement td2 = visualDocument.createElement("td");
        nsIDOMElement td3 = visualDocument.createElement("td");
        nsIDOMElement td4 = visualDocument.createElement("td");
        td1.setAttribute("class", "rich-inplace-select-shadow-tl");
        td2.setAttribute("class", "rich-inplace-select-shadow-tr");
        td3.setAttribute("class", "rich-inplace-select-shadow-bl");
        td4.setAttribute("class", "rich-inplace-select-shadow-br");
        nsIDOMElement img1 = visualDocument.createElement("img");
        nsIDOMElement img2 = visualDocument.createElement("img");
        nsIDOMElement img3 = visualDocument.createElement("img");
        nsIDOMElement img4 = visualDocument.createElement("img");
        this.setUpImg(img1, 10, 1, 0, this.SPACER_GIF);
        this.setUpImg(img2, 1, 10, 0, this.SPACER_GIF);
        this.setUpImg(img3, 1, 10, 0, this.SPACER_GIF);
        this.setUpImg(img4, 10, 10, 0, this.SPACER_GIF);
        nsIDOMElement listPositionDiv = visualDocument.createElement("div");
        listPositionDiv.setAttribute("class", "rich-inplace-select-list-position");
        listPositionDiv.setAttribute("vpe-user-toggle-id", String.valueOf(0));
        nsIDOMElement listDecarationDiv = visualDocument.createElement("div");
        listDecarationDiv.setAttribute("class", "rich-inplace-select-list-decoration");
        nsIDOMElement listScrollDiv = visualDocument.createElement("div");
        if (this.sourceListHeight == SOURCE_LIST_DEFAULT_HEIGHT) {
            int height = 24;
            if (elements.size() > 1) {
                height += (elements.size() - 2) * 24 + 1;
            }
            this.sourceListHeight = String.valueOf(String.valueOf(height)) + "px";
        }
        String dropDownListSizesStyle = "height:" + this.sourceListHeight + ";" + " " + "width" + ":" + this.sourceListWidth + ";";
        table.setAttribute("style", dropDownListSizesStyle);
        listScrollDiv.setAttribute("class", "rich-inplace-select-list-scroll");
        listScrollDiv.setAttribute("style", dropDownListSizesStyle);
        if (elements.size() > 0) {
            for (Element e : elements) {
                nsIDOMElement span = visualDocument.createElement("span");
                span.setAttribute("class", "rich-inplace-select-item rich-inplace-select-font");
                span.appendChild((nsIDOMNode)visualDocument.createTextNode(ComponentUtil.getSelectItemValue(e)));
                span.setAttribute("style", "text-align: left;");
                listScrollDiv.appendChild((nsIDOMNode)span);
            }
        }
        div.appendChild((nsIDOMNode)shadowDiv);
        div.appendChild((nsIDOMNode)listPositionDiv);
        listPositionDiv.appendChild((nsIDOMNode)listDecarationDiv);
        listDecarationDiv.appendChild((nsIDOMNode)listScrollDiv);
        shadowDiv.appendChild((nsIDOMNode)table);
        table.appendChild((nsIDOMNode)tr1);
        tr1.appendChild((nsIDOMNode)td1);
        tr1.appendChild((nsIDOMNode)td2);
        td1.appendChild((nsIDOMNode)img1);
        td1.appendChild((nsIDOMNode)visualDocument.createElement("br"));
        td2.appendChild((nsIDOMNode)img2);
        td2.appendChild((nsIDOMNode)visualDocument.createElement("br"));
        table.appendChild((nsIDOMNode)tr2);
        tr2.appendChild((nsIDOMNode)td3);
        tr2.appendChild((nsIDOMNode)td4);
        td3.appendChild((nsIDOMNode)img3);
        td3.appendChild((nsIDOMNode)visualDocument.createElement("br"));
        td4.appendChild((nsIDOMNode)img4);
        td4.appendChild((nsIDOMNode)visualDocument.createElement("br"));
        return div;
    }

    @Override
    protected String getCssExtension() {
        return INPLACE_SELECT_EXT;
    }

    @Override
    protected String getCssStyle() {
        return INPLACE_SELECT_CSS;
    }

    @Override
    protected String getCssStylesSuffix() {
        return "-select";
    }

    @Override
    protected String[] getRootSpanClasses(RichFacesAbstractInplaceTemplate.Attributes attrs) {
        String[] result = new String[3];
        String clazz = "";
        if (this.isToggle) {
            result[0] = "rich-inplace-select-edit";
            if (ComponentUtil.isNotBlank(attrs.getEditClass())) {
                clazz = attrs.getEditClass();
            }
        } else {
            result[0] = "rich-inplace-select-view";
            if (ComponentUtil.isNotBlank(attrs.getViewClass())) {
                clazz = attrs.getViewClass();
            }
        }
        result[1] = clazz;
        if (ComponentUtil.isNotBlank(attrs.getStyleClass())) {
            result[2] = attrs.getStyleClass();
        }
        return result;
    }

    private void preapareInputBase(nsIDOMElement innerInput) {
        innerInput.setAttribute("type", "text");
        innerInput.setAttribute("readonly", "text");
    }

    @Override
    protected void prepareData(VpePageContext pageContext, Element source) {
        this.sourceListHeight = ComponentUtil.getAttribute(source, "listHeight");
        this.sourceListWidth = ComponentUtil.getAttribute(source, "listWidth");
        if (ComponentUtil.isBlank(this.sourceListHeight)) {
            this.sourceListHeight = SOURCE_LIST_DEFAULT_HEIGHT;
        }
        if (ComponentUtil.isBlank(this.sourceListWidth)) {
            this.sourceListWidth = SOURCE_LIST_DEFAULT_WIDTH;
        }
        super.prepareImages(source);
    }

    @Override
    protected void initPositions() {
        this.controlsVerticalPositions.put("center", "100px");
    }

    @Override
    protected String getCssStylesControlSuffix() {
        return this.getCssStylesSuffix();
    }

    @Override
    protected String getControlPositionsSubStyles(RichFacesAbstractInplaceTemplate.Attributes attrs) {
        return "top:0px ; left: " + (String)this.controlsVerticalPositions.get(attrs.getControlsVerticalPosition()) + ";left: " + (String)this.controlsHorizontalPositions.get(attrs.getControlsHorizontalPosition()) + ";";
    }

    @Override
    protected String getMainControlsDivCssClass() {
        return "rich-inplace" + this.getCssStylesControlSuffix() + "-control-set";
    }
}

