/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesAbstractInplaceTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesInplaceInputTemplate
extends RichFacesAbstractInplaceTemplate {
    protected String inputWidth = null;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, this.getCssStyle(), this.getCssExtension());
        Element sourceElement = (Element)sourceNode;
        RichFacesAbstractInplaceTemplate.Attributes attrs = new RichFacesAbstractInplaceTemplate.Attributes(sourceElement);
        this.prepareData(pageContext, sourceElement);
        nsIDOMElement rootSpan = this.createRootSpanTemplateMethod(sourceElement, visualDocument, attrs);
        nsIDOMElement innerInput1 = visualDocument.createElement("input");
        nsIDOMElement topContainer = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument);
        nsIDOMElement textContainer = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument);
        topContainer.appendChild((nsIDOMNode)textContainer);
        topContainer.appendChild((nsIDOMNode)rootSpan);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)topContainer);
        List<Node> children = ComponentUtil.getChildren(sourceElement, true);
        VpeChildrenInfo spanInfo = null;
        if (!children.isEmpty()) {
            spanInfo = new VpeChildrenInfo(textContainer);
            for (Node child : children) {
                spanInfo.addSourceChild(child);
            }
            creationData.addChildrenInfo(spanInfo);
        }
        if (this.isToggle) {
            rootSpan.appendChild((nsIDOMNode)innerInput1);
            innerInput1.setAttribute("vpe-user-toggle-id", String.valueOf(0));
            innerInput1.setAttribute("class", "rich-inplace-field");
            innerInput1.setAttribute("style", "top: 0px; width: " + this.inputWidth + ";");
            innerInput1.setAttribute("type", "text");
            innerInput1.setAttribute("autocomplete", "off");
            if (attrs.isShowControls()) {
                rootSpan.appendChild((nsIDOMNode)this.createControlsDiv(pageContext, sourceNode, visualDocument, creationData, attrs));
            }
        } else {
            innerInput1.setAttribute("style", "width: " + this.inputWidth + "; position: absolute; left: -32767px;");
            innerInput1.setAttribute("type", "button");
        }
        Element controlFacet = ComponentUtil.getFacetElement((Element)sourceNode, "controls", false);
        Map controlFacetChildren = VisualDomUtil.findFacetElements((Node)controlFacet, (VpePageContext)pageContext);
        spanInfo = new VpeChildrenInfo(textContainer);
        for (Node child : (List)controlFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
            spanInfo.addSourceChild(child);
        }
        if (spanInfo.getSourceChildren() != null && spanInfo.getSourceChildren().size() > 0) {
            creationData.addChildrenInfo(spanInfo);
        }
        if (!this.isToggle) {
            rootSpan.appendChild((nsIDOMNode)visualDocument.createTextNode(this.getValue(attrs)));
        } else {
            innerInput1.setAttribute("value", this.getValue(attrs));
        }
        return creationData;
    }

    @Override
    protected String getCssExtension() {
        return "inplaceInput";
    }

    @Override
    protected String getCssStyle() {
        return "inplaceInput/inplaceInput.css";
    }

    @Override
    protected String getCssStylesSuffix() {
        return "";
    }

    @Override
    protected String[] getRootSpanClasses(RichFacesAbstractInplaceTemplate.Attributes attrs) {
        String[] rst = new String[3];
        String clazz = "";
        if (this.isToggle) {
            rst[0] = "rich-inplace-edit";
            if (ComponentUtil.isNotBlank(attrs.getEditClass())) {
                rst[1] = clazz = attrs.getEditClass();
            }
        } else {
            rst[0] = "rich-inplace-view";
            if (ComponentUtil.isNotBlank(attrs.getViewClass())) {
                rst[1] = clazz = attrs.getViewClass();
            }
        }
        if (ComponentUtil.isNotBlank(attrs.getStyleClass())) {
            rst[2] = attrs.getStyleClass();
        }
        return rst;
    }

    @Override
    protected void prepareData(VpePageContext pageContext, Element source) {
        try {
            this.inputWidth = String.valueOf(String.valueOf(ComponentUtil.parseWidthHeightValue(source.getAttribute("inputWidth")))) + "px";
        }
        catch (NumberFormatException numberFormatException) {
            this.inputWidth = "66px";
        }
        this.controlsHorizontalPositions.put("right", this.inputWidth);
        this.controlsHorizontalPositions.put("center", "18px");
        super.prepareImages(source);
    }

    @Override
    public String getCssStylesControlSuffix() {
        return "-input";
    }

    @Override
    protected String getControlPositionsSubStyles(RichFacesAbstractInplaceTemplate.Attributes attrs) {
        return "top: " + (String)this.controlsVerticalPositions.get(attrs.getControlsVerticalPosition()) + ";left: " + (String)this.controlsHorizontalPositions.get(attrs.getControlsHorizontalPosition()) + ";";
    }

    @Override
    protected String getMainControlsDivCssClass() {
        return "rich-inplace" + this.getCssStylesControlSuffix() + "-controls-set";
    }
}

