/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesDataOrderedListTemplate
extends VpeAbstractTemplate {
    private static final String ORDERED_LIST_CLASSES = "dr-list rich-orderedlist";
    private static final String LIST_ITEM_CLASSES = "dr-list-item rich-list-item";
    private static final String CSS_FILE_NAME = "dataOrderedList/dataOrderedList.css";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement orderedList = visualDocument.createElement("ol");
        ComponentUtil.setCSSLink(pageContext, CSS_FILE_NAME, "richFacesDataOrderList");
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)orderedList);
        ComponentUtil.correctAttribute(sourceElement, orderedList, "styleClass", "class", ORDERED_LIST_CLASSES, ORDERED_LIST_CLASSES);
        ComponentUtil.correctAttribute(sourceElement, orderedList, "style", "style", null, null);
        VpeCreationData creatorInfo = new VpeCreationData((nsIDOMNode)orderedList);
        creatorInfo.addChildrenInfo(new VpeChildrenInfo(null));
        int rows = 1;
        try {
            rows = Integer.parseInt(sourceElement.getAttribute("rows"));
        }
        catch (NumberFormatException numberFormatException) {}
        String rowClassesString = sourceElement.getAttribute("rowClasses");
        String[] rowClasses = null;
        if (ComponentUtil.isNotBlank(rowClassesString)) {
            rowClasses = rowClassesString.split(",");
        }
        int i = 0;
        do {
            nsIDOMElement listItem = visualDocument.createElement("li");
            String rowClass = LIST_ITEM_CLASSES;
            if (rowClasses != null && rowClasses.length > 0) {
                rowClass = String.valueOf(rowClass) + " " + rowClasses[i % rowClasses.length];
            }
            listItem.setAttribute("class", rowClass);
            orderedList.appendChild((nsIDOMNode)listItem);
            VpeChildrenInfo info = new VpeChildrenInfo(listItem);
            this.encodeListItem(info, sourceElement);
            creatorInfo.addChildrenInfo(info);
        } while (++i < rows);
        return creatorInfo;
    }

    void encodeListItem(VpeChildrenInfo info, Element sourceElement) {
        int cnt;
        NodeList children = sourceElement.getChildNodes();
        int n = cnt = children != null ? children.getLength() : 0;
        if (cnt > 0) {
            int i = 0;
            while (i < cnt) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    info.addSourceChild((Node)childElement);
                }
                ++i;
            }
        }
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

