/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RichFacesAbstractTreeTemplate
extends VpeAbstractTemplate {
    public static final String TREE = "tree";
    public static final String TREE_NODE = "treeNode";
    public static final String TREE_NODES_ADAPTOR = "treeNodesAdaptor";
    public static final String RECURSIVE_TREE_NODES_ADAPTOR = "recursiveTreeNodesAdaptor";
    public static final String TREE_MODEL_ADAPTOR = "treeModelAdaptor";
    public static final String TREE_MODEL_RECURSIVE_ADAPTOR = "treeModelRecursiveAdaptor";
    public static final String SHOW_LINES_ATTR_NAME = "showConnectingLines";
    public static final String NODES_NAME = "nodes";
    public static final String DEFAULT_ICON_PARAM_VALUE = "DEFAULT_ICON_PARAM";
    public static final String ICON_PARAM_NAME = "richFacesTreeNodeParam";
    public static final String DEFAULT_ICON_EXPANDED_PARAM_VALUE = "DEFAULT_ICON_EXPANDED_PARAM";
    public static final String UNDEFINED_ICON = "/tree/unresolved.gif";
    public static final String NODE_ICON_LEAF_ATTR_NAME = "iconLeaf";
    public static final String ICON_NODE_WITH_LINES = "/tree/iconNodeWithLines.gif";
    public static final String ICON_NODE_WITH_LINE = "/tree/iconNodeWithLine.gif";
    public static final String ICON_EXPANDED_WITH_LINES = "/tree/iconCollapsedWithLines.gif";
    public static final String ICON_NODE_WITHOUT_LINES = "/tree/iconNode.gif";
    public static final String ICON_EXPANDED_WITHOUT_LINES = "/tree/iconCollapsed.gif";
    public static final String ICON_NOT_EXPANDED_WITH_LINES = "/tree/iconNotCollapsedWithLines.gif";
    public static final String ICON_NOT_EXPANDED_WITH_ALL_LINES = "/tree/iconNotCollapsedWithAllLines.gif";
    public static final String ICON_NOT_EXPANDED_WITHOUT_LINES = "/tree/iconNotCollapsed.gif";
    public static final String ICON_EXPANDED_ADAPTER_WITH_LINES = "/tree/iconClosedNodeWithLines.gif";
    public static final String ICON_EXPANDED_ADAPTER_WITHOUT_LINES = "/tree/iconClosedNode.gif";
    public static final String ICON_LEAF_WITH_LINES = "/tree/iconLeafWithLines.gif";
    public static final String ICON_RIGHT_LINE = "/tree/rightLine.gif";
    public static final String ICON_LEFT_LINE = "/tree/leftLine.gif";
    public static final String ICON_LINE = "/tree/line.gif";
    public static final String ICON_LEAF_WITHOUT_LINES = "/tree/iconLeaf.gif";
    protected static final String TREE_TABLE_PICTURE_STYLE_CLASS_NAME = "treePictureStyle";
    protected static final String STYLE_CLASS_FOR_NODE_TITLE = "treeNodeNameStyle";
    protected static final String NODE_TITLE_STYLE_CLASS_ATTR_NAME = "nodeClass";
    protected static final String NODE_ICON_EXPANDED_ATTR_NAME = "iconExpanded";
    protected static final String NODE_ICON_ATTR_NAME = "icon";
    protected static final String TREE_TABLE_ATR_CELLSPACING_VALUE = "0px";
    protected static final String TREE_TABLE_ATR_CELLPADDING_VALUE = "0px";
    protected static final String TREE_TABLE_ATR_BORDER_VALUE = "0px";
    protected static final String NODE_LINES_STYLE = "background-position: center; background-repeat: repeat-y;";

    protected boolean getShowLinesAttr(Node sourceNode) {
        String treeName = String.valueOf(sourceNode.getPrefix()) + ":" + TREE;
        do {
            if ((sourceNode = sourceNode.getParentNode()) instanceof Element) continue;
            return true;
        } while (!sourceNode.getNodeName().equals(treeName));
        String showLinesParam = ((Element)sourceNode).getAttribute(SHOW_LINES_ATTR_NAME);
        boolean showLinesValue = true;
        if (showLinesParam != null && "false".equalsIgnoreCase(showLinesParam)) {
            showLinesValue = false;
        }
        return showLinesValue;
    }

    protected boolean isAdapterBetweenNodes(Node sourceNode) {
        Node parentNode = sourceNode.getParentNode();
        NodeList childs = parentNode.getChildNodes();
        Node beforeAdapterNode = null;
        Node afterAdapterNode = null;
        Node adapterNode = null;
        int i = 0;
        while (i < childs.getLength()) {
            Node el = childs.item(i);
            if (el instanceof Element) {
                if (el.equals(sourceNode)) {
                    adapterNode = el;
                } else if (el.getNodeName().endsWith(":treeNode")) {
                    if (adapterNode == null) {
                        beforeAdapterNode = el;
                    } else {
                        afterAdapterNode = el;
                    }
                }
            }
            ++i;
        }
        return beforeAdapterNode != null && afterAdapterNode != null;
    }

    protected boolean isHasNextAdaptorElement(Node sourceNode) {
        Node parentTree = sourceNode.getParentNode();
        if (!(parentTree instanceof Element)) {
            return true;
        }
        NodeList childs = parentTree.getChildNodes();
        Node lastElement = null;
        Node el = null;
        int i = 0;
        while (i < childs.getLength()) {
            el = childs.item(i);
            if (el instanceof Element) {
                if (lastElement != null) break;
                if (sourceNode.equals(el)) {
                    lastElement = el;
                }
            }
            ++i;
        }
        return el.getNodeName().endsWith(":treeNodesAdaptor") || el.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || el.getNodeName().endsWith(":treeModelAdaptor") || el.getNodeName().endsWith(":treeModelRecursiveAdaptor");
    }

    protected boolean isHasNextParentAdaptorElement(Node sourceNode) {
        Node tree = sourceNode.getParentNode();
        if (!(tree instanceof Element)) {
            return true;
        }
        Node parentTree = tree.getParentNode();
        if (!(parentTree instanceof Element)) {
            return true;
        }
        NodeList childs = parentTree.getChildNodes();
        Node lastElement = null;
        Node el = null;
        int i = 0;
        while (i < childs.getLength()) {
            el = childs.item(i);
            if (el instanceof Element) {
                if (lastElement != null) break;
                if (el.equals(tree)) {
                    lastElement = el;
                }
            }
            ++i;
        }
        return el.getNodeName().endsWith(":treeNode") || el.getNodeName().endsWith(":treeNodesAdaptor") || el.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || el.getNodeName().endsWith(":treeModelAdaptor") || el.getNodeName().endsWith(":treeModelRecursiveAdaptor");
    }

    protected boolean isHasParentAdapter(Node sourceNode) {
        Node node = sourceNode.getParentNode();
        return node.getNodeName().endsWith(":treeNodesAdaptor") || node.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || node.getNodeName().endsWith(":treeModelAdaptor") || node.getNodeName().endsWith(":treeModelRecursiveAdaptor");
    }

    protected void parseTree(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData vpeCreationData, nsIDOMElement parentElement) {
        NodeList nodeList = sourceNode.getChildNodes();
        Element element = null;
        int lenght = nodeList.getLength();
        VpeChildrenInfo vpeChildrenInfo = null;
        int i = 0;
        while (i < lenght) {
            if (nodeList.item(i) instanceof Element) {
                element = (Element)nodeList.item(i);
                if (element.getNodeName().endsWith(":treeNode") || element.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || element.getNodeName().endsWith(":treeModelRecursiveAdaptor")) {
                    vpeChildrenInfo = new VpeChildrenInfo(parentElement);
                    vpeCreationData.addChildrenInfo(vpeChildrenInfo);
                    vpeChildrenInfo.addSourceChild((Node)element);
                } else if (element.getNodeName().endsWith(":treeNodesAdaptor") || element.getNodeName().endsWith(":treeModelAdaptor")) {
                    vpeChildrenInfo = new VpeChildrenInfo(parentElement);
                    vpeCreationData.addChildrenInfo(vpeChildrenInfo);
                    vpeChildrenInfo.addSourceChild((Node)element);
                }
            }
            ++i;
        }
    }

    protected void createBasicTree(VpePageContext pageContext, nsIDOMDocument visualDocument, nsIDOMElement treeRow, Node sourceNode, VpeCreationData vpeCreationData) {
        String path;
        String backgroundLinePath = null;
        boolean showLinesValue = this.getShowLinesAttr((Element)sourceNode);
        nsIDOMElement iconNode = visualDocument.createElement("td");
        nsIDOMElement td1 = visualDocument.createElement("td");
        if (!this.isLastElement(sourceNode) && this.isAdaptorChild(sourceNode) && !this.isHasNextAdaptorElement(sourceNode)) {
            backgroundLinePath = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_LINE;
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, td1, NODE_ICON_EXPANDED_ATTR_NAME, showLinesValue ? ICON_EXPANDED_ADAPTER_WITH_LINES : ICON_EXPANDED_ADAPTER_WITHOUT_LINES);
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, iconNode, NODE_ICON_ATTR_NAME, showLinesValue ? ICON_NODE_WITH_LINE : ICON_NODE_WITHOUT_LINES);
        } else if (!this.isLastElement(sourceNode) && this.isAdaptorChild(sourceNode) && this.isHasNextAdaptorElement(sourceNode)) {
            backgroundLinePath = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_LINE;
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, td1, NODE_ICON_EXPANDED_ATTR_NAME, showLinesValue ? ICON_EXPANDED_ADAPTER_WITH_LINES : ICON_EXPANDED_ADAPTER_WITHOUT_LINES);
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, iconNode, NODE_ICON_ATTR_NAME, showLinesValue ? ICON_NODE_WITH_LINES : ICON_NODE_WITHOUT_LINES);
            if (showLinesValue) {
                path = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_LEFT_LINE;
                iconNode.setAttribute("style", "background-image: url(file://" + path + "); " + NODE_LINES_STYLE);
            }
        } else if (this.isAdaptorChild(sourceNode) && this.isLastElement(sourceNode) && this.isLastElementAfterAdaptor(sourceNode) == this.isAdaptorInTree(sourceNode) || !this.isAdaptorChild(sourceNode) && this.isLastElement(sourceNode) || this.isAdaptorChild(sourceNode) && this.isOnlyOneNodeInAdaptor(sourceNode)) {
            if (this.isAdaptorChild(sourceNode) && this.isOnlyOneNodeInAdaptor(sourceNode) && !this.isLastElementAfterAdaptor(sourceNode) && this.isHasNextParentAdaptorElement(sourceNode)) {
                backgroundLinePath = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_LINE;
                this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, td1, NODE_ICON_EXPANDED_ATTR_NAME, showLinesValue ? ICON_NOT_EXPANDED_WITH_ALL_LINES : ICON_NOT_EXPANDED_WITHOUT_LINES);
            } else {
                backgroundLinePath = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_RIGHT_LINE;
                this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, td1, NODE_ICON_EXPANDED_ATTR_NAME, showLinesValue ? ICON_NOT_EXPANDED_WITH_LINES : ICON_NOT_EXPANDED_WITHOUT_LINES);
            }
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, iconNode, NODE_ICON_LEAF_ATTR_NAME, showLinesValue ? ICON_LEAF_WITH_LINES : ICON_LEAF_WITHOUT_LINES);
        } else {
            backgroundLinePath = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_RIGHT_LINE;
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, td1, NODE_ICON_EXPANDED_ATTR_NAME, showLinesValue ? ICON_EXPANDED_WITH_LINES : ICON_EXPANDED_WITHOUT_LINES);
            if (showLinesValue) {
                path = String.valueOf(RichFacesTemplatesActivator.getPluginResourcePath()) + ICON_LEFT_LINE;
                iconNode.setAttribute("style", "background-image: url(file://" + path + "); " + NODE_LINES_STYLE);
            }
            this.setAttributeForPictureNode(pageContext, visualDocument, (Element)sourceNode, iconNode, NODE_ICON_ATTR_NAME, showLinesValue ? ICON_NODE_WITH_LINES : ICON_NODE_WITHOUT_LINES);
        }
        if (showLinesValue) {
            td1.setAttribute("style", "background-image: url(file://" + backgroundLinePath + "); " + NODE_LINES_STYLE);
        }
        treeRow.appendChild((nsIDOMNode)td1);
        treeRow.appendChild((nsIDOMNode)iconNode);
        nsIDOMElement nodeTitle = visualDocument.createElement("td");
        this.addBasicNodeTitleAttributes(nodeTitle);
        if (sourceNode.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || sourceNode.getNodeName().endsWith(":treeModelRecursiveAdaptor")) {
            Element sourceElement = (Element)sourceNode;
            String nodesAttrValue = sourceElement.hasAttribute(NODES_NAME) ? sourceElement.getAttribute(NODES_NAME) : "";
            nsIDOMElement textContainer = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument);
            nsIDOMText text = visualDocument.createTextNode(nodesAttrValue);
            textContainer.appendChild((nsIDOMNode)text);
            nodeTitle.appendChild((nsIDOMNode)textContainer);
        } else {
            VpeChildrenInfo tdInfo = new VpeChildrenInfo(nodeTitle);
            List<Node> children = ComponentUtil.getChildren((Element)sourceNode, true);
            for (Node child : children) {
                tdInfo.addSourceChild(child);
            }
            vpeCreationData.addChildrenInfo(tdInfo);
        }
        treeRow.appendChild((nsIDOMNode)nodeTitle);
    }

    protected boolean isLastElement(nsIDOMNode sourceNode) {
        nsIDOMNode parentTree = sourceNode.getParentNode();
        if (!(parentTree instanceof Element)) {
            return true;
        }
        nsIDOMNodeList childs = parentTree.getChildNodes();
        nsIDOMNode lastElement = null;
        nsIDOMNode el = null;
        int i = 0;
        while ((long)i < childs.getLength()) {
            el = childs.item((long)i);
            if (el.getNodeName().endsWith(":treeNode") || el.getNodeName().endsWith(":treeNodesAdaptor") || el.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || el.getNodeName().endsWith(":treeModelAdaptor") || el.getNodeName().endsWith(":treeModelRecursiveAdaptor")) {
                lastElement = el;
            }
            ++i;
        }
        return sourceNode.equals(lastElement);
    }

    private boolean isAdaptorChild(Node sourceNode) {
        Node parentNode = sourceNode.getParentNode();
        if (!(parentNode instanceof Element)) {
            return true;
        }
        return parentNode.getNodeName().endsWith(":treeNodesAdaptor") || parentNode.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || parentNode.getNodeName().endsWith(":treeModelAdaptor") || parentNode.getNodeName().endsWith(":treeModelRecursiveAdaptor");
    }

    protected boolean isLastElement(Node sourceNode) {
        Node parentTree = sourceNode.getParentNode();
        if (!(parentTree instanceof Element)) {
            return true;
        }
        NodeList childs = parentTree.getChildNodes();
        Node lastElement = null;
        Node el = null;
        int i = 0;
        while (i < childs.getLength()) {
            el = childs.item(i);
            if (el.getNodeName().endsWith(":treeNode") || el.getNodeName().endsWith(":treeNodesAdaptor") || el.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || el.getNodeName().endsWith(":treeModelAdaptor") || el.getNodeName().endsWith(":treeModelRecursiveAdaptor")) {
                lastElement = el;
            }
            ++i;
        }
        return sourceNode.equals(lastElement);
    }

    private void addBasicAttributesToPicture(nsIDOMElement img) {
        img.setAttribute("class", TREE_TABLE_PICTURE_STYLE_CLASS_NAME);
    }

    private void addBasicNodeTitleAttributes(nsIDOMElement nodeTitle) {
        nodeTitle.setAttribute("class", STYLE_CLASS_FOR_NODE_TITLE);
    }

    private void setAttributeForPictureNode(VpePageContext pageContext, nsIDOMDocument visualDocument, Element sourceNode, nsIDOMElement iconCell, String nodeAttrName, String defaultImage) {
        if (RichFacesTemplatesActivator.getDefault().isDebugging()) {
            System.out.println("call setAttributeForPictureNode");
        }
        nsIDOMElement img = visualDocument.createElement("img");
        this.addBasicAttributesToPicture(img);
        iconCell.appendChild((nsIDOMNode)img);
        String imgName = sourceNode.getAttribute(nodeAttrName);
        if (imgName == null || imgName.length() == 0) {
            Node parentElement = sourceNode.getParentNode();
            if (parentElement instanceof Element) {
                imgName = ((Element)parentElement).getAttribute(nodeAttrName);
            }
        } else {
            img.setAttribute(ICON_PARAM_NAME, "");
        }
        this.addBasicAttributesToPicture(img);
        iconCell.appendChild((nsIDOMNode)img);
        if (imgName == null || imgName.length() == 0) {
            ComponentUtil.setImg(img, defaultImage);
        } else {
            ComponentUtil.setImgFromResources(pageContext, img, imgName, UNDEFINED_ICON);
        }
        if (nodeAttrName.equals(NODE_ICON_EXPANDED_ATTR_NAME)) {
            img.setAttribute(ICON_PARAM_NAME, DEFAULT_ICON_EXPANDED_PARAM_VALUE);
        } else if (nodeAttrName.equals(NODE_ICON_ATTR_NAME)) {
            img.setAttribute(ICON_PARAM_NAME, DEFAULT_ICON_PARAM_VALUE);
        } else if (nodeAttrName.equals(NODE_ICON_LEAF_ATTR_NAME)) {
            img.setAttribute(ICON_PARAM_NAME, NODE_ICON_LEAF_ATTR_NAME);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOnlyOneNodeInAdaptor(Node sourceNode) {
        Node parent = sourceNode.getParentNode();
        NodeList list = parent.getChildNodes();
        Node currentNode = null;
        int i = 0;
        while (i < list.getLength()) {
            Node el = list.item(i);
            if (el instanceof Element) {
                if (!el.getNodeName().endsWith(":treeNode")) return false;
                if (currentNode != null) return false;
                currentNode = el;
            }
            ++i;
        }
        return true;
    }

    private boolean isLastElementAfterAdaptor(Node sourceNode) {
        Node nodeAdaptor = sourceNode.getParentNode();
        if (!(nodeAdaptor instanceof Element)) {
            return true;
        }
        return this.isLastElement(nodeAdaptor);
    }

    private boolean isAdaptorInTree(Node sourceNode) {
        Node treeNode;
        Node adaptorNode = sourceNode.getParentNode();
        if (!(adaptorNode instanceof Element)) {
            return true;
        }
        return (adaptorNode.getNodeName().endsWith(":treeNodesAdaptor") || adaptorNode.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || adaptorNode.getNodeName().endsWith(":treeModelAdaptor") || adaptorNode.getNodeName().endsWith(":treeModelRecursiveAdaptor")) && (treeNode = adaptorNode.getParentNode()).getNodeName().endsWith(":tree");
    }

    protected void addBasicTreeNodeAttributes(nsIDOMElement table) {
        if (table == null) {
            return;
        }
        table.setAttribute("cellpadding", "0px");
        table.setAttribute("cellspacing", "0px");
        table.setAttribute("border", "0px");
        table.setAttribute("class", "dr-tree-full-width");
    }

    protected void addAttributeToTableNode(Element sourceNode, nsIDOMElement tableRow) {
        if (sourceNode.hasAttribute(NODE_TITLE_STYLE_CLASS_ATTR_NAME)) {
            tableRow.setAttribute("class", sourceNode.getAttribute(NODE_TITLE_STYLE_CLASS_ATTR_NAME));
        }
    }
}

