/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.AbstractRichFacesTemplate;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class RichFacesAbstractInplaceTemplate
extends AbstractRichFacesTemplate
implements VpeToggableTemplate {
    protected static final String APPLY_BUTTON_GIF = "/applyButton.gif";
    protected static final String CANCEL_BUTTON_GIF = "/cancelButton.gif";
    protected final Map<String, String> controlsVerticalPositions = new HashMap<String, String>();
    protected static final String DEFAULT_INPUT_WIDTH_VALUE = "66px";
    protected static final String DEFAULT_VERTICAL_POSITION = null;
    protected static final Map<String, String> defaultButtonImages = new HashMap<String, String>();
    protected static final Map<String, String> defaultStyleClasses = new HashMap<String, String>();
    protected static final String RICH_INPLACE_VIEW_DEFAULT_STYLE_CLASS = "rich-inplace-view";
    protected final Map<String, String> buttonImages = new HashMap<String, String>();
    protected final Map<String, String> controlsHorizontalPositions = new HashMap<String, String>();
    protected boolean isToggle = false;
    protected final String SPACER_GIF = String.valueOf(this.getCssExtension()) + "/spacer.gif";
    protected final String DEFAULT_LABEL_VALUE = "\u00a0\u00a0\u00a0";
    protected String sourceCancelButtonIcon;
    protected String sourceApplyButtonIcon;

    public RichFacesAbstractInplaceTemplate() {
        this.initDefaultStyleClasses();
        this.initDefaultButtonImages();
        this.initPositions();
    }

    protected nsIDOMElement createRootSpanTemplateMethod(Element source, nsIDOMDocument visualDocument, Attributes attrs) {
        nsIDOMElement rootSpan = visualDocument.createElement("span");
        rootSpan.setAttribute("vpe-user-toggle-id", String.valueOf(this.isToggle));
        String rootStyleClass = "rich-inplace" + this.getCssStylesSuffix();
        String[] stringArray = this.getRootSpanClasses(attrs);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sc = stringArray[n2];
            if (ComponentUtil.isNotBlank(sc)) {
                rootStyleClass = String.valueOf(rootStyleClass) + " " + sc;
            }
            ++n2;
        }
        rootSpan.setAttribute("class", rootStyleClass);
        String style = "";
        if (this.isToggle) {
            style = "position: relative;";
        }
        rootSpan.setAttribute("style", String.valueOf(style) + "; display: " + attrs.getLayout() + ";");
        return rootSpan;
    }

    protected abstract String getCssExtension();

    protected abstract String getCssStyle();

    protected abstract String getCssStylesSuffix();

    protected abstract String[] getRootSpanClasses(Attributes var1);

    protected String getValue(Attributes attrs) {
        String rst = "";
        rst = ComponentUtil.isNotBlank(attrs.getDefaultLabel()) ? attrs.getDefaultLabel() : (ComponentUtil.isBlank(attrs.getDefaultLabel()) && ComponentUtil.isNotBlank(attrs.getValue()) ? attrs.getValue() : (this.isToggle ? " " : "\u00a0\u00a0\u00a0"));
        return rst;
    }

    protected void initDefaultButtonImages() {
        if (defaultButtonImages.isEmpty()) {
            defaultButtonImages.put("cancelControlIcon", String.valueOf(this.getCssExtension()) + CANCEL_BUTTON_GIF);
            defaultButtonImages.put("saveControlIcon", String.valueOf(this.getCssExtension()) + APPLY_BUTTON_GIF);
        }
    }

    protected void initDefaultStyleClasses() {
        if (defaultStyleClasses.isEmpty()) {
            defaultStyleClasses.put("rootSpan", "rich-inplace" + this.getCssStylesSuffix() + " {0} {1}");
        }
    }

    protected void initPositions() {
        if (this.controlsVerticalPositions.isEmpty()) {
            this.controlsVerticalPositions.put("bottom", "18px");
            this.controlsVerticalPositions.put("top", "-12px");
            this.controlsVerticalPositions.put("center", "0px");
        }
        if (this.controlsHorizontalPositions.isEmpty()) {
            this.controlsHorizontalPositions.put("left", "0px");
            this.controlsHorizontalPositions.put("center", "53px");
        }
    }

    protected void prepareData(VpePageContext pageContext, Element source) {
        this.prepareImages(source);
    }

    protected void prepareImages(Element source) {
        for (String key : defaultButtonImages.keySet()) {
            String value = ComponentUtil.getAttribute(source, key);
            if (ComponentUtil.isNotBlank(value)) {
                this.buttonImages.put(key, value);
                continue;
            }
            this.buttonImages.put(key, defaultButtonImages.get(key));
        }
    }

    protected void setUpImg(nsIDOMElement img, int width, int height, int border, String image) {
        ComponentUtil.setImg(img, image);
        img.setAttribute("width", String.valueOf(width));
        img.setAttribute("height", String.valueOf(height));
        img.setAttribute("border", String.valueOf(border));
    }

    protected void setUpSpanRoot(nsIDOMElement spanRoot, Element source, nsIDOMDocument visualDocument, Attributes attrs) {
        if (attrs.getStyleClass().length() > 0) {
            spanRoot.setAttribute("class", attrs.getStyleClass());
        } else {
            spanRoot.setAttribute("class", RICH_INPLACE_VIEW_DEFAULT_STYLE_CLASS);
        }
        String value = " ";
        if (attrs.getValue().length() > 0) {
            value = attrs.getValue();
        }
        nsIDOMText text = visualDocument.createTextNode(value);
        spanRoot.appendChild((nsIDOMNode)text);
    }

    public void stopToggling(Node sourceNode) {
        this.isToggle = false;
    }

    public void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        this.isToggle = !this.isToggle;
    }

    protected abstract String getCssStylesControlSuffix();

    protected abstract String getControlPositionsSubStyles(Attributes var1);

    protected abstract String getMainControlsDivCssClass();

    protected nsIDOMElement createControlsDiv(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData creationData, Attributes attrs) {
        nsIDOMElement element = visualDocument.createElement("div");
        element.setAttribute("class", this.getMainControlsDivCssClass());
        element.setAttribute("style", "position: absolute; " + this.getControlPositionsSubStyles(attrs));
        nsIDOMElement divShadov = visualDocument.createElement("div");
        divShadov.setAttribute("class", "rich-inplace" + this.getCssStylesSuffix() + "-shadow");
        nsIDOMElement divShadovTable = visualDocument.createElement("table");
        divShadovTable.setAttribute("cellpadding", "0");
        divShadovTable.setAttribute("cellspacing", "0");
        divShadovTable.setAttribute("border", "0");
        nsIDOMElement divShadovTBody = visualDocument.createElement("tbody");
        nsIDOMElement divShadovTr1 = visualDocument.createElement("tr");
        nsIDOMElement divShadovTr2 = visualDocument.createElement("tr");
        nsIDOMElement divShadovTd1 = visualDocument.createElement("td");
        nsIDOMElement divShadovTd2 = visualDocument.createElement("td");
        nsIDOMElement divShadovTd1Tr2 = visualDocument.createElement("td");
        nsIDOMElement divShadovTd2Tr2 = visualDocument.createElement("td");
        nsIDOMElement td1Img = visualDocument.createElement("img");
        nsIDOMElement td2Img = visualDocument.createElement("img");
        nsIDOMElement td3Img = visualDocument.createElement("img");
        nsIDOMElement td4Img = visualDocument.createElement("img");
        this.setUpImg(td1Img, 10, 1, 0, this.SPACER_GIF);
        this.setUpImg(td2Img, 1, 10, 0, this.SPACER_GIF);
        this.setUpImg(td3Img, 1, 10, 0, this.SPACER_GIF);
        this.setUpImg(td4Img, 10, 1, 0, this.SPACER_GIF);
        divShadovTd1.setAttribute("class", "rich-inplace" + this.getCssStylesSuffix() + "-shadow-tl");
        divShadovTd2.setAttribute("class", "rich-inplace" + this.getCssStylesSuffix() + "-shadow-tr");
        divShadovTd1Tr2.setAttribute("class", "rich-inplace" + this.getCssStylesSuffix() + "-shadow-bl");
        divShadovTd2Tr2.setAttribute("class", "rich-inplace" + this.getCssStylesSuffix() + "-shadow-br");
        nsIDOMElement divButtons = visualDocument.createElement("div");
        divButtons.setAttribute("style", "position: relative; height: 18px;");
        Element controlFacet = ComponentUtil.getFacetElement((Element)sourceNode, "controls", false);
        if (controlFacet != null) {
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(divButtons);
            childrenInfo.addSourceChild((Node)controlFacet);
            creationData.addChildrenInfo(childrenInfo);
        } else {
            nsIDOMElement applyButtonImg = visualDocument.createElement("input");
            applyButtonImg.setAttribute("type", "image");
            String applyButtonClass = "rich-inplace" + this.getCssStylesSuffix() + "-control";
            if (ComponentUtil.isNotBlank(attrs.getControlClass())) {
                applyButtonClass = String.valueOf(applyButtonClass) + attrs.getControlClass();
            }
            applyButtonImg.setAttribute("class", applyButtonClass);
            String saveControlIconImg = this.buttonImages.get("saveControlIcon");
            if (defaultButtonImages.containsValue(saveControlIconImg)) {
                ComponentUtil.setImg(applyButtonImg, saveControlIconImg);
            } else {
                String imgFullPath = VpeStyleUtil.addFullPathToImgSrc((String)saveControlIconImg, (VpePageContext)pageContext, (boolean)true);
                applyButtonImg.setAttribute("src", imgFullPath);
            }
            applyButtonImg.setAttribute("vpe-user-toggle-id", String.valueOf(0));
            nsIDOMElement cancelButtonImg = visualDocument.createElement("input");
            cancelButtonImg.setAttribute("type", "image");
            String cancelButtonClass = "rich-inplace" + this.getCssStylesSuffix() + "-control";
            if (ComponentUtil.isNotBlank(attrs.getControlClass())) {
                cancelButtonClass = String.valueOf(cancelButtonClass) + attrs.getControlClass();
            }
            cancelButtonImg.setAttribute("class", cancelButtonClass);
            String cancelControlIconImg = this.buttonImages.get("cancelControlIcon");
            if (defaultButtonImages.containsValue(cancelControlIconImg)) {
                ComponentUtil.setImg(cancelButtonImg, cancelControlIconImg);
            } else {
                String imgFullPath = VpeStyleUtil.addFullPathToImgSrc((String)cancelControlIconImg, (VpePageContext)pageContext, (boolean)true);
                cancelButtonImg.setAttribute("src", imgFullPath);
            }
            cancelButtonImg.setAttribute("vpe-user-toggle-id", String.valueOf(0));
            divButtons.appendChild((nsIDOMNode)applyButtonImg);
            divButtons.appendChild((nsIDOMNode)cancelButtonImg);
            element.appendChild((nsIDOMNode)divShadov);
            divShadov.appendChild((nsIDOMNode)divShadovTable);
            divShadovTable.appendChild((nsIDOMNode)divShadovTBody);
            divShadovTBody.appendChild((nsIDOMNode)divShadovTr1);
            divShadovTr1.appendChild((nsIDOMNode)divShadovTd1);
            divShadovTd1.appendChild((nsIDOMNode)td1Img);
            divShadovTr1.appendChild((nsIDOMNode)divShadovTd2);
            divShadovTd2.appendChild((nsIDOMNode)td2Img);
            divShadovTBody.appendChild((nsIDOMNode)divShadovTr2);
            divShadovTr2.appendChild((nsIDOMNode)divShadovTd1Tr2);
            divShadovTd1Tr2.appendChild((nsIDOMNode)td3Img);
            divShadovTr2.appendChild((nsIDOMNode)divShadovTd2Tr2);
            divShadovTd2Tr2.appendChild((nsIDOMNode)td4Img);
        }
        element.appendChild((nsIDOMNode)divButtons);
        return element;
    }

    class Attributes {
        private final String EDIT_CLASS = "editClass";
        private final String VIEW_CLASS = "viewClass";
        private final String CONTROL_CLASS = "controlClass";
        private final String SHOW_CONTROLS = "showControls";
        private final String LAYOUT = "layout";
        private final String CONTROLS_HORIZONTAL_POSOSITION = "controlsHorizontalPosition";
        private final String CONTROLS_VERTICAL_POSITION = "controlsVerticalPosition";
        private final String DEFAULT_LABEL = "defaultLabel";
        private final String DEFAULT_VALUE = " ";
        private String editClass;
        private String viewClass;
        private String controlClass;
        private boolean showControls;
        private String layout;
        private String value;
        private String controlsHorizontalPosition;
        private String controlsVerticalPosition;
        private String defaultLabel;
        private String styleClass;

        public Attributes(Element sourceElement) {
            if (sourceElement == null) {
                return;
            }
            this.editClass = sourceElement.getAttribute("editClass");
            this.viewClass = sourceElement.getAttribute("viewClass");
            this.controlClass = sourceElement.getAttribute("controlClass");
            this.showControls = Boolean.parseBoolean(sourceElement.getAttribute("showControls"));
            this.layout = sourceElement.getAttribute("layout");
            this.value = sourceElement.getAttribute("value");
            this.controlsHorizontalPosition = sourceElement.getAttribute("controlsHorizontalPosition");
            this.controlsVerticalPosition = sourceElement.getAttribute("controlsVerticalPosition");
            this.defaultLabel = sourceElement.getAttribute("defaultLabel");
            this.styleClass = sourceElement.getAttribute("styleClass");
            if (ComponentUtil.isBlank(this.value)) {
                this.value = " ";
            }
            if (ComponentUtil.isBlank(this.layout) || !this.layout.equalsIgnoreCase("inline") && !this.layout.equalsIgnoreCase("block")) {
                this.layout = "inline";
            }
            if (ComponentUtil.isBlank(this.controlsVerticalPosition) || !this.isInKeySet(RichFacesAbstractInplaceTemplate.this.controlsVerticalPositions, this.controlsVerticalPosition)) {
                this.controlsVerticalPosition = "center";
            }
            if (ComponentUtil.isBlank(this.controlsHorizontalPosition) || !this.isInKeySet(RichFacesAbstractInplaceTemplate.this.controlsHorizontalPositions, this.controlsHorizontalPosition)) {
                this.controlsHorizontalPosition = "right";
            }
        }

        protected boolean isInKeySet(Map<String, String> map, String value) {
            boolean rst = false;
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(value)) continue;
                rst = true;
                break;
            }
            return rst;
        }

        public String getEditClass() {
            return this.editClass;
        }

        public String getViewClass() {
            return this.viewClass;
        }

        public String getLayout() {
            return this.layout;
        }

        public String getControlClass() {
            return this.controlClass;
        }

        public boolean isShowControls() {
            return this.showControls;
        }

        public String getValue() {
            return this.value;
        }

        public String getControlsHorizontalPosition() {
            return this.controlsHorizontalPosition;
        }

        public String getControlsVerticalPosition() {
            return this.controlsVerticalPosition;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public String getStyleClass() {
            return this.styleClass;
        }
    }
}

