/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.runtime.CustomRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ProjectRuntimeClasspathCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeClasspathCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.DeploymentStructureChangeListener;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.ManifestChangeListener;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.PathProviderResolutionUtil;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.DeploymentStructureEntryContainerInitializer;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.DeploymentStructureUtil;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.ModuleSlotManifestUtil;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.ModulesManifestEntryContainerInitializer;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.LayeredProductPathProvider;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;

public class ProjectRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate {
    static final IPath CONTAINER_PATH;

    static {
        ManifestChangeListener.register();
        DeploymentStructureChangeListener.register();
        CONTAINER_PATH = new Path("org.eclipse.jst.server.core.container").append("org.jboss.ide.eclipse.as.core.server.runtime.runtimeTarget");
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        if (!this.isJBossModulesStyle(runtime)) {
            return this.legacyClientAllImplementation(project, runtime);
        }
        return this.jbossModulesImplementation(project, runtime);
    }

    private IClasspathEntry[] legacyClientAllImplementation(IProject project, IRuntime runtime) {
        ArrayList<IClasspathEntry> all = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] standardList = this.resolveClasspathContainerFromRuntime(runtime);
        all.addAll(Arrays.asList(standardList));
        return all.toArray(new IClasspathEntry[all.size()]);
    }

    private IClasspathEntry[] jbossModulesImplementation(IProject project, IRuntime runtime) {
        boolean manifestsChanged = new ModuleSlotManifestUtil().isCacheOutdated(project);
        boolean deploymentStructureChanged = new DeploymentStructureUtil().isCacheOutdated(project);
        boolean defaultsPerRuntimeChanged = RuntimeClasspathCache.getInstance().getEntries(runtime) == null;
        IClasspathEntry[] entries = ProjectRuntimeClasspathCache.getInstance().getEntries(project, runtime);
        if (manifestsChanged || defaultsPerRuntimeChanged || deploymentStructureChanged || entries == null) {
            ModulesManifestEntryContainerInitializer.ModulesManifestEntryContainer cpc = new ModulesManifestEntryContainerInitializer.ModulesManifestEntryContainer(runtime, project);
            IRuntimePathProvider[] fromManifest = cpc.getRuntimePathProviders();
            DeploymentStructureEntryContainerInitializer.DeploymentStructureEntryContainer depStructureContainer = new DeploymentStructureEntryContainerInitializer.DeploymentStructureEntryContainer(runtime, project);
            IRuntimePathProvider[] fromStructure = depStructureContainer.getRuntimePathProviders();
            IRuntimePathProvider[] fromRuntimeDefaults = CustomRuntimeClasspathModel.getInstance().getEntries(runtime.getRuntimeType());
            IRuntimePathProvider[] merged = this.jbossModulesMerge(this.jbossModulesMerge(fromManifest, fromRuntimeDefaults), fromStructure);
            IPath[] allPaths = PathProviderResolutionUtil.getAllPaths(runtime, merged);
            IClasspathEntry[] runtimeClasspath = PathProviderResolutionUtil.getClasspathEntriesForResolvedPaths(allPaths);
            IPath[] fromRuntimeDefaultsPaths = PathProviderResolutionUtil.getAllPaths(runtime, fromRuntimeDefaults);
            IClasspathEntry[] fromRuntimeDefaultsEntries = PathProviderResolutionUtil.getClasspathEntriesForResolvedPaths(fromRuntimeDefaultsPaths);
            RuntimeClasspathCache.getInstance().cacheEntries(runtime, fromRuntimeDefaultsEntries);
            ProjectRuntimeClasspathCache.getInstance().cacheEntries(project, runtime, runtimeClasspath);
            return runtimeClasspath;
        }
        return entries;
    }

    private IRuntimePathProvider[] jbossModulesMerge(IRuntimePathProvider[] manifest, IRuntimePathProvider[] other) {
        ArrayList<IRuntimePathProvider> result = new ArrayList<IRuntimePathProvider>();
        result.addAll(Arrays.asList(manifest));
        int i = 0;
        while (i < other.length) {
            if (other[i] instanceof LayeredProductPathProvider) {
                if (!this.jbossModuleConflicts((LayeredProductPathProvider)other[i], result)) {
                    result.add(other[i]);
                }
            } else {
                result.add(other[i]);
            }
            ++i;
        }
        return result.toArray(new IRuntimePathProvider[result.size()]);
    }

    private boolean jbossModuleConflicts(LayeredProductPathProvider requested, List<IRuntimePathProvider> existing) {
        String proposedModule = requested.getModule();
        int i = 0;
        while (i < existing.size()) {
            String mod;
            if (existing.get(i) instanceof LayeredProductPathProvider && proposedModule.equals(mod = ((LayeredProductPathProvider)existing.get(i)).getModule())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isJBossModulesStyle(IRuntime rt) {
        ServerExtendedProperties props = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties((Object)rt);
        return props.getFileStructure() == 2;
    }

    public IClasspathEntry[] resolveClasspathContainerFromRuntime(IRuntime runtime) {
        if (runtime == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] runtimeClasspath = RuntimeClasspathCache.getInstance().getEntries(runtime);
        if (runtimeClasspath != null) {
            return runtimeClasspath;
        }
        IRuntimePathProvider[] sets = CustomRuntimeClasspathModel.getInstance().getEntries(runtime.getRuntimeType());
        IPath[] allPaths = PathProviderResolutionUtil.getAllPaths(runtime, sets);
        runtimeClasspath = PathProviderResolutionUtil.getClasspathEntriesForResolvedPaths(allPaths);
        RuntimeClasspathCache.getInstance().cacheEntries(runtime, runtimeClasspath);
        return runtimeClasspath;
    }
}

