/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public abstract class AbstractTextButtonControl
extends ControlBuilder<Control> {
    @Override
    public Control build(final ForgeWizardPage page, final InputComponent<?, ?> input, final String inputName, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getMnemonicLabel(input, true));
        final Text containerText = new Text(parent, 2052);
        GridData gd = new GridData(768);
        containerText.setLayoutData((Object)gd);
        ConverterFactory converterFactory = FurnaceService.INSTANCE.getConverterFactory();
        if (converterFactory != null) {
            Converter converter = converterFactory.getConverter(input.getValueType(), String.class);
            String value = (String)converter.convert(InputComponents.getValueFor(input));
            containerText.setText(value == null ? "" : value);
        }
        containerText.setToolTipText(input.getDescription());
        containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = containerText.getText();
                if (text != null) {
                    CommandController controller = page.getController();
                    controller.setValueFor(inputName, (Object)text);
                }
            }
        });
        this.decorateContainerText(page, input, containerText);
        Button button = new Button(parent, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTextButtonControl.this.browseButtonPressed(page, input, containerText);
            }
        });
        this.setupAutoCompleteForText(page.getWizard().getUIContext(), input, InputComponents.getCompleterFor(input), containerText);
        return containerText;
    }

    @Override
    public void setEnabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        Composite parent = control.getParent();
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == control) {
                children[i + 1].setEnabled(enabled);
                break;
            }
            ++i;
        }
    }

    protected void decorateContainerText(ForgeWizardPage page, InputComponent<?, ?> input, Text containerText) {
    }

    protected abstract void browseButtonPressed(ForgeWizardPage var1, InputComponent<?, ?> var2, Text var3);
}

