/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.server.VpvSocketProcessor;
import org.jboss.tools.vpe.preview.core.transform.VpvController;

public class VpvServer
implements Runnable {
    private ServerSocket serverSocket;
    private VpvController vpvController;
    boolean socketIsAboutToBeClosed = false;

    public VpvServer(VpvController vpvController) {
        this.vpvController = vpvController;
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(0, 0, InetAddress.getByName("localhost"));
            while (true) {
                Socket clientSocket = this.serverSocket.accept();
                VpvSocketProcessor serverProcessor = new VpvSocketProcessor(clientSocket, this.vpvController);
                new Thread(serverProcessor).start();
            }
        }
        catch (SocketException e) {
            if (!this.socketIsAboutToBeClosed) {
                Activator.logError(e);
            }
        }
        catch (IOException e) {
            Activator.logError(e);
        }
    }

    public void stop() {
        try {
            this.socketIsAboutToBeClosed = true;
            this.serverSocket.close();
        }
        catch (IOException e) {
            Activator.logError(e);
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }
}

