/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.internal.util.TarException;

public class EngineDownloadReceiver
implements IFileTransferListener {
    private File folder;
    private File tempFile;
    private IProgressMonitor monitor;
    private int percentComplete;
    private Object lock;

    public EngineDownloadReceiver(String version, String platformId, Object lock, IProgressMonitor pm) {
        this.folder = new File(CordovaEngineProvider.getLibFolder().toFile(), String.valueOf(platformId) + "/" + "cordova" + "/" + version);
        this.tempFile = new File(this.folder, String.valueOf(platformId) + "_" + version + "_" + "engine.tgz");
        this.monitor = pm;
        this.lock = lock;
    }

    public void handleTransferEvent(IFileTransferEvent event) {
        if (event instanceof IIncomingFileTransferReceiveStartEvent) {
            IIncomingFileTransferReceiveStartEvent startEvent = (IIncomingFileTransferReceiveStartEvent)event;
            this.handleStart(startEvent);
        } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
            IIncomingFileTransferReceiveDataEvent dataEvent = (IIncomingFileTransferReceiveDataEvent)event;
            this.handleDataReceived(dataEvent);
        } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
            IIncomingFileTransferReceiveDoneEvent doneEvent = (IIncomingFileTransferReceiveDoneEvent)event;
            this.handleDone(doneEvent);
        }
    }

    private void handleDataReceived(IIncomingFileTransferReceiveDataEvent dataEvent) {
        IIncomingFileTransfer source = dataEvent.getSource();
        if (this.monitor.isCanceled()) {
            source.cancel();
            return;
        }
        int completed = (int)(source.getPercentComplete() * 100.0);
        if (completed > 0) {
            int worked = this.percentComplete - completed;
            if (worked > 0) {
                this.monitor.worked(worked);
            }
            this.percentComplete = completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDone(IIncomingFileTransferReceiveDoneEvent doneEvent) {
        block24: {
            if (doneEvent.getException() == null) break block24;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.monitor.done();
            return;
        }
        try {
            org.eclipse.thym.core.internal.util.FileUtils.untarFile(this.tempFile, this.folder);
            File[] files = this.folder.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtils.copyDirectory((File)files[i], (File)this.folder);
                    FileUtils.deleteQuietly((File)files[i]);
                    break;
                }
                ++i;
            }
            FileUtils.deleteQuietly((File)this.tempFile);
        }
        catch (IOException e) {
            HybridCore.log(4, "Error while saving downlaoded engine", e);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.monitor.done();
        }
        catch (TarException e) {
            Object object;
            try {
                HybridCore.log(4, "Error while extracting downlaoded engine ", e);
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.lock.notifyAll();
                }
                this.monitor.done();
                throw throwable;
            }
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.monitor.done();
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.monitor.done();
    }

    private void handleStart(IIncomingFileTransferReceiveStartEvent startEvent) {
        this.monitor.beginTask("Downloading platform", 100);
        if (this.folder.isDirectory()) {
            FileUtils.deleteQuietly((File)this.folder);
        }
        try {
            if (this.monitor.isCanceled()) {
                return;
            }
            this.folder.mkdirs();
            startEvent.receive(this.tempFile);
        }
        catch (IOException e) {
            HybridCore.log(4, "Error starting engine download", e);
        }
    }
}

