/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.IToken;
import org.jboss.tools.common.text.ext.util.TextScanner;
import org.jboss.tools.common.text.ext.util.Utils;

class XHTMLDetector
extends TextScanner {
    private static final String DOCTYPE_DECLARATION = "DOCTYPE";
    private static final String[] VALID_DOCTYPE_DTD_DECLARATION_REQUIRED_TOKENS = new String[]{"W3C", "DTD", "XHTML"};
    private static final String[] VALID_DOCTYPE_DTD_DECLARATION_ONE_OF_TOKENS = new String[]{"Strict", "Transitional", "Frameset"};
    private static final String VALID_ELEMENT_XMLNS_ATTRIBUTE = "xmlns";
    private static final String VALID_ELEMENT_XMLNS_ATTRIBUTE_VALUE = "http://www.w3.org/1999/xhtml";
    private static final String TEXT_TOKEN = "___TEXT_TOKEN";
    private static final String COMMENT_TOKEN = "___COMMENT_TOKEN";
    private static final String XML_DECL_TOKEN = "___XML_DECL_TOKEN";
    private static final String DECL_TOKEN = "___DECL_TOKEN";
    private static final String ELEMENT_TOKEN = "___ELEMENT_TOKEN";
    private static final String PUBLIC = "PUBLIC";
    private static final String SYSTEM = "SYSTEM";
    private static final int STATE_START = 0;
    private static final int STATE_ELEMENT = 1;
    private static final int STATE_XML_DECL = 2;
    private static final int STATE_DECL = 3;
    private static final int STATE_COMMENT = 4;
    private static final int STATE_END = 5;
    private int state;
    private String declName;
    private String rootName;
    private String idKind;
    private String publicId;
    private String systemId;
    private String elementName;
    private Map<String, String> elementAttributes = new HashMap<String, String>();

    public XHTMLDetector(Reader reader) {
        super(reader);
    }

    public boolean detect() {
        this.state = 0;
        this.clearText();
        boolean docTypeFound = false;
        String docTypeRootName = null;
        String docTypeIdKind = null;
        String docTypePublicId = null;
        IToken t = this.nextToken();
        while (t != null && !t.isEOF()) {
            if (t instanceof TextScanner.TextToken) {
                TextScanner.TextToken token = (TextScanner.TextToken)t;
                if (!docTypeFound && DECL_TOKEN.equals(token.getType()) && this.declName != null && this.declName.equals(DOCTYPE_DECLARATION)) {
                    docTypeFound = true;
                    docTypeRootName = this.rootName;
                    docTypeIdKind = this.idKind;
                    docTypePublicId = this.publicId;
                    if (!PUBLIC.equals(docTypeIdKind)) {
                        return false;
                    }
                    if (!this.hasAllTokens(docTypePublicId, VALID_DOCTYPE_DTD_DECLARATION_REQUIRED_TOKENS)) {
                        return false;
                    }
                    return this.hasOneOfTokens(docTypePublicId, VALID_DOCTYPE_DTD_DECLARATION_ONE_OF_TOKENS);
                }
                if (ELEMENT_TOKEN.equals(token.getType())) {
                    if (docTypeFound) {
                        if (this.elementName == null) {
                            return false;
                        }
                        String name = this.elementName.substring(this.elementName.indexOf(58) + 1);
                        if (!name.equals(docTypeRootName)) {
                            return false;
                        }
                        if (!this.elementAttributes.containsKey(VALID_ELEMENT_XMLNS_ATTRIBUTE)) {
                            return false;
                        }
                        String value = this.elementAttributes.get(VALID_ELEMENT_XMLNS_ATTRIBUTE);
                        if (value == null) {
                            return false;
                        }
                        return VALID_ELEMENT_XMLNS_ATTRIBUTE_VALUE.equals(Utils.trimQuotes((String)value).toLowerCase());
                    }
                    return false;
                }
            }
            t = this.nextToken();
        }
        return false;
    }

    private boolean hasAllTokens(String publicId, String[] reqiured) {
        if (publicId == null) {
            return false;
        }
        String[] stringArray = reqiured;
        int n = reqiured.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            int idx = publicId.indexOf(r);
            if (idx == -1) {
                return false;
            }
            if (publicId.length() < idx + r.length() + 1) {
                return false;
            }
            if (Character.isJavaIdentifierPart(publicId.charAt(idx + r.length()))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasOneOfTokens(String publicId, String[] oneOf) {
        if (publicId == null) {
            return false;
        }
        boolean found = false;
        String[] stringArray = oneOf;
        int n = oneOf.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            int idx = publicId.indexOf(r);
            if (!(idx == -1 || publicId.length() >= idx + r.length() + 1 && Character.isJavaIdentifierPart(publicId.charAt(idx + r.length())))) {
                if (found) {
                    return false;
                }
                found = true;
            }
            ++n2;
        }
        return found;
    }

    public IToken nextToken() {
        this.offset += this.length;
        switch (this.state) {
            case 1: {
                return this.nextElementToken();
            }
            case 3: {
                return this.nextDeclToken();
            }
            case 2: {
                return this.nextXmlDeclToken();
            }
            case 4: {
                return this.nextCommentToken();
            }
        }
        return this.nextTextToken();
    }

    private IToken nextTextToken() {
        int count = this.skipWhitespaceToken();
        int ch = this.read();
        while (ch != -1) {
            if (ch == 60) {
                this.state = 1;
                ch = this.read();
                if (ch == 33) {
                    this.state = 3;
                    ch = this.read();
                    if (ch == 45) {
                        ch = this.read();
                        if (ch == 45) {
                            this.state = 4;
                            this.unread();
                            this.unread();
                            this.unread();
                            this.unread();
                            return count > 0 ? this.getToken(TEXT_TOKEN) : this.nextCommentToken();
                        }
                        if (ch != -1) {
                            this.unread();
                        }
                        this.unread();
                    }
                    if (ch != -1) {
                        this.unread();
                    }
                    this.unread();
                    this.unread();
                    return count > 0 ? this.getToken(TEXT_TOKEN) : this.nextDeclToken();
                }
                if (ch == 63) {
                    this.state = 2;
                    this.unread();
                    this.unread();
                    return count > 0 ? this.getToken(TEXT_TOKEN) : this.nextXmlDeclToken();
                }
                if (ch != -1) {
                    this.unread();
                }
                this.unread();
                return count > 0 ? this.getToken(TEXT_TOKEN) : this.nextElementToken();
            }
            ++count;
            ch = this.read();
        }
        this.state = 5;
        return this.getToken(TEXT_TOKEN);
    }

    private IToken nextCommentToken() {
        int count = this.skip(3);
        if (count < 3) {
            this.state = 5;
            return this.getToken(COMMENT_TOKEN);
        }
        int ch = this.read();
        while (ch != -1) {
            if (ch == 45) {
                ch = this.read();
                if (ch == -1) break;
                if (ch == 45) {
                    ch = this.read();
                    if (ch == -1) break;
                    if (ch == 62) {
                        this.state = 0;
                        return this.getToken(COMMENT_TOKEN);
                    }
                }
            }
            ++count;
            ch = this.read();
        }
        this.state = 5;
        return this.getToken(COMMENT_TOKEN);
    }

    private IToken nextXmlDeclToken() {
        int count = this.skip(2);
        if (count < 2) {
            this.state = 5;
            return this.getToken(XML_DECL_TOKEN);
        }
        int ch = this.read();
        while (ch != -1) {
            if (ch == 34 || ch == 39) {
                count += this.skipLiteralToken(ch);
                ch = this.read();
                continue;
            }
            if (ch == 63) {
                ch = this.read();
                if (ch == -1) break;
                if (ch == 62) {
                    this.state = 0;
                    return this.getToken(XML_DECL_TOKEN);
                }
            }
            ++count;
            ch = this.read();
        }
        this.state = 5;
        return this.getToken(XML_DECL_TOKEN);
    }

    private IToken nextDeclToken() {
        int count = this.skip(2);
        if (count < 2) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        this.declName = this.readName();
        if (this.declName == null || this.declName.length() == 0) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        count += this.declName.length();
        int wsCount = this.skipWhitespaceToken();
        if (wsCount == 0) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        count += wsCount;
        this.rootName = this.readName();
        if (this.declName == null || this.declName.length() == 0) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        count += this.declName.length();
        wsCount = this.skipWhitespaceToken();
        if (wsCount == 0) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        count += wsCount;
        this.idKind = this.readName();
        if (this.declName == null || this.declName.length() == 0) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        count += this.declName.length();
        wsCount = this.skipWhitespaceToken();
        if (wsCount == 0) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        count += wsCount;
        if (!PUBLIC.equals(this.idKind) && !SYSTEM.equals(this.idKind)) {
            this.state = 5;
            return this.getToken(DECL_TOKEN);
        }
        if (PUBLIC.equals(this.idKind)) {
            this.publicId = this.readLiteralValue();
            count += this.publicId.length();
            wsCount = this.skipWhitespaceToken();
            if (wsCount == 0) {
                this.state = 5;
                return this.getToken(DECL_TOKEN);
            }
            count += wsCount;
        }
        this.systemId = this.readLiteralValue();
        count += this.systemId.length();
        count += this.skipWhitespaceToken();
        count += wsCount;
        int ch = this.read();
        this.state = ch == 62 ? 0 : 5;
        return this.getToken(DECL_TOKEN);
    }

    private IToken nextElementToken() {
        int count = this.skip(1);
        if (count < 1) {
            this.state = 5;
            return this.getToken(ELEMENT_TOKEN);
        }
        int ch = this.read();
        if (ch == -1) {
            this.state = 5;
            return this.getToken(ELEMENT_TOKEN);
        }
        boolean closingTag = true;
        if (ch != 47) {
            this.unread();
            closingTag = false;
        } else {
            ++count;
        }
        this.elementName = this.readName();
        this.elementAttributes.clear();
        if (this.elementName == null || this.elementName.length() == 0) {
            this.state = 5;
            return this.getToken(ELEMENT_TOKEN);
        }
        count += this.elementName.length();
        ch = this.read();
        while (ch != -1) {
            if (ch == -1) {
                this.state = 5;
                return this.getToken(ELEMENT_TOKEN);
            }
            this.unread();
            int wsCount = this.skipWhitespaceToken();
            count += wsCount;
            ch = this.read();
            if (!closingTag && ch == 47) {
                ch = this.read();
                this.state = ch == 62 ? 0 : 5;
                return this.getToken(ELEMENT_TOKEN);
            }
            if (ch == 62) {
                this.state = 0;
                return this.getToken(ELEMENT_TOKEN);
            }
            if (wsCount == 0) {
                this.state = 5;
                return this.getToken(ELEMENT_TOKEN);
            }
            this.unread();
            count += wsCount;
            if (!closingTag) {
                String attrName = this.readName();
                if (attrName == null || attrName.length() == 0) {
                    this.state = 5;
                    return this.getToken(DECL_TOKEN);
                }
                count += attrName.length();
                count += this.skipWhitespaceToken();
                ch = this.read();
                if (ch != 61) {
                    this.state = 5;
                    return this.getToken(ELEMENT_TOKEN);
                }
                ++count;
                count += this.skipWhitespaceToken();
                String attrValue = this.readLiteralValue();
                count += attrValue.length();
                this.elementAttributes.put(attrName, attrValue);
            }
            ch = this.read();
        }
        this.state = 5;
        return this.getToken(ELEMENT_TOKEN);
    }

    int skip(int count) {
        int skipped = 0;
        while (skipped < count && this.read() != -1) {
            ++skipped;
        }
        return skipped;
    }

    public int skipLiteralToken(int quote) {
        int count = 0;
        int ch = this.read();
        while (ch != -1 && ch != quote) {
            ++count;
            ch = this.read();
        }
        return count;
    }

    String readLiteralValue() {
        StringBuffer sb = new StringBuffer();
        int quote = this.read();
        if (quote != 34 && quote != 39) {
            this.unread();
            return sb.toString();
        }
        sb.append((char)quote);
        int ch = this.read();
        while (ch != -1 && ch != quote) {
            sb.append((char)ch);
            ch = this.read();
        }
        if (ch != -1) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    String readName() {
        StringBuffer sb = new StringBuffer();
        int ch = this.read();
        if (ch == -1) {
            return null;
        }
        if (!NMTOKEN_DETECTOR.isWordStart((char)ch)) {
            return null;
        }
        sb.append((char)ch);
        ch = this.read();
        while (ch != -1) {
            if (!NMTOKEN_DETECTOR.isWordPart((char)ch)) {
                this.unread();
                break;
            }
            sb.append((char)ch);
            ch = this.read();
        }
        return sb.toString();
    }
}

