/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jsf.web.JSFWebHelper;
import org.jboss.tools.jsf.web.validation.JSFSeverityPreferences;
import org.jboss.tools.jsf.web.validation.JSFValidationMessage;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.validation.Check;

class CheckContextParam
extends Check {
    static String CONFIG_FILES_PARAM = JSFWebHelper.FACES_CONFIG_DATA.param;

    public CheckContextParam(ValidationErrorManager manager) {
        super(manager, JSFSeverityPreferences.INVALID_CONFIG_FILES, "param-value");
    }

    public void check(XModelObject webapp) {
        XModelObject[] fss;
        XModelObject object = WebAppHelper.findWebAppContextParam((XModelObject)webapp, (String)CONFIG_FILES_PARAM);
        if (object == null) {
            return;
        }
        String value = object.getAttributeValue("param-value");
        if (value == null || value.length() == 0) {
            return;
        }
        XModel model = object.getModel();
        ArrayList<XModelObject> webRoots = new ArrayList<XModelObject>();
        XModelObject[] xModelObjectArray = fss = FileSystemsHelper.getFileSystems((XModel)model).getChildren();
        int n = fss.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject s = xModelObjectArray[n2];
            String n3 = s.getAttributeValue("name");
            if ("WEB-ROOT".equals(n3) || n3.startsWith("WEB-ROOT-")) {
                webRoots.add(s);
            }
            ++n2;
        }
        if (webRoots.isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken().trim();
            if (path.length() == 0) continue;
            XModelObject fc = XModelImpl.getByRelativePath((XModel)model, (String)path);
            if (fc == null) {
                this.fireMessage(object, JSFValidationMessage.INVALID_FACES_CONFIG_REFERENCE, new String[]{"param-value", path});
                return;
            }
            String path2 = path.startsWith("/") ? path.substring(1) : path;
            XModelObject fc2 = null;
            for (XModelObject s : webRoots) {
                fc2 = s.getChildByPath(path2);
                if (fc2 != null) break;
            }
            if (fc2 == null) {
                this.fireMessage(object, JSFValidationMessage.INVALID_FACES_CONFIG_REFERENCE, new String[]{"param-value", path});
                return;
            }
            if (fc2.getModelEntity().getName().startsWith("FacesConfig")) continue;
            this.fireMessage(object, JSFValidationMessage.INVALID_FACES_CONFIG_REFERENCE, new String[]{"param-value", path});
            return;
        }
    }
}

