/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelObjectConstants;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.project.IAutoLoad;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.WebUtils;

public class JSFAutoLoad
implements IAutoLoad,
XModelObjectConstants {
    static String WEB_INF = "WEB-INF";
    static String WEB_ROOT = "WEB-ROOT";

    public void load(XModel model) {
        XModelObject fs = FileSystemsHelper.getFileSystems((XModel)model);
        IProject project = EclipseResourceUtil.getProject((XModelObject)fs);
        if (project == null) {
            return;
        }
        fs.setAttributeValue("application name", project.getName());
        XModelObject s = this.createFileSystemFolder(model, project.getName(), project.getLocation().toString());
        fs.addChild(s);
        XModelObject webinf = this.createFileSystemFolder(model, WEB_INF, XModelConstants.WORKSPACE_REF);
        fs.addChild(webinf);
        String webInfLocation = XModelObjectUtil.expand((String)XModelConstants.WORKSPACE_REF, (XModel)model, null);
        List<String> webRootLocations = JSFAutoLoad.getWebRootPaths(project, webInfLocation);
        int i = 0;
        for (String webRootLocation : webRootLocations) {
            String name = WEB_ROOT;
            if (i > 0) {
                name = String.valueOf(name) + "-" + i;
            }
            XModelObject webroot = this.createFileSystemFolder(model, name, webRootLocation);
            fs.addChild(webroot);
            ++i;
        }
        XModelObject lib = this.createFileSystemFolder(model, "lib", String.valueOf(XModelConstants.WORKSPACE_REF) + "/lib");
        fs.addChild(lib);
    }

    XModelObject createFileSystemFolder(XModel model, String name, String location) {
        XModelObject f = model.createModelObject("FileSystemFolder", null);
        f.setAttributeValue("name", name);
        f.setAttributeValue("location", location);
        return f;
    }

    public void update(XModel model) {
        List<XModelObject> existingRoots;
        boolean rootsChanged;
        XModelObject fs = FileSystemsHelper.getFileSystems((XModel)model);
        IProject project = EclipseResourceUtil.getProject((XModelObject)fs);
        if (project == null) {
            return;
        }
        String webInfLocation = XModelObjectUtil.expand((String)XModelConstants.WORKSPACE_REF, (XModel)model, null);
        List<String> webRootLocations = JSFAutoLoad.getWebRootPaths(project, webInfLocation);
        boolean modified = false;
        XModelObject webinf = fs.getChildByPath(WEB_INF);
        String rWebInfLocation = JSFAutoLoad.getWebInfPath(project, webInfLocation);
        if (rWebInfLocation != null) {
            if (webinf != null && !rWebInfLocation.equals(webinf.getAttributeValue("location"))) {
                webinf.removeFromParent();
                webinf = null;
                modified = true;
            }
            if (webinf == null) {
                webinf = this.createFileSystemFolder(model, WEB_INF, rWebInfLocation);
                fs.addChild(webinf);
                modified = true;
            }
        } else if (webinf != null) {
            webinf.removeFromParent();
            modified = true;
        }
        if (rootsChanged = this.rootsChanged(webRootLocations, existingRoots = this.getExistingWebRoots(fs))) {
            modified = true;
            for (XModelObject c : existingRoots) {
                c.removeFromParent();
            }
            int i = 0;
            for (String webRootLocation : webRootLocations) {
                String name = WEB_ROOT;
                if (i > 0) {
                    name = String.valueOf(name) + "-" + i;
                }
                XModelObject webroot = this.createFileSystemFolder(model, name, webRootLocation);
                fs.addChild(webroot);
                ++i;
            }
        }
        if (modified) {
            ((XModelImpl)fs.getModel()).fireStructureChanged(fs);
            JSFProjectsRoot n = JSFProjectsTree.getProjectsRoot(model);
            if (n != null) {
                n.invalidate();
            }
        }
    }

    boolean rootsChanged(List<String> webRootLocations, List<XModelObject> rs) {
        if (webRootLocations.size() != rs.size()) {
            return true;
        }
        int i = 0;
        while (i < webRootLocations.size()) {
            String s = webRootLocations.get(i);
            XModelObject o = rs.get(i);
            if (!o.getAttributeValue("location").equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    List<XModelObject> getExistingWebRoots(XModelObject fs) {
        XModelObject[] cs;
        ArrayList<XModelObject> result = new ArrayList<XModelObject>();
        XModelObject[] xModelObjectArray = cs = fs.getChildren("FileSystemFolder");
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            if (c.getAttributeValue("name").startsWith(WEB_ROOT)) {
                result.add(c);
            }
            ++n2;
        }
        return result;
    }

    static List<String> getWebRootPaths(IProject project, String webInfLocation) {
        IContainer[] cs;
        ArrayList<String> result = new ArrayList<String>();
        IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders((IProject)project);
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            IPath path = c.getLocation();
            if (path != null) {
                String webRootLocation = null;
                try {
                    webRootLocation = path.toFile().getCanonicalPath().replace('\\', '/');
                    String relative = FileUtil.getRelativePath((String)webInfLocation, (String)webRootLocation);
                    if (relative != null) {
                        webRootLocation = String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
                    }
                    result.add(webRootLocation);
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
        return result;
    }

    static String getWebInfPath(IProject project, String webInfLocation) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.getRootFolder() != null) {
            IContainer[] cs;
            String virtual = null;
            IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders((IProject)project, (boolean)true);
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                if (c.exists()) {
                    String relative;
                    String location;
                    IFolder f = c.getFolder((IPath)new Path("/WEB-INF"));
                    if (f.exists()) {
                        try {
                            location = f.getLocation().toFile().getCanonicalPath().replace('\\', '/');
                            relative = FileUtil.getRelativePath((String)webInfLocation, (String)location);
                            return relative != null ? String.valueOf(XModelConstants.WORKSPACE_REF) + relative : location;
                        }
                        catch (IOException iOException) {}
                    } else if (virtual == null) {
                        try {
                            location = String.valueOf(c.getLocation().toFile().getCanonicalPath().replace('\\', '/')) + "/WEB-INF";
                            relative = FileUtil.getRelativePath((String)webInfLocation, (String)location);
                            virtual = relative != null ? String.valueOf(XModelConstants.WORKSPACE_REF) + relative : location;
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++n2;
            }
            if (virtual != null) {
                return virtual;
            }
        }
        return null;
    }
}

