/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.ArrayList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.trees.FileSystemsTree;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.model.pv.JSFProjectBeans;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class JSFProjectsTree
extends FileSystemsTree
implements XModelTreeListener {
    JSFProjectsRoot root = null;
    XModelObject webinf = null;

    protected boolean isConstraintRelevant(String key) {
        return super.isConstraintRelevant(key) || key.startsWith("JSFProjects$");
    }

    public void setModel(XModel model) {
        super.setModel(model);
        this.root = (JSFProjectsRoot)model.getByPath("root:JSFProjects");
        if (this.root == null) {
            this.root = (JSFProjectsRoot)model.createModelObject("JSFProjectsRoot", null);
            ((XModelImpl)model).setExtraRoot((XModelObject)this.root);
            model.addModelTreeListener((XModelTreeListener)this);
        } else {
            this.root.invalidate();
        }
    }

    public static JSFProjectsRoot getProjectsRoot(XModel model) {
        JSFProjectsRoot root = (JSFProjectsRoot)model.getByPath("root:JSFProjects");
        if (root == null) {
            root = (JSFProjectsRoot)XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"JSFProjectsRoot");
            ((XModelImpl)model).setExtraRoot((XModelObject)root);
        }
        return root;
    }

    public XModelObject getRoot() {
        return this.root;
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (object instanceof WebProjectNode) {
            return ((WebProjectNode)object).getTreeChildren();
        }
        if (object == this.root.webroot) {
            XModelObject[] cs = super.getChildren(object);
            this.webinf = object.getModel().getByPath("FileSystems/WEB-INF");
            if (this.webinf == null) {
                return cs;
            }
            ArrayList<XModelObject> l = new ArrayList<XModelObject>();
            int i = 0;
            while (i < cs.length) {
                l.add(cs[i]);
                ++i;
            }
            if (this.webinf != null) {
                l.add(this.webinf);
            }
            cs = l.toArray(new XModelObject[0]);
            return cs;
        }
        return super.getChildren(object);
    }

    public XModelObject getParent(XModelObject object) {
        return object == this.root ? null : (object == this.webinf ? this.root.webroot : this.root.getTreeParent(object));
    }

    public boolean hasChildren(XModelObject object) {
        return object instanceof WebProjectNode || super.hasChildren(object);
    }

    public XModelObject getRepresentation(XModelObject object) {
        if (object != null && "FileJAVA".equals(object.getModelEntity().getName())) {
            String p = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
            if (p == null || !p.endsWith(".java")) {
                return object;
            }
            p = p.substring(1, p.length() - 5).replace('/', '.');
            JSFProjectBeans beans = (JSFProjectBeans)this.root.getChildByPath("Beans");
            XModelObject[] bs = beans == null ? new XModelObject[]{} : beans.getTreeChildren();
            int i = 0;
            while (i < bs.length) {
                if (p.equals(bs[i].getAttributeValue("class name"))) {
                    return bs[i];
                }
                ++i;
            }
        }
        return object;
    }

    public void nodeChanged(XModelTreeEvent event) {
    }

    public void structureChanged(XModelTreeEvent event) {
        XModelObject source = event.getModelObject();
        String entity = source.getModelEntity().getName();
        if (event.kind() == 3 && "FileSystemJar".equals(entity) && this.root != null) {
            this.root.invalidate();
        }
    }
}

