/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.pages;

import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.web.JSFWebProject;
import org.jboss.tools.jst.web.tld.IFilePathEncoder;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;

public class FilePathEncoder
implements IFilePathEncoder {
    static String NO_JSF_URL = ".composition.decorate.include.";

    public String encode(String path, XModelObject f, String tag, VpeTaglibManager taglibs, Properties context) {
        String prefix;
        if (tag != null && tag.startsWith("/") && (tag = tag.substring(1)).indexOf(64) >= 0) {
            tag = tag.substring(0, tag.indexOf(64));
        }
        String pathType = context.getProperty("pathType");
        String pathAddition = context.getProperty("pathAddition");
        if (!(this.isPath(path) || pathAddition != null && path.startsWith(pathAddition))) {
            return path;
        }
        int d = tag.indexOf(":");
        String string = prefix = d < 0 ? "" : tag.substring(0, d);
        if (d > 0) {
            tag = tag.substring(d + 1);
        }
        if (prefix.equals("jsp")) {
            return path;
        }
        String uri = this.getUri(prefix, taglibs);
        if (!"relative".equals(pathType)) {
            JSFWebProject wp = JSFWebProject.getInstance(f.getModel());
            if (uri != null && wp.getUrlPattern().isJSFUrl(path) && path.indexOf(47) >= 0 && !this.doNotEncodeToJSFURL(uri, tag)) {
                path = wp.getUrlPattern().getJSFUrl(path);
            }
            if (pathAddition != null) {
                path = String.valueOf(pathAddition) + path;
            }
        } else {
            String current = XModelObjectLoaderUtil.getResourcePath((XModelObject)f.getParent());
            if (current == null || current.length() == 0) {
                current = "";
            }
            String fake = "FAKE:/" + path;
            String root = "FAKE:/" + current;
            String p = FileUtil.getRelativePath((String)root, (String)fake);
            if (p != null && (path = p).startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    public String decode(String path, XModelObject f, String tag, VpeTaglibManager taglibs, Properties context) {
        String prefix;
        if (tag != null && tag.startsWith("/") && (tag = tag.substring(1)).indexOf(64) >= 0) {
            tag = tag.substring(0, tag.indexOf(64));
        }
        String pathType = context.getProperty("pathType");
        String pathAddition = context.getProperty("pathAddition");
        if (!(this.isPath(path) || pathAddition != null && path.startsWith(pathAddition))) {
            return path;
        }
        int d = tag.indexOf(":");
        String string = prefix = d < 0 ? "" : tag.substring(0, d);
        if (d > 0) {
            tag = tag.substring(d);
        }
        if (prefix.equals("jsp")) {
            return path;
        }
        String uri = this.getUri(prefix, taglibs);
        if (!"relative".equals(pathType)) {
            if (pathAddition != null && path.startsWith(pathAddition)) {
                path = path.substring(pathAddition.length());
            }
            JSFWebProject wp = JSFWebProject.getInstance(f.getModel());
            if (uri != null && wp.getUrlPattern().isJSFUrl("/" + path) && path.indexOf(46) >= 0) {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                path = wp.getUrlPattern().getJSFPath(path);
            }
        } else {
            String current = XModelObjectLoaderUtil.getResourcePath((XModelObject)f.getParent());
            if (current == null || current.length() == 0) {
                current = "";
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            while (path.startsWith("/..")) {
                path = path.substring(3);
                d = current.lastIndexOf(47);
                if (d < 0) continue;
                current = current.substring(0, d);
            }
            path = String.valueOf(current) + path;
        }
        return path;
    }

    String getUri(String prefix, VpeTaglibManager taglibs) {
        if (taglibs == null) {
            return null;
        }
        TaglibData[] data = taglibs.getTagLibs().toArray(new TaglibData[0]);
        int i = 0;
        while (i < data.length) {
            if (prefix.equals(data[i].getPrefix())) {
                return data[i].getUri();
            }
            ++i;
        }
        return null;
    }

    boolean isPath(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.indexOf(123) > 0) {
            return false;
        }
        if (path.indexOf(125) > 0) {
            return false;
        }
        return path.indexOf(35) <= 0;
    }

    boolean doNotEncodeToJSFURL(String uri, String tag) {
        return NO_JSF_URL.indexOf("." + tag + ".") >= 0 && "http://java.sun.com/jsf/facelets".equals(uri);
    }
}

