/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.converter;

import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class OpenTagLib {
    public String run(XModel model, String uri, String tag, String attribute) {
        if (model == null || uri == null) {
            return null;
        }
        if (uri.length() == 0) {
            return JSFUIMessages.URI_ISNOT_SPECIFIED;
        }
        XModelObject t = this.findTagLib(model, uri, tag, attribute);
        if (t == null) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_TAG_LIBRARY, (Object)uri);
        }
        FindObjectHelper.findModelObject((XModelObject)t, (int)FindObjectHelper.IN_EDITOR_ONLY);
        if (tag != null) {
            if (tag.length() == 0) {
                return JSFUIMessages.TAG_ISNOT_SPECIFIED;
            }
            if ((t = this.findTag(t, tag)) == null) {
                return NLS.bind((String)JSFUIMessages.CANNOT_FIND_TAG_IN_LIBRARY, (Object)tag, (Object)uri);
            }
            FindObjectHelper.findModelObject((XModelObject)t, (int)FindObjectHelper.IN_EDITOR_ONLY);
        }
        if (attribute != null) {
            if (attribute.length() == 0) {
                return JSFUIMessages.ATTRIBUTE_ISNOT_SPECIFIED;
            }
            if ((t = this.findAttribute(t, attribute)) == null) {
                return NLS.bind((String)JSFUIMessages.CANNOT_FIND_ATTRIBUTE_IN_TAG, (Object)attribute, (Object)tag);
            }
            FindObjectHelper.findModelObject((XModelObject)t, (int)FindObjectHelper.IN_EDITOR_ONLY);
        }
        return null;
    }

    private XModelObject findTagLib(XModel model, String uri, String tag, String attribute) {
        IKbProject kb;
        XModelObject some = null;
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return null;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Tag Libraries");
        if (n == null) {
            return null;
        }
        XModelObject[] os = n.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            if (uri.equals(os[i].getAttributeValue("uri"))) {
                if (this.isOk(os[i], tag, attribute)) {
                    return os[i];
                }
                some = os[i];
            }
            ++i;
        }
        IProject project = EclipseResourceUtil.getProject((XModelObject)root);
        if (project != null && (kb = KbProjectFactory.getKbProject((IProject)project, (boolean)true)) != null) {
            ITagLibrary[] ls = kb.getTagLibraries(uri);
            int i2 = 0;
            while (i2 < ls.length) {
                XModelObject lib;
                Object id = ((KbObject)ls[i2]).getId();
                if (id instanceof XModelObject && this.isOk(lib = (XModelObject)id, tag, attribute)) {
                    return lib;
                }
                ++i2;
            }
        }
        return some;
    }

    private boolean isOk(XModelObject lib, String tag, String attribute) {
        if (tag != null) {
            XModelObject a;
            XModelObject t = this.findTag(lib, tag);
            if (t == null) {
                return false;
            }
            if (t != null && attribute != null && (a = this.findAttribute(t, attribute)) == null) {
                return false;
            }
        }
        return true;
    }

    private XModelObject findTag(XModelObject taglib, String name) {
        return taglib.getChildByPath(name);
    }

    private XModelObject findAttribute(XModelObject tag, String name) {
        return tag.getChildByPath(name);
    }
}

