/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.bean;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.java.generation.JavaPropertyGenerator;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.constraint.XAttributeConstraint;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintJavaName;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.model.handlers.ChangeContentKindHandler;
import org.jboss.tools.jsf.model.handlers.bean.ClassExistsCheck;
import org.jboss.tools.jsf.model.helpers.bean.BeanHelper;

public class AddManagedPropertySupport
extends SpecialWizardSupport {
    ClassExistsCheck classCheck = new ClassExistsCheck();
    JavaPropertyGenerator generator = new JavaPropertyGenerator();
    XAttributeConstraintJavaName constraint = new XAttributeConstraintJavaName();
    Map<String, IJavaElement> fields;
    boolean isLight = false;
    XEntityData lightData = XEntityDataImpl.create((String[][])new String[][]{{"AddJSFManagedPropertyWizard", "yes"}, {"property-name", "yes"}, {"property-class", "no"}, {"value-kind", "no"}, {"value", "no"}});
    protected DefaultWizardDataValidator validator = new PropertyValidator();

    public void reset() {
        int i;
        if (this.isLight) {
            XEntityData d = this.getEntityData()[0];
            this.getEntityData()[0] = this.lightData;
            XAttributeData[] ad = d.getAttributeData();
            i = 0;
            while (i < ad.length) {
                String n = ad[i].getAttribute().getName();
                this.lightData.setValue(n, d.getValue(n));
                ++i;
            }
        }
        if (ChangeContentKindHandler.isNewValueKind(this.getTarget(), "properties") && !ChangeContentKindHandler.checkChangeSignificance(this.getTarget())) {
            this.setFinished(true);
            return;
        }
        this.classCheck.setModelContext(this.getTarget());
        String s = this.getTarget().getAttributeValue("managed-bean-class");
        if (s == null) {
            s = "";
        }
        this.classCheck.update(s);
        try {
            this.fields = BeanHelper.getJavaProperties(this.classCheck.getExistingClass());
        }
        catch (JavaModelException javaModelException) {
            this.fields = new TreeMap<String, IJavaElement>();
        }
        XModelObject[] cs = this.getTarget().getChildren("JSFManagedProperty");
        i = 0;
        while (i < cs.length) {
            this.fields.remove(cs[i].getAttributeValue("property-name"));
            ++i;
        }
        String[] fs = this.fields.keySet().toArray(new String[0]);
        this.setValueList(0, "property-name", fs);
        if (this.isLight) {
            this.setAttributeValue(0, "add java property", "false");
        }
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL, HELP};
    }

    void execute() throws XModelException {
        Properties p = this.extractStepData(0);
        this.getTarget().setAttributeValue("content-kind", "properties");
        String entity = this.action.getProperty("entity");
        XModelObject c = XModelObjectLoaderUtil.createValidObject((XModel)this.getTarget().getModel(), (String)entity, (Properties)p);
        DefaultCreateHandler.addCreatedObject((XModelObject)this.getTarget(), (XModelObject)c, (Properties)this.getProperties());
        this.getProperties().put("created", c);
        if (!this.isGenerationOn(p)) {
            return;
        }
        try {
            this.generate(p);
        }
        catch (CoreException e) {
            throw new XModelException((Throwable)e);
        }
    }

    boolean isGenerationOn(Properties p) {
        if (!"true".equals(p.getProperty("add java property"))) {
            return false;
        }
        return this.isFieldEditorEnabled(0, "add java property", p);
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        boolean canGenerateField;
        String pn = values.getProperty("property-name");
        String vk = values.getProperty("value-kind");
        boolean canGenerate = this.classCheck.isValid() && this.classCheck.classExists() && !this.classCheck.getExistingClass().isBinary();
        boolean bl = canGenerateField = !this.fields.containsKey(pn);
        if ("add java property".equals(name)) {
            return !this.isLight && canGenerate && canGenerateField;
        }
        if ("generate getter".equals(name) || "generate setter".equals(name)) {
            boolean agp = "true".equals(values.getProperty("add java property"));
            return agp && canGenerate && canGenerateField;
        }
        if ("value".equals(name)) {
            return "value".equals(vk);
        }
        return true;
    }

    public String getFieldType(String name) {
        IMember m = (IMember)this.fields.get(name);
        return m == null ? null : EclipseJavaUtil.getMemberTypeAsString((IMember)m);
    }

    void generate(Properties p) throws CoreException {
        this.generator.setOwner(this.classCheck.getExistingClass());
        String type = p.getProperty("property-class");
        if (type.length() == 0) {
            type = "String";
        }
        String name = p.getProperty("property-name");
        boolean getter = "true".equals(p.getProperty("generate getter"));
        boolean setter = "true".equals(p.getProperty("generate setter"));
        this.generator.generate(name, type, "public", true, getter, setter);
    }

    public String getStepImplementingClass(int stepId) {
        return "org.jboss.tools.jsf.ui.wizard.bean.AddManagedBeanPropertyScreen";
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    class PropertyValidator
    extends DefaultWizardDataValidator {
        PropertyValidator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String propertyName = data.getProperty("property-name");
            this.message = DefaultCreateHandler.getConstraintMessage((String)"property-name", (String)propertyName, (XAttributeConstraint)AddManagedPropertySupport.this.constraint);
        }
    }
}

