/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.java.generation.JavaPropertyGenerator;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.helpers.bean.BeanHelper;

public class AddManagedBeanPropertiesContext {
    IType type = null;
    Map<String, IJavaElement> properties = null;
    boolean[] enablement = new boolean[0];
    String[] names = new String[0];
    String[] values = new String[0];

    public void setType(IType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.properties = new HashMap<String, IJavaElement>();
        try {
            this.properties = BeanHelper.getJavaProperties(type);
        }
        catch (JavaModelException javaModelException) {}
        if (this.properties.size() != this.enablement.length) {
            this.enablement = new boolean[this.properties.size()];
            this.names = new String[this.properties.size()];
            this.values = new String[this.properties.size()];
        }
        this.names = this.properties.keySet().toArray(new String[0]);
        int i = 0;
        while (i < this.names.length) {
            this.enablement[i] = false;
            this.values[i] = "";
            ++i;
        }
    }

    public int size() {
        return this.enablement.length;
    }

    public boolean isEnabled(int i) {
        return i >= 0 && i < this.size() && this.enablement[i];
    }

    public void setEnabled(int i, boolean v) {
        if (i >= 0 && i < this.size()) {
            this.enablement[i] = v;
        }
    }

    public String getName(int i) {
        return this.names[i];
    }

    public String getValue(int i) {
        return this.values[i];
    }

    public void setValue(int i, String v) {
        this.values[i] = v;
    }

    public void addProperties(XModelObject bean) throws XModelException, CoreException {
        ArrayList<PropertyData> toGenerate = new ArrayList<PropertyData>();
        int applyForAll = 0;
        int i = 0;
        while (i < this.names.length) {
            if (this.enablement[i]) {
                PropertyData data = new PropertyData();
                data.name = this.names[i];
                XModelObject p = bean.getModel().createModelObject("JSFManagedProperty", null);
                IMember m = (IMember)this.properties.get(this.names[i]);
                data.type = EclipseJavaUtil.getMemberTypeAsString((IMember)m);
                p.setAttributeValue("property-name", data.name);
                p.setAttributeValue("property-class", data.type);
                p.setAttributeValue("value", this.values[i]);
                bean.addChild(p);
                if (!(this.type.isBinary() || this.type.isInterface() || m instanceof IMethod)) {
                    boolean setter;
                    boolean getter = BeanHelper.findGetter(this.type, this.names[i]) != null;
                    boolean bl = setter = BeanHelper.findSetter(this.type, this.names[i]) != null;
                    if (!getter || !setter) {
                        if (applyForAll == 0) {
                            String message = this.getMessage(getter, setter, this.names[i]);
                            ServiceDialog d = bean.getModel().getService();
                            Properties cp = new Properties();
                            cp.setProperty("message", message);
                            cp.put("checked", Boolean.FALSE);
                            cp.setProperty("checkboxMessage", JSFUIMessages.APPLY_FOR_ALL_PROPERTIES);
                            cp.put("buttons", new String[]{JSFUIMessages.YES, JSFUIMessages.NO});
                            boolean q = d.openConfirm(cp);
                            boolean b = (Boolean)cp.get("checked");
                            if (b) {
                                int n = applyForAll = q ? 1 : -1;
                            }
                            if (q) {
                                data.getter = !getter;
                                data.setter = !setter;
                                toGenerate.add(data);
                            }
                        } else if (applyForAll > 0) {
                            data.getter = !getter;
                            data.setter = !setter;
                            toGenerate.add(data);
                        }
                    }
                }
            }
            ++i;
        }
        PropertyData[] datas = toGenerate.toArray(new PropertyData[0]);
        JavaPropertyGenerator g = new JavaPropertyGenerator();
        g.setOwner(this.type);
        int i2 = 0;
        while (i2 < datas.length) {
            g.generate(datas[i2].name, datas[i2].type, "public", false, datas[i2].getter, datas[i2].setter);
            ++i2;
        }
    }

    private String getMessage(boolean getter, boolean setter, String name) {
        if (!getter && !setter) {
            return NLS.bind((String)JSFUIMessages.ADD_GETTER_SETTER_FOR_PROPERTY, (Object)name);
        }
        if (!getter && setter) {
            return NLS.bind((String)JSFUIMessages.ADD_GETTER_FOR_PROPERTY, (Object)name);
        }
        return NLS.bind((String)JSFUIMessages.ADD_SETTER_FOR_PROPERTY, (Object)name);
    }

    class PropertyData {
        String name;
        String type;
        boolean getter;
        boolean setter;

        PropertyData() {
        }
    }
}

