/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.FileFacesConfigImpl;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.handlers.AddViewSupport;
import org.jboss.tools.jsf.model.helpers.JSFProcessHelper;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jsf.model.impl.NavigationRuleObjectImpl;
import org.jboss.tools.jst.web.model.ReferenceObject;

public class RenameViewSupport
extends SpecialWizardSupport
implements JSFConstants {
    String initialPath;
    ReferenceGroupImpl group;
    XModelObject page;
    ReferenceObject item;
    protected DefaultWizardDataValidator viewValidator = new ViewValidator();

    public void reset() {
        this.initGroup();
        this.initialPath = this.group.getAttributeValue("path");
        this.initialPath = AddViewSupport.revalidatePath(this.initialPath);
        this.page = JSFProcessHelper.isPattern(this.initialPath) ? null : this.getTarget().getModel().getByPath(this.initialPath);
        this.setAttributeValue(0, "from-view-id", this.initialPath);
    }

    void initGroup() {
        String entity = this.getTarget().getModelEntity().getName();
        this.item = null;
        if ("JSFProcessGroup".equals(entity)) {
            this.group = (ReferenceGroupImpl)this.getTarget();
        } else if ("JSFProcessItem".equals(entity)) {
            this.group = (ReferenceGroupImpl)this.getTarget().getParent();
            if (this.group.getChildren().length > 1) {
                this.item = (ReferenceObject)this.getTarget();
            }
        }
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL, HELP};
    }

    void execute() throws XModelException {
        block7: {
            Properties p = this.extractStepData(0);
            String path = AddViewSupport.revalidatePath(p.getProperty("from-view-id"));
            if (this.initialPath.equals(path)) {
                return;
            }
            JSFProcessHelper h = JSFProcessHelper.getHelper(JSFProcessStructureHelper.instance.getProcess((XModelObject)this.group));
            h.addUpdateLock(this);
            try {
                if (this.item != null) {
                    this.extract(this.initialPath, path);
                    break block7;
                }
                RenameViewSupport.replace(this.group, this.initialPath, path);
                if (this.page == null || !"true".equals(p.getProperty("rename file")) || !this.isFieldEditorEnabled(0, "rename file", p)) break block7;
                try {
                    RenameViewSupport.renameFile(this.page, path);
                }
                catch (CoreException e) {
                    throw new XModelException((Throwable)e);
                }
            }
            finally {
                h.removeUpdateLock(this);
                h.updateProcess();
            }
        }
    }

    public boolean isActionEnabled(String name) {
        if (FINISH.equals(name)) {
            String path = this.getAttributeValue(0, "from-view-id");
            if (this.initialPath.equals(path = AddViewSupport.revalidatePath(path))) {
                return false;
            }
        }
        return true;
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        if (name.equals("rename file")) {
            if (this.page == null) {
                return false;
            }
            if (this.item != null) {
                return false;
            }
            String path = AddViewSupport.revalidatePath(values.getProperty("from-view-id"));
            if (path.equals(this.initialPath)) {
                return false;
            }
            if (JSFProcessHelper.isPattern(path)) {
                return false;
            }
            XModelObject page2 = this.getTarget().getModel().getByPath(path);
            if (page2 != null) {
                return false;
            }
        }
        return true;
    }

    public static void replace(ReferenceGroupImpl group, String oldPath, String newPath) throws XModelException {
        String ppi;
        String pp = NavigationRuleObjectImpl.toNavigationRulePathPart(newPath);
        boolean isPattern = JSFProcessHelper.isPattern(newPath);
        XModel model = group.getModel();
        XModelObject process = group.getParent();
        FileFacesConfigImpl fcg = (FileFacesConfigImpl)process.getParent();
        int count = fcg.getRuleCount(newPath);
        XModelObject[] rs = group.getReferences();
        int i = rs.length - 1;
        while (i >= 0) {
            model.changeObjectAttribute(rs[i], "index", "1000");
            model.changeObjectAttribute(rs[i], "from-view-id", newPath);
            model.changeObjectAttribute(rs[i], "index", "" + (count + i));
            --i;
        }
        if (process.getChildByPath(pp) == null) {
            model.changeObjectAttribute((XModelObject)group, "name", pp);
            model.changeObjectAttribute((XModelObject)group, "path", newPath);
        } else if (isPattern && rs.length > 0) {
            String index = rs[0].getAttributeValue("index");
            ppi = String.valueOf(pp) + ":" + index;
            group.setAttributeValue("path", newPath);
            if (process.getChildByPath(ppi) == null) {
                model.changeObjectAttribute((XModelObject)group, "name", ppi);
            }
        } else if (isPattern && rs.length == 0) {
            int index = -1;
            while (process.getChildByPath(String.valueOf(pp) + ":" + index) != null) {
                --index;
            }
            ppi = String.valueOf(pp) + ":" + index;
            model.changeObjectAttribute((XModelObject)group, "path", newPath);
            model.changeObjectAttribute((XModelObject)group, "name", ppi);
        } else if (!isPattern && rs.length == 0) {
            DefaultRemoveHandler.removeFromParent((XModelObject)group);
        }
        XModelObject[] gs = process.getChildren("JSFProcessGroup");
        int i2 = 0;
        while (i2 < gs.length) {
            XModelObject[] is = gs[i2].getChildren("JSFProcessItem");
            int j = 0;
            while (j < is.length) {
                XModelObject[] os = is[j].getChildren("JSFProcessItemOutput");
                int k = 0;
                while (k < os.length) {
                    ReferenceObject output;
                    XModelObject c;
                    if (oldPath.equals(os[k].getAttributeValue("path")) && (c = (output = (ReferenceObject)os[k]).getReference()) != null) {
                        model.changeObjectAttribute(c, "to-view-id", newPath);
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void renameFile(XModelObject page, String path) throws XModelException, CoreException {
        IResource r = (IResource)page.getAdapter(IResource.class);
        String initialPath = XModelObjectLoaderUtil.getResourcePath((XModelObject)page);
        String p = r.getFullPath().toString();
        if (!p.toLowerCase().endsWith(initialPath.toLowerCase())) {
            return;
        }
        p = String.valueOf(p.substring(0, p.length() - initialPath.length())) + path;
        Path np = new Path(p);
        RenameViewSupport.provideParent((IResource)r.getWorkspace().getRoot().getFile((IPath)np));
        r.move((IPath)np, true, null);
        page.getModel().update();
    }

    public static void provideParent(IResource resource) throws XModelException, CoreException {
        IContainer parent = resource.getParent();
        if (parent.exists()) {
            return;
        }
        IFolder folder = resource.getWorkspace().getRoot().getFolder(parent.getFullPath());
        RenameViewSupport.provideParent((IResource)folder);
        folder.create(true, true, null);
    }

    private void extract(String oldPath, String newPath) throws XModelException {
        String pp = NavigationRuleObjectImpl.toNavigationRulePathPart(newPath);
        XModel model = this.group.getModel();
        XModelObject process = this.group.getParent();
        FileFacesConfigImpl fcg = (FileFacesConfigImpl)process.getParent();
        int count = fcg.getRuleCount(newPath);
        XModelObject rule = this.item.getReference();
        model.changeObjectAttribute(rule, "index", "1000");
        model.changeObjectAttribute(rule, "from-view-id", newPath);
        model.changeObjectAttribute(rule, "index", "" + count);
        XModelObject g = process.getChildByPath(pp);
        if (g != null) {
            return;
        }
        JSFProcessHelper h = JSFProcessHelper.getHelper(process);
        g = h.findOrCreateGroup(newPath, pp);
        int[] cs = JSFProcessStructureHelper.instance.asIntArray((XModelObject)this.group, "shape");
        if (cs != null && cs.length > 1) {
            g.setAttributeValue("shape", cs[0] + 30 + "," + (cs[1] + 30) + ",0,0");
        }
    }

    public WizardDataValidator getValidator(int step) {
        this.viewValidator.setSupport((SpecialWizardSupport)this, step);
        return this.viewValidator;
    }

    class ViewValidator
    extends DefaultWizardDataValidator {
        ViewValidator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String path = data.getProperty("from-view-id");
            if (!AddViewSupport.isCorrectPath(path)) {
                this.message = JSFUIMessages.ATTRIBUTE_FROM_VIEW_ID_IS_NOT_CORRECT;
            }
            if (this.message != null) {
                return;
            }
        }
    }
}

